/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysoRedirect
extends IsAliveThread {
    private static Logger log = LoggerFactory.getLogger(SysoRedirect.class);
    private static final String UNRECOGNIZED_SUN_JO = "Unrecognized option: \"-javaagent";
    private InputStream m_inputStream;
    private String m_line;
    private StringBuffer m_stringBuffer = new StringBuffer();
    private final String m_sysoPrefix;
    private boolean m_removedLines = false;

    public SysoRedirect(InputStream inputStream, String sysoPrefix) {
        super("Stream Redirect");
        this.m_inputStream = inputStream;
        this.m_sysoPrefix = sysoPrefix;
    }

    public void run() {
        try {
            InputStreamReader isr = new InputStreamReader(this.m_inputStream);
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                System.out.println(String.valueOf(this.m_sysoPrefix) + line);
                this.writeLine(line);
                if (line.indexOf(UNRECOGNIZED_SUN_JO) > -1) {
                    this.m_line = line;
                }
                line = br.readLine();
            }
        }
        catch (IOException ioe) {
            log.debug("input stream closed", (Throwable)ioe);
        }
    }

    public String getLine() {
        return this.m_line;
    }

    private void writeLine(String string) {
        if (this.m_stringBuffer.length() > 10000) {
            int i = this.m_stringBuffer.indexOf("\n");
            this.m_stringBuffer.delete(0, i + "\n".length());
            this.m_stringBuffer.trimToSize();
            this.m_removedLines = true;
        }
        this.m_stringBuffer.append(String.valueOf(string) + "\n");
    }

    public String getTruncatedLog() {
        if (this.m_removedLines) {
            return "...\n" + this.m_stringBuffer.toString();
        }
        return this.m_stringBuffer.toString();
    }
}

