/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.AbstractComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;

public class ObjectMappingComponentNameMapper
extends AbstractComponentNameMapper {
    public ObjectMappingComponentNameMapper(IWritableComponentNameCache componentNameCache, IAUTMainPO aut) {
        super(componentNameCache, aut);
        this.initCompNameCache(aut);
    }

    public void initCompNameCache(IAUTMainPO aut) {
        HashSet<String> guids = new HashSet<String>();
        aut.getParentProjectId();
        Set<IObjectMappingAssoziationPO> links = aut.getObjMap().getMappings();
        for (IObjectMappingAssoziationPO link : links) {
            guids.addAll(link.getLogicalNames());
        }
        this.getCompNameCache().initCache(guids, aut.getParentProjectId());
    }

    @Override
    protected IAUTMainPO getContext() {
        return (IAUTMainPO)super.getContext();
    }

    @Override
    public void handleExistingNames(Map<String, String> guidToCompNameMap) {
        for (IObjectMappingAssoziationPO assoc : this.getContext().getObjMap().getMappings()) {
            HashSet<String> guidIntersection = new HashSet<String>(assoc.getLogicalNames());
            guidIntersection.retainAll(guidToCompNameMap.keySet());
            for (String guid : guidIntersection) {
                assoc.removeLogicalName(guid);
                assoc.addLogicalName(guidToCompNameMap.get(guid));
            }
        }
    }

    @Override
    public Set<String> getUsedTypes(String compNameGuid) {
        Long currentProjectId = GeneralStorage.getInstance().getProject().getId();
        HashSet<String> typeSet = new HashSet<String>();
        HashSet<Long> autIds = new HashSet<Long>();
        autIds.add(this.getContext().getId());
        for (IObjectMappingAssoziationPO assoc : this.getContext().getObjMap().getMappings()) {
            if (!assoc.getLogicalNames().contains(compNameGuid)) continue;
            List availableComponents = ComponentBuilder.getInstance().getCompSystem().getComponents(this.getFilterToolkitId(), true);
            String impliedType = assoc.getComponentType(this.getCompNameCache(), availableComponents);
            if (impliedType == null) continue;
            typeSet.add(impliedType);
        }
        typeSet.addAll(CompNamePM.getReuseTypes(GeneralStorage.getInstance().getMasterSession(), currentProjectId, compNameGuid, new HashSet<Long>(), new HashSet<Long>(), autIds));
        return typeSet;
    }

    @Override
    protected String getFilterToolkitId() {
        return this.getContext().getToolkit();
    }
}

