/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.businessprocess.compcheck.ProblemPropagator;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.rules.SingleJobRule;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.teststyle.ExtensionHelper;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.checks.CheckCont;
import org.eclipse.jubula.client.teststyle.checks.contexts.BaseContext;
import org.eclipse.jubula.client.teststyle.gui.TeststyleProblemAdder;
import org.eclipse.jubula.client.teststyle.gui.decoration.DecoratorHandler;
import org.eclipse.jubula.client.teststyle.i18n.Messages;
import org.eclipse.jubula.client.teststyle.problems.ProblemCont;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TeststyleHandler
implements DataEventDispatcher.IDataChangedListener,
DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.IProjectStateListener {
    private static TeststyleHandler instance;
    private static final Logger LOG;

    static {
        LOG = LoggerFactory.getLogger(TeststyleHandler.class);
    }

    private TeststyleHandler() {
        DataEventDispatcher.getInstance().addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, false);
        this.addToListener();
    }

    public static TeststyleHandler getInstance() {
        if (instance == null) {
            instance = new TeststyleHandler();
        }
        return instance;
    }

    public void handleProjectLoaded() {
        if (GeneralStorage.getInstance().getProject() == null) {
            return;
        }
        ExtensionHelper.initCheckConfiguration();
        this.doCompleteCheck();
        ProblemPropagator.INSTANCE.propagate();
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        if (!this.isEnabled()) {
            return;
        }
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            if (e.getUpdateState() != DataEventDispatcher.UpdateState.onlyInEditor) {
                TestStyleJob tj = new TestStyleJob("Teststyle", events);
                tj.setRule(SingleJobRule.TESTSTYLERULE);
                JobUtils.executeJob((Job)tj, null);
                Job[] jobArray = Job.getJobManager().find((Object)tj);
                int n3 = jobArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Job job = jobArray[n4];
                    if (job != tj) {
                        job.cancel();
                    }
                    ++n4;
                }
                return;
            }
            ++n2;
        }
    }

    private void handleChangedPo(IPersistentObject po, DataEventDispatcher.DataState dataState, DataEventDispatcher.UpdateState updateState) {
        ProblemCont.instance.remove(po);
        switch (dataState) {
            case Renamed: 
            case Added: 
            case StructureModified: 
            case ReuseChanged: {
                this.check(po);
                break;
            }
        }
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            ProblemCont.instance.remove(project);
            this.check(project);
        }
        if (po instanceof ISpecTestCasePO || po instanceof ITestSuitePO || po instanceof ITestJobPO) {
            INodePO node = (INodePO)po;
            Iterator iter = node.getNodeListIterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof IParamNodePO)) continue;
                IParamNodePO paramNode = (IParamNodePO)next;
                this.handleChangedPo((IPersistentObject)paramNode, dataState, updateState);
            }
            if (node instanceof ISpecTestCasePO) {
                ISpecTestCasePO specTc = (ISpecTestCasePO)node;
                Collection c = specTc.getAllEventEventExecTC();
                for (IEventExecTestCasePO eh : c) {
                    this.handleChangedPo((IPersistentObject)eh, dataState, updateState);
                }
            }
        }
    }

    public void check(Object obj) {
        BaseContext context = BaseContext.getFor(obj.getClass());
        List<BaseCheck> checks = CheckCont.getChecksFor(context);
        for (BaseCheck check : checks) {
            if (!check.isActive(context) || !check.hasError(obj)) continue;
            if (obj instanceof ITestDataCubePO) {
                ProblemCont.instance.add(((ITestDataCubePO)obj).getId(), check);
                continue;
            }
            ProblemCont.instance.add(obj, check);
        }
    }

    public void doCompleteCheck() {
        CompleteTestStyleCheckJob checkEverythingJob = new CompleteTestStyleCheckJob("TestStyle - complete");
        checkEverythingJob.setRule(SingleJobRule.TESTSTYLERULE);
        JobUtils.executeJob((Job)checkEverythingJob, null);
        try {
            checkEverythingJob.join();
        }
        catch (InterruptedException e) {
            LOG.warn("Error waiting for Job TestStyle job", (Throwable)e);
        }
    }

    private void addTeststyleProblems(IProgressMonitor monitor) throws JBException {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            throw new JBException("Project is null", MessageIDs.E_PROJECT_NOT_FOUND);
        }
        TeststyleProblemAdder op = new TeststyleProblemAdder();
        TreeTraverser traverser = new TreeTraverser((INodePO)project, (ITreeNodeOperation)op);
        if (monitor != null) {
            traverser.setMonitor(monitor);
        }
        traverser.traverse(true);
    }

    public void addToListener() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
        ded.addProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
    }

    public void removeFromListener() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
        ded.removeProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
    }

    public void start() {
        ExtensionHelper.initChecks();
        if (this.isEnabled()) {
            this.addToListener();
        }
    }

    public void stop() {
        if (this.isEnabled()) {
            this.removeFromListener();
        }
        ProblemCont.instance.clear();
    }

    public void refresh() {
        DecoratorHandler.refresh();
    }

    public boolean isEnabled() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project == null) {
            return false;
        }
        return project.getProjectProperties().getCheckConfCont().getEnabled();
    }

    public void handleProjectStateChanged(DataEventDispatcher.ProjectState state) {
        switch (state) {
            case prop_modified: {
                this.doCompleteCheck();
                break;
            }
            case closed: {
                ProblemCont.instance.clear();
                break;
            }
        }
    }

    class CompleteTestStyleCheckJob
    extends Job {
        public CompleteTestStyleCheckJob(String name) {
            super(name);
        }

        public boolean belongsTo(Object family) {
            if (family instanceof CompleteTestStyleCheckJob) {
                return true;
            }
            return super.belongsTo(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            ProblemCont.instance.clear();
            if (TeststyleHandler.this.isEnabled()) {
                for (BaseContext context : CheckCont.getContexts()) {
                    for (Object object : context.getAll()) {
                        TeststyleHandler.this.check(object);
                    }
                }
            }
            TeststyleHandler.this.refresh();
            try {
                TeststyleHandler.this.addTeststyleProblems(monitor);
            }
            catch (JBException jBException) {
                return new Status(2, "org.eclipse.jubula.client.teststyle", this.getName());
            }
            return new Status(0, "org.eclipse.jubula.client.teststyle", this.getName());
        }
    }

    class TestStyleJob
    extends Job {
        private DataChangedEvent[] m_events;

        public TestStyleJob(String name, DataChangedEvent ... events) {
            super(name);
            this.m_events = events;
        }

        public boolean belongsTo(Object family) {
            if (family instanceof TestStyleJob) {
                return true;
            }
            return super.belongsTo(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return new Status(8, "org.eclipse.jubula.client.teststyle", this.getName());
            }
            monitor.beginTask(Messages.TestStyleRunningOperation, -1);
            DataChangedEvent[] dataChangedEventArray = this.m_events;
            int n = this.m_events.length;
            int n2 = 0;
            while (n2 < n) {
                DataChangedEvent e = dataChangedEventArray[n2];
                TeststyleHandler.this.handleChangedPo(e.getPo(), e.getDataState(), e.getUpdateState());
                ++n2;
            }
            if (monitor.isCanceled()) {
                return new Status(8, "org.eclipse.jubula.client.teststyle", this.getName());
            }
            TeststyleHandler.this.refresh();
            if (monitor.isCanceled()) {
                return new Status(8, "org.eclipse.jubula.client.teststyle", this.getName());
            }
            try {
                TeststyleHandler.this.addTeststyleProblems(monitor);
            }
            catch (JBException jBException) {
                return new Status(2, "org.eclipse.jubula.client.teststyle", this.getName());
            }
            ProblemPropagator.INSTANCE.propagate();
            monitor.done();
            return new Status(0, "org.eclipse.jubula.client.teststyle", this.getName());
        }
    }
}

