/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.CapBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.TDCell;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.RefToken;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.AbstractEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;

public class TCEditorDndSupport
extends AbstractEditorDndSupport {
    private TCEditorDndSupport() {
    }

    public static boolean performDrop(AbstractTestCaseEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget, int dropPosition) {
        if (targetEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return false;
        }
        List selectedElements = toDrop.toList();
        Collections.reverse(selectedElements);
        Iterator iter = selectedElements.iterator();
        while (iter.hasNext()) {
            INodePO target;
            INodePO droppedNode = null;
            Object obj = iter.next();
            if (!(obj instanceof INodePO)) {
                return false;
            }
            INodePO node = (INodePO)obj;
            if ((node instanceof ICapPO || node instanceof IExecTestCasePO || node instanceof ICommentPO) && (target = dropTarget) != node && (target instanceof ICapPO || target instanceof IExecTestCasePO || target instanceof ICommentPO)) {
                droppedNode = TCEditorDndSupport.moveNode(node, target);
            }
            if (node instanceof ISpecTestCasePO && TCEditorDndSupport.performDrop(targetEditor, dropTarget, dropPosition, (ISpecTestCasePO)node) == null) {
                return false;
            }
            TCEditorDndSupport.postDropAction(droppedNode, targetEditor);
        }
        return true;
    }

    public static boolean copyPaste(AbstractTestCaseEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget) {
        if (targetEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return false;
        }
        List selectedElements = toDrop.toList();
        ISpecTestCasePO targetNode = dropTarget instanceof ISpecTestCasePO ? (ISpecTestCasePO)dropTarget : (ISpecTestCasePO)dropTarget.getParentNode();
        boolean isContainsEctOrCap = false;
        Object[] objectArray = selectedElements.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!(obj instanceof INodePO)) {
                return false;
            }
            if (obj instanceof IEventExecTestCasePO) {
                TCEditorDndSupport.copyPasteEventExecTestCase(targetEditor, (IEventExecTestCasePO)obj, targetNode);
            } else if (obj instanceof IExecTestCasePO || obj instanceof ICapPO) {
                IParamNodePO paramNode = (IParamNodePO)obj;
                isContainsEctOrCap = true;
                if (!targetNode.equals((Object)paramNode.getParentNode()) && !TCEditorDndSupport.checkParentParameters(targetNode, paramNode, null, false)) {
                    return false;
                }
            } else {
                return false;
            }
            ++n2;
        }
        if (isContainsEctOrCap) {
            int position = targetNode.indexOf(dropTarget);
            Object[] objectArray2 = selectedElements.toArray();
            int n3 = objectArray2.length;
            n = 0;
            while (n < n3) {
                Object obj = objectArray2[n];
                ++position;
                if (obj instanceof IExecTestCasePO) {
                    TCEditorDndSupport.copyPasteExecTestCase(targetEditor, (IExecTestCasePO)obj, targetNode, position);
                } else if (obj instanceof ICapPO) {
                    TCEditorDndSupport.copyPasteCap(targetEditor, (ICapPO)obj, targetNode, position);
                }
                ++n;
            }
        }
        return true;
    }

    public static boolean copyPasteEventExecTestCase(AbstractTestCaseEditor targetEditor, IEventExecTestCasePO origEvent, ISpecTestCasePO targetNode) {
        if (targetNode.getEventExecTcMap().containsKey(origEvent.getEventType())) {
            boolean status = MessageDialog.openQuestion(null, (String)Messages.DoubleEventTypeTitle, (String)NLS.bind((String)Messages.TestCaseEditorDoubleEventTypeErrorDetailOverwrite, (Object[])new Object[]{targetNode.getName(), I18n.getString((String)origEvent.getEventType())}));
            if (status) {
                targetNode.getEventExecTcMap().remove(origEvent.getEventType());
            } else {
                return false;
            }
        }
        EditSupport editSupport = targetEditor.getEditorHelper().getEditSupport();
        ParamNameBPDecorator pMapper = targetEditor.getEditorHelper().getEditSupport().getParamMapper();
        if (targetNode.equals((Object)origEvent.getParentNode()) || TCEditorDndSupport.checkParentParameters(targetNode, (IParamNodePO)origEvent, pMapper, false)) {
            try {
                IEventExecTestCasePO newEvent = NodeMaker.createEventExecTestCasePO((ISpecTestCasePO)origEvent.getSpecTestCase(), (INodePO)targetNode);
                TCEditorDndSupport.fillExec((IExecTestCasePO)origEvent, (IExecTestCasePO)newEvent, false);
                TCEditorDndSupport.checkParentParameters(targetNode, (IParamNodePO)newEvent, pMapper, true);
                TestCaseBP.addEventHandler((EditSupport)editSupport, (ISpecTestCasePO)targetNode, (IEventExecTestCasePO)newEvent);
                targetEditor.getEditorHelper().setDirty(true);
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newEvent, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
            }
            catch (InvalidDataException invalidDataException) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_DOUBLE_EVENT, null, (String[])new String[]{NLS.bind((String)Messages.TestCaseEditorDoubleEventTypeErrorDetail, (Object[])new Object[]{targetNode.getName(), I18n.getString((String)origEvent.getEventType())})});
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean copyPasteExecTestCase(AbstractTestCaseEditor targetEditor, IExecTestCasePO execTestCase, ISpecTestCasePO targetNode, int dropPosition) {
        IExecTestCasePO newExecTestCase = NodeMaker.createExecTestCasePO((ISpecTestCasePO)execTestCase.getSpecTestCase());
        TCEditorDndSupport.fillExec(execTestCase, newExecTestCase, false);
        ParamNameBPDecorator pMapper = targetEditor.getEditorHelper().getEditSupport().getParamMapper();
        TCEditorDndSupport.checkParentParameters(targetNode, (IParamNodePO)newExecTestCase, pMapper, true);
        TestCaseBP.addReferencedTestCase((INodePO)targetNode, (IExecTestCasePO)newExecTestCase, (Integer)dropPosition);
        targetEditor.getEditorHelper().setDirty(true);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newExecTestCase, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
        TCEditorDndSupport.postDropAction((INodePO)newExecTestCase, targetEditor);
        return true;
    }

    public static boolean copyPasteCap(AbstractTestCaseEditor targetEditor, ICapPO cap, ISpecTestCasePO targetNode, int dropPosition) {
        ParamNameBPDecorator pMapper = targetEditor.getEditorHelper().getEditSupport().getParamMapper();
        ICapPO newCap = CapBP.createCapWithDefaultParams((String)cap.getName(), (String)cap.getComponentName(), (String)cap.getComponentType(), (String)cap.getActionName());
        TCEditorDndSupport.fillCap(cap, newCap);
        newCap.setParentNode((INodePO)targetNode);
        targetNode.addNode(dropPosition, (INodePO)newCap);
        TCEditorDndSupport.checkParentParameters(targetNode, (IParamNodePO)newCap, pMapper, true);
        targetEditor.getTreeViewer().expandToLevel((Object)targetNode, 1);
        targetEditor.handleParamChanged();
        DataEventDispatcher.getInstance().fireParamChangedListener();
        TCEditorDndSupport.postDropAction((INodePO)newCap, targetEditor);
        return true;
    }

    private static IExecTestCasePO performDrop(AbstractTestCaseEditor targetEditor, INodePO dropTarget, int dropPosition, ISpecTestCasePO toDrop) {
        block8: {
            INodePO target = dropTarget;
            if (target != toDrop) {
                EditSupport editSupport = targetEditor.getEditorHelper().getEditSupport();
                try {
                    if (target instanceof ICapPO || target instanceof IExecTestCasePO) {
                        return TCEditorDndSupport.dropOnCAPorExecTc(editSupport, (INodePO)toDrop, target, dropPosition);
                    }
                    if (target instanceof ISpecTestCasePO) {
                        return TCEditorDndSupport.dropOnSpecTc(editSupport, (INodePO)toDrop, target);
                    }
                    if (target instanceof ITestSuitePO) {
                        return TCEditorDndSupport.dropOnTestsuite(editSupport, (ITestSuitePO)target, toDrop);
                    }
                }
                catch (PMException e) {
                    NodeEditorInput inp = (NodeEditorInput)targetEditor.getAdapter(NodeEditorInput.class);
                    INodePO inpNode = inp.getNode();
                    PMExceptionHandler.handlePMExceptionForMasterSession(e);
                    if (e instanceof PMAlreadyLockedException && ((PMAlreadyLockedException)((Object)e)).getLockedObject() != null && !((PMAlreadyLockedException)((Object)e)).getLockedObject().equals(inpNode) && targetEditor.isDirty()) break block8;
                    try {
                        targetEditor.reOpenEditor((IPersistentObject)inpNode);
                    }
                    catch (PMException pMException) {
                        PMExceptionHandler.handlePMExceptionForEditor(e, targetEditor);
                    }
                }
            }
        }
        return null;
    }

    private static boolean checkParentParameters(ISpecTestCasePO targetNode, IParamNodePO paramNode, ParamNameBPDecorator pMapper, boolean create) {
        Iterator it = paramNode.getParamReferencesIterator();
        while (it.hasNext()) {
            TDCell cell = (TDCell)it.next();
            String guid = (String)paramNode.getDataManager().getUniqueIds().get(cell.getCol());
            IParamDescriptionPO childDesc = paramNode.getParameterForUniqueId(guid);
            if (childDesc == null) continue;
            ModelParamValueConverter conv = new ModelParamValueConverter(cell.getTestData(), (IParameterInterfacePO)paramNode, childDesc);
            List refTokens = conv.getRefTokens();
            for (RefToken refToken : refTokens) {
                String oldGUID = RefToken.extractCore((String)refToken.getModelString());
                String paramName = ParamNameBP.getInstance().getName(oldGUID, childDesc.getParentProjectId());
                HashedMap oldToNewGuids = new HashedMap();
                IParamDescriptionPO parentParamDescr = targetNode.getParameterForName(paramName);
                if (parentParamDescr == null) {
                    if (create) {
                        targetNode.addParameter(childDesc.getType(), paramName, (IParamNameMapper)pMapper);
                        parentParamDescr = targetNode.getParameterForName(paramName);
                    }
                } else if (!parentParamDescr.getType().equals(childDesc.getType())) {
                    MessageDialog.openInformation(null, (String)Messages.ParameterConfligtDetectedTitle, (String)NLS.bind((String)Messages.ParameterConfligtDetected, (Object[])new Object[]{parentParamDescr.getName(), targetNode.getName()}));
                    return false;
                }
                if (!create) continue;
                if (parentParamDescr != null) {
                    String newGuid = parentParamDescr.getUniqueId();
                    oldToNewGuids.put(oldGUID, newGuid);
                }
                conv.replaceUuidsInReferences((Map)oldToNewGuids);
                cell.setTestData(conv.getModelString());
            }
        }
        return true;
    }

    public static boolean validateCopy(IStructuredSelection toDrop, INodePO dropTarget) {
        if (toDrop == null || toDrop.isEmpty() || dropTarget == null) {
            return false;
        }
        Object[] objectArray = toDrop.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISpecTestCasePO specTcGUI;
            Object obj = objectArray[n2];
            if (!(obj instanceof INodePO)) {
                return false;
            }
            INodePO transferGUI = (INodePO)obj;
            INodePO parentNode = transferGUI.getParentNode();
            if (parentNode.equals(obj)) {
                return false;
            }
            if (!(transferGUI instanceof ICapPO || (specTcGUI = !(dropTarget instanceof ISpecTestCasePO) ? (ISpecTestCasePO)dropTarget.getParentNode() : (ISpecTestCasePO)dropTarget).equals((Object)parentNode) || transferGUI instanceof ICapPO)) {
                ISpecTestCasePO childGUI;
                if (transferGUI instanceof ISpecTestCasePO) {
                    childGUI = (ISpecTestCasePO)transferGUI;
                } else if (transferGUI instanceof IExecTestCasePO) {
                    childGUI = ((IExecTestCasePO)transferGUI).getSpecTestCase();
                } else {
                    return false;
                }
                if (childGUI.hasCircularDependences((INodePO)specTcGUI)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean validateDrop(Viewer sourceViewer, Viewer targetViewer, IStructuredSelection toDrop, INodePO dropTarget, boolean allowFromBrowser) {
        if (toDrop == null || toDrop.isEmpty() || dropTarget == null) {
            return false;
        }
        if (sourceViewer != null && !sourceViewer.equals(targetViewer)) {
            boolean foundOne = false;
            for (TestCaseBrowser tcb : MultipleTCBTracker.getInstance().getOpenTCBs()) {
                if (!sourceViewer.equals(tcb.getTreeViewer())) continue;
                foundOne = true;
            }
            if (!allowFromBrowser || !foundOne) {
                return false;
            }
        }
        for (Object obj : toDrop) {
            ISpecTestCasePO childGUI;
            if (!(obj instanceof INodePO)) {
                return false;
            }
            INodePO transferGUI = (INodePO)obj;
            INodePO parentNode = transferGUI.getParentNode();
            if (!(parentNode instanceof ISpecTestCasePO || parentNode instanceof IProjectPO || parentNode instanceof ICategoryPO)) {
                return false;
            }
            if (!(transferGUI instanceof ISpecTestCasePO) && transferGUI.getParentNode() != dropTarget.getParentNode()) {
                return false;
            }
            ISpecTestCasePO specTcGUI = !(dropTarget instanceof ISpecTestCasePO) ? (ISpecTestCasePO)dropTarget.getParentNode() : (ISpecTestCasePO)dropTarget;
            if (!(transferGUI instanceof ISpecTestCasePO) || !(childGUI = (ISpecTestCasePO)transferGUI).hasCircularDependences((INodePO)specTcGUI)) continue;
            return false;
        }
        return true;
    }

    private static IExecTestCasePO dropOnSpecTc(EditSupport editSupport, INodePO node, INodePO target) throws PMAlreadyLockedException, PMDirtyVersionException, PMException {
        return TestCaseBP.addReferencedTestCase((EditSupport)editSupport, (INodePO)target, (ISpecTestCasePO)((ISpecTestCasePO)node), (Integer)0);
    }

    private static IExecTestCasePO dropOnTestsuite(EditSupport editSupport, ITestSuitePO testSuite, ISpecTestCasePO testcase) throws PMAlreadyLockedException, PMDirtyVersionException, PMException {
        return TestCaseBP.addReferencedTestCase((EditSupport)editSupport, (INodePO)testSuite, (ISpecTestCasePO)testcase, (Integer)0);
    }

    private static IExecTestCasePO dropOnCAPorExecTc(EditSupport editSupport, INodePO node, INodePO target, int location) throws PMAlreadyLockedException, PMDirtyVersionException, PMException {
        ISpecTestCasePO specTcGUItoDrop = (ISpecTestCasePO)node;
        INodePO parentGUI = target.getParentNode();
        int position = parentGUI.indexOf(target);
        if (location != 1) {
            ++position;
        }
        return TestCaseBP.addReferencedTestCase((EditSupport)editSupport, (INodePO)parentGUI, (ISpecTestCasePO)specTcGUItoDrop, (Integer)position);
    }
}

