/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.interfaces.ITester;
import org.eclipse.jubula.rc.common.util.ReflectionUtil;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaReflectionTester
implements ITester {
    private IEventThreadQueuer m_threadQueuer = this.getEventThreadQueuer();

    protected abstract IEventThreadQueuer getEventThreadQueuer();

    public void rcInvokeMethod(String fqcn, String name, @Nullable String signature, @Nullable String args, @Nullable String argsSplit, int timeout) {
        try {
            this.m_threadQueuer.invokeAndWait("invokeMethod", this.createCallable(fqcn, name, signature, args, argsSplit), timeout);
        }
        catch (TimeoutException e) {
            throw new StepExecutionException(e.toString(), EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
        }
    }

    public String rcInvokeMethodStoreReturn(String variableName, String fqcn, String name, @Nullable String signature, @Nullable String args, @Nullable String argsSplit, int timeout) {
        try {
            Object result = this.m_threadQueuer.invokeAndWait("invokeMethod", this.createCallable(fqcn, name, signature, args, argsSplit), timeout);
            return result == null ? "NULL" : result.toString();
        }
        catch (TimeoutException e) {
            throw new StepExecutionException(e.toString(), EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
        }
    }

    private Callable<Object> createCallable(final String fqcn, final String name, final @Nullable String signature, final @Nullable String args, final @Nullable String argsSplit) {
        return new Callable<Object>(){

            @Override
            public Object call() {
                ClassLoader uiClassloader = Thread.currentThread().getContextClassLoader();
                try {
                    return ReflectionUtil.invokeMethod(fqcn, name, signature, args, argsSplit, uiClassloader);
                }
                catch (Throwable e) {
                    ReflectionUtil.handleException(e);
                    return null;
                }
            }
        };
    }

    public void rcInvokeMethod(String fqcn, String name, int timeout) {
        try {
            this.m_threadQueuer.invokeAndWait("invokeMethod", this.createCallable(fqcn, name), timeout);
        }
        catch (TimeoutException e) {
            throw new StepExecutionException(e.toString(), EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
        }
    }

    public String rcInvokeMethodStoreReturn(String variableName, String fqcn, String name, int timeout) {
        try {
            Object result = this.m_threadQueuer.invokeAndWait("invokeMethod", this.createCallable(fqcn, name), timeout);
            return result == null ? "NULL" : result.toString();
        }
        catch (TimeoutException e) {
            throw new StepExecutionException(e.toString(), EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
        }
    }

    private Callable<Object> createCallable(final String fqcn, final String name) {
        return new Callable<Object>(){

            @Override
            public Object call() {
                ClassLoader uiClassloader = Thread.currentThread().getContextClassLoader();
                try {
                    return ReflectionUtil.invokeMethod(fqcn, name, uiClassloader);
                }
                catch (Throwable e) {
                    ReflectionUtil.handleException(e);
                    return null;
                }
            }
        };
    }

    @Override
    public void setComponent(Object graphicsComponent) {
    }

    @Override
    public String[] getTextArrayFromComponent() {
        return null;
    }
}

