/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the OperatingSystemComponent component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2016-05-13T13:07:27.684Z")
public interface OperatingSystemComponent {
    
    
        /**
         * Run operating system specific executable
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param directory 
         *        the directory in which the command should be executed
         * @param executable 
         *        the command to execute without any command line arguments
         * @param arguments 
         *        a splitChar-delimited list of command-line arguments
         * @param argumentSplitCharacter 
         *        the character used to split the arguments string into individual arguments
         * @param expectedExitCode 
         *        the expected exit code
         * @param encoding 
         *        the encoding used to read output from the process
         * @param useNewEnvironment 
         *        Do not use old / current environment for new sub-process 
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP runExecutable(@NonNull Integer timeoutInMs,@NonNull String directory,@NonNull String executable,@Nullable String arguments,@Nullable String argumentSplitCharacter,@NonNull Integer expectedExitCode,@NonNull String encoding,@NonNull Boolean useNewEnvironment
        ) throws IllegalArgumentException;
        
} 