/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the LocatorActionHandler component from the html toolkit.
 * @since 4.0
 */
@TesterClass(testerClass="com.bredexsw.jubula.rc.html.web.implclasses.LocatorImplClass")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-05-13T13:07:27.748Z")
@Beta
public class LocatorActionHandler implements org.eclipse.jubula.toolkit.html.components.handler.LocatorActionHandler {
            public LocatorActionHandler() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        org.eclipse.jubula.tools.internal.objects.ComponentIdentifier pseudoIdentifier =
            new org.eclipse.jubula.tools.internal.objects.ComponentIdentifier();
        pseudoIdentifier.setComponentClassName("html.generic.Locator"); //$NON-NLS-1$
        return pseudoIdentifier;
    }
    
        /**
         * 
         * @param xPath 
         *        the XPath to use
         * @param comparisonMethod 
         *        the comparison method
         * @param count 
         *        the expected count
         * @since 4.0
         */
        public void checkXPathCount(
            @Nullable String xPath,
            @Nullable NumberComparisonOperator comparisonMethod,
            @Nullable Integer count
        )  {
            if (xPath == null) return;
            
            if (comparisonMethod == null) return;
            
            if (count == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckXPathCount")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(xPath)
                            .addParameter(comparisonMethod.rcValue())
                            .addParameter(count)
                            .build(), null);
        }
        
        /**
         * 
         * @param cSSPath 
         *        the CSS path to use
         * @param comparisonMethod 
         *        the comparison method
         * @param count 
         *        the expected count
         * @since 4.0
         */
        public void checkCSSPathCount(
            @Nullable String cSSPath,
            @Nullable NumberComparisonOperator comparisonMethod,
            @Nullable Integer count
        )  {
            if (cSSPath == null) return;
            
            if (comparisonMethod == null) return;
            
            if (count == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckCSSPathCount")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(cSSPath)
                            .addParameter(comparisonMethod.rcValue())
                            .addParameter(count)
                            .build(), null);
        }
        
        /**
         * 
         * @param locator 
         *        the locator to use
         * @param operator 
         *        the operator used for comparison
         * @param text 
         *        the text to use
         * 
         */
        public void checkText(
            @Nullable String locator,
            @Nullable Operator operator,
            @Nullable String text
        )  {
            if (locator == null) return;
            
            if (operator == null) return;
            
            if (text == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckText")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(locator)
                            .addParameter(operator.rcValue())
                            .addParameter(text)
                            .build(), null);
        }
        
        /**
         * 
         * @param locator 
         *        the locator to use
         * 
         */
        public void click(
            @Nullable String locator
        )  {
            if (locator == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcClick")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(locator)
                            .build(), null);
        }
        
        /**
         * 
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @param locator 
         *        the locator to use
         * 
         */
        public void waitForComponent(
            @Nullable Integer timeoutInMs,
            @Nullable Integer delayAfterVisibility,
            @Nullable String locator
        )  {
            if (timeoutInMs == null) return;
            
            if (delayAfterVisibility == null) return;
            
            if (locator == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcWaitForComponent")
                            .setDefaultMapping(true)
                            .setComponentIdentifier(getPseudoComponentIdentifier())
                            .addParameter(timeoutInMs)
                            .addParameter(delayAfterVisibility)
                            .addParameter(locator)
                            .build(), null);
        }
        
} 