/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.ios;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.ios.internal.IosToolkitInfo;

/**
 * Factory for creating components from the ios toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2016-05-13T13:07:27.779Z")
public class IosComponents {
    
    @NonNull private final static ToolkitInfo TOOLKIT_INFORMATION = IosToolkit.createToolkitInformation();

    private IosComponents() {
        super();
    }
    
    /** 
     *  @return the toolkit information, not recommended to be modified
     */
    @NonNull public static ToolkitInfo getToolkitInformation() {
        return TOOLKIT_INFORMATION;
    }

    /** create a new representative for a ButtonComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.ButtonComponent createButtonComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.ButtonComponent(componentIdentifier);
    }
    
    /** create a new representative for a ButtonComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.ButtonComponentActionHandler createButtonComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.ButtonComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UIButton} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.ButtonComponent createUIButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UIButton(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UIButton} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.ButtonComponentActionHandler createUIButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UIButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UISwitch} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.ButtonComponent createUISwitch (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UISwitch(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UISwitch} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.ButtonComponentActionHandler createUISwitchActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UISwitchActionHandler(componentIdentifier);
    }
    /** create a new representative for a TextInputComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextInputComponent createTextInputComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.TextInputComponent(componentIdentifier);
    }
    
    /** create a new representative for a TextInputComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.TextInputComponentActionHandler createTextInputComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.TextInputComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITextField} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextInputComponent createUITextField (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITextField(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UITextField} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.TextInputComponentActionHandler createUITextFieldActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UITextFieldActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITextView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextInputComponent createUITextView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITextView(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UITextView} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.TextInputComponentActionHandler createUITextViewActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UITextViewActionHandler(componentIdentifier);
    }
    /** create a new representative for a TextComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createTextComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.TextComponent(componentIdentifier);
    }
    
    /** create a new representative for a TextComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.TextComponentActionHandler createTextComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.TextComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UILabel} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createUILabel (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UILabel(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UILabel} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.TextComponentActionHandler createUILabelActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UILabelActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITableViewCell} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createUITableViewCell (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITableViewCell(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UITableViewCell} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.TextComponentActionHandler createUITableViewCellActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UITableViewCellActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UINavigationItemView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createUINavigationItemView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UINavigationItemView(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UINavigationItemView} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.TextComponentActionHandler createUINavigationItemViewActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UINavigationItemViewActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITabBarButton} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createUITabBarButton (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITabBarButton(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UITabBarButton} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.TextComponentActionHandler createUITabBarButtonActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UITabBarButtonActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UIImageView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TextComponent createUIImageView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UIImageView(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UIImageView} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.TextComponentActionHandler createUIImageViewActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UIImageViewActionHandler(componentIdentifier);
    }
    /** create a new representative for a List UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.List createList (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.List> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.List(componentIdentifier);
    }
    
    /** create a new representative for a List UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.ListActionHandler createListActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.List> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.ListActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITableView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.List createUITableView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.List> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITableView(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UITableView} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.ListActionHandler createUITableViewActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.List> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UITableViewActionHandler(componentIdentifier);
    }
    /** create a new representative for a TabComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TabComponent createTabComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.TabComponent(componentIdentifier);
    }
    
    /** create a new representative for a TabComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.TabComponentActionHandler createTabComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.TabComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UISegmentedControl} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.TabComponent createUISegmentedControl (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UISegmentedControl(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UISegmentedControl} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.TabComponentActionHandler createUISegmentedControlActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UISegmentedControlActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UITabBar} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.UITabBar createUITabBar (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.UITabBar> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UITabBar(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UITabBar} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.UITabBarActionHandler createUITabBarActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.UITabBar> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UITabBarActionHandler(componentIdentifier);
    }
    /** create a new representative for a Picker UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.Picker createPicker (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.Picker> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.Picker(componentIdentifier);
    }
    
    /** create a new representative for a Picker UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.PickerActionHandler createPickerActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.Picker> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.PickerActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link ios.UIPickerView} UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.Picker createUIPickerView (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.Picker> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UIPickerView(componentIdentifier);
    }
    
    /** create a new representative for a {@link ios.UIPickerView} UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.PickerActionHandler createUIPickerViewActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.ios.components.Picker> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UIPickerViewActionHandler(componentIdentifier);
    }
    /** create a new representative for a {@link UIApplication} component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.UIApplication createUIApplication () {
        return new org.eclipse.jubula.toolkit.ios.internal.impl.UIApplication();
    }
    
    /** create a new instance of UIApplicationActionHandler 
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.ios.components.handler.UIApplicationActionHandler createUIApplicationActionHandler () {
        return new org.eclipse.jubula.toolkit.ios.internal.impl.handler.UIApplicationActionHandler();
    }
}