/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.ios.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the {@link ios.UITabBar} component from the ios toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="abstract.ios.TabComponent")
@TesterClass(testerClass="com.bredexsw.jubula.rc.mobile.ios.impl.UITabComponentTester")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2016-05-13T13:07:27.774Z")
@Beta
public class UITabBarActionHandler extends org.eclipse.jubula.toolkit.ios.internal.impl.handler.TabComponentActionHandler implements org.eclipse.jubula.toolkit.ios.components.handler.UITabBarActionHandler {
            public UITabBarActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param tabIndex 
         *        the 1-based tab index
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public void checkBadgeValue(
            @Nullable String text,
            @Nullable Integer tabIndex,
            @Nullable Operator operator
        )  {
            if (text == null) return;
            
            if (tabIndex == null) return;
            
            if (operator == null) return;
            
            AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckBadgeValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(tabIndex)
                            .addParameter(operator.rcValue())
                            .build(), null);
        }
        
} 