/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.commands.IStartAut;
import org.eclipse.jubula.autagent.monitoring.MonitoringDataStore;
import org.eclipse.jubula.autagent.monitoring.MonitoringUtil;
import org.eclipse.jubula.communication.internal.message.StartAUTServerStateMessage;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.internal.utils.ZipUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStartToolkitAut
implements IStartAut {
    private static Logger log = LoggerFactory.getLogger(AbstractStartToolkitAut.class);
    private static final String SOURCE_BUNDLE_MANIFEST_ATTR = "Eclipse-SourceBundle";
    private StartAUTServerStateMessage m_errorMessage;
    private boolean m_isAgentSet = false;

    @Override
    public StartAUTServerStateMessage startAut(Map<String, String> parameters) throws IOException {
        StartAUTServerStateMessage envCheckMsg = this.validateEnvironment();
        if (envCheckMsg == null) {
            if (!MonitoringUtil.checkForDuplicateAutID(String.valueOf(parameters.get("AUT_ID")))) {
                MonitoringDataStore cm = MonitoringDataStore.getInstance();
                cm.putConfigMap(parameters.get("AUT_ID"), parameters);
            }
            File workingDir = this.getWorkingDir(parameters);
            String java = this.createBaseCmd(parameters);
            String[] cmdArray = this.createCmdArray(java, parameters);
            String[] envArray = this.createEnvArray(parameters, this.m_isAgentSet);
            if (envArray == null && log.isInfoEnabled()) {
                log.info("envArray: NULL");
            }
            if (log.isInfoEnabled()) {
                StringBuffer logMessage = new StringBuffer();
                int i = 0;
                while (i < cmdArray.length) {
                    logMessage.append(String.valueOf(cmdArray[i]) + " ");
                    ++i;
                }
                log.info("starting AUT with command: " + logMessage.toString());
            }
            return this.executeCommand(cmdArray, envArray, workingDir);
        }
        return envCheckMsg;
    }

    protected StartAUTServerStateMessage validateEnvironment() {
        return null;
    }

    protected File getWorkingDir(Map parameters) {
        File workingDir;
        String autWorkDir = (String)parameters.get("WORKING_DIR");
        if (autWorkDir == null) {
            autWorkDir = "";
        }
        if (!(workingDir = new File(autWorkDir)).isDirectory() || !workingDir.exists()) {
            if (log.isInfoEnabled()) {
                log.info("Working dir: invalid");
            }
            workingDir = null;
        }
        return workingDir;
    }

    protected String[] createEnvArray(Map<String, String> parameters, boolean isAgentSet) {
        this.m_isAgentSet = isAgentSet;
        String environment = parameters.get("ENVIRONMENT");
        boolean generate = Boolean.valueOf(parameters.get("NAME_TECHNICAL_COMPONENTS"));
        Properties oldProp = EnvironmentUtils.getProcessEnvironment();
        String[] newEnvArray = null;
        if (generate) {
            Properties generateProperty = new Properties();
            generateProperty.setProperty("TEST_GENERATE_NAMES_PROPERTY", String.valueOf(generate));
            oldProp = EnvironmentUtils.setEnvironment((Properties)oldProp, (Properties)generateProperty);
            newEnvArray = EnvironmentUtils.propToStrArray((Properties)oldProp, (String)"=");
        }
        if (environment != null && environment.trim().length() != 0) {
            String[] envArray = EnvironmentUtils.strToStrArray((String)environment, (String)"\r\n");
            Properties newProp = EnvironmentUtils.strArrayToProp((String[])envArray, (String)"=");
            newProp = EnvironmentUtils.setEnvironment((Properties)oldProp, (Properties)newProp);
            newEnvArray = EnvironmentUtils.propToStrArray((Properties)newProp, (String)"=");
        }
        return newEnvArray;
    }

    protected abstract String createBaseCmd(Map<String, String> var1) throws IOException;

    protected abstract String[] createCmdArray(String var1, Map<String, String> var2);

    protected StartAUTServerStateMessage executeCommand(String[] cmdArray, String[] envArray, File workingDir) throws IOException {
        AutStarter autAgent = AutStarter.getInstance();
        Process process = Runtime.getRuntime().exec(cmdArray, envArray, workingDir);
        if (this.isErrorMessage()) {
            log.error("AbstractStartToolkitAut - executeCommand: " + this.getErrorMessage());
            return this.getErrorMessage();
        }
        if (!autAgent.watchAUT(process, this.m_isAgentSet)) {
            process.destroy();
            return this.createBusyMessage();
        }
        return new StartAUTServerStateMessage(0);
    }

    protected void setErrorMessage(StartAUTServerStateMessage errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    protected StartAUTServerStateMessage getErrorMessage() {
        if (this.m_errorMessage == null) {
            this.m_errorMessage = new StartAUTServerStateMessage(1, "Unexpected error, no detail available.");
        }
        return this.m_errorMessage;
    }

    protected boolean isErrorMessage() {
        return this.m_errorMessage != null;
    }

    protected StartAUTServerStateMessage createBusyMessage() {
        return new StartAUTServerStateMessage(1, "AUTServer is already running");
    }

    private static String[] getClasspathEntriesForBundleId(String bundleId) {
        Bundle mainBundle = AbstractStartToolkitAut.getBundleForID(bundleId);
        ArrayList<Bundle> bundleAndFragmentList = new ArrayList<Bundle>();
        bundleAndFragmentList.add(mainBundle);
        bundleAndFragmentList.addAll(AbstractStartToolkitAut.getFragmentsForBundleId(bundleId));
        ArrayList<String> classpathEntries = new ArrayList<String>();
        for (Bundle bundle : bundleAndFragmentList) {
            classpathEntries.addAll(AbstractStartToolkitAut.getPathforBundle(bundle));
        }
        return classpathEntries.toArray(new String[classpathEntries.size()]);
    }

    public static List<String> getPathforBundle(Bundle bundle) {
        ArrayList<String> path;
        block8: {
            path = new ArrayList<String>();
            try {
                File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                if (bundleFile.isFile()) {
                    path.add(bundleFile.getAbsolutePath());
                    try {
                        File[] createdFiles = ZipUtil.unzipTempJars((File)bundleFile);
                        int i = 0;
                        while (i < createdFiles.length) {
                            path.add(createdFiles[i].getAbsolutePath());
                            ++i;
                        }
                        break block8;
                    }
                    catch (IOException e) {
                        log.error("An error occurred while trying to extract nested JARs from " + bundle.getSymbolicName(), (Throwable)e);
                    }
                    break block8;
                }
                Enumeration e = bundle.findEntries("/", "*.jar", true);
                if (e != null) {
                    while (e.hasMoreElements()) {
                        URL jarUrl = (URL)e.nextElement();
                        File jarFile = new File(bundleFile + jarUrl.getFile());
                        if (AbstractStartToolkitAut.isJarFileWithManifestAttr(jarFile, SOURCE_BUNDLE_MANIFEST_ATTR)) continue;
                        path.add(jarFile.getAbsolutePath());
                    }
                }
            }
            catch (IOException ioe) {
                log.error("Bundle with ID '" + bundle.getSymbolicName() + "' could not be resolved to a file.", (Throwable)ioe);
            }
        }
        return path;
    }

    private static List<Bundle> fragmentLookupWithInactive(Bundle mainBundle) {
        Bundle[] bundles = EclipseStarter.getSystemBundleContext().getBundles();
        ArrayList<Bundle> fragments = new ArrayList<Bundle>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String fragmentHost = (String)bundle.getHeaders().get("Fragment-Host");
            if (fragmentHost != null) {
                if (fragmentHost.contains(";")) {
                    fragmentHost = fragmentHost.split(";")[0];
                }
                if (fragmentHost.equals(mainBundle.getSymbolicName())) {
                    for (Bundle fragment : fragments) {
                        if (!fragment.getSymbolicName().equals(bundle.getSymbolicName()) || bundle.getVersion().compareTo(fragment.getVersion()) <= 0) continue;
                        fragments.remove(fragment);
                    }
                    fragments.add(bundle);
                }
            }
            ++n2;
        }
        return fragments;
    }

    private static Bundle bundleLookupWithInactive(String bundleId) {
        BundleContext systemBundleContext = EclipseStarter.getSystemBundleContext();
        Bundle result = null;
        if (systemBundleContext != null) {
            Bundle[] bundles = systemBundleContext.getBundles();
            Version currVersion = Version.emptyVersion;
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundle.getSymbolicName().equals(bundleId) && bundle.getVersion().compareTo(currVersion) > 0) {
                    result = bundle;
                    currVersion = bundle.getVersion();
                }
                ++n2;
            }
        } else {
            log.warn("systemBundleContext is null - skipping bundleLookupWithInactive()");
        }
        return result;
    }

    public static Bundle getBundleForID(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null && (bundle = AbstractStartToolkitAut.bundleLookupWithInactive(bundleId)) == null) {
            log.error("No bundle found for ID '" + bundleId + "'.");
        }
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isJarFileWithManifestAttr(File file, String manifestAttr) {
        try {
            JarFile jarFile = new JarFile(file);
            try {
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) return false;
                boolean bl = manifest.getMainAttributes().containsKey(new Attributes.Name(manifestAttr));
                return bl;
            }
            catch (IOException ioe) {
                log.error("Error while reading JAR file.", (Throwable)ioe);
                return false;
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException ioe) {
                    log.error("Error while closing JAR file.", (Throwable)ioe);
                }
            }
        }
        catch (IOException ioe) {
            log.error("Error while opening JAR file.", (Throwable)ioe);
            return false;
        }
        catch (SecurityException se) {
            log.error("Error while opening JAR file.", (Throwable)se);
        }
        return false;
    }

    public static String getClasspathForBundleId(String bundleId) {
        String[] classPath = AbstractStartToolkitAut.getClasspathEntriesForBundleId(bundleId);
        return AbstractStartToolkitAut.createClassPath(classPath);
    }

    protected static String createClassPath(String[] classPath) {
        StringBuilder pathBuilder = new StringBuilder();
        String[] stringArray = classPath;
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            pathBuilder.append(entry).append(PATH_SEPARATOR);
            ++n2;
        }
        return pathBuilder.length() == 0 ? "" : pathBuilder.substring(0, pathBuilder.lastIndexOf(PATH_SEPARATOR));
    }

    protected void addDebugParams(List<String> cmds, boolean isDirectExec) {
        String rcDebug = IStartAut.RC_DEBUG;
        if (rcDebug != null) {
            if (isDirectExec) {
                cmds.add("-vmargs -Xms128m -Xmx512m");
            }
            cmds.add("-Xdebug");
            cmds.add("-Xnoagent");
            cmds.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + rcDebug);
            cmds.add("-Djava.compiler=NONE");
        }
    }

    public abstract String getRcBundleId();

    public static List<Bundle> getFragmentsForBundleId(String rcBundleId) {
        Bundle fragmentHost = AbstractStartToolkitAut.getBundleForID(rcBundleId);
        ArrayList<Bundle> fragments = new ArrayList<Bundle>();
        Bundle[] f = Platform.getFragments((Bundle)fragmentHost);
        if (f == null) {
            fragments.addAll(AbstractStartToolkitAut.fragmentLookupWithInactive(fragmentHost));
        } else {
            Bundle[] bundleArray = f;
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragment = bundleArray[n2];
                fragments.add(fragment);
                ++n2;
            }
        }
        return fragments;
    }
}

