/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.internal;

import java.util.Map;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.client.internal.BaseAUTConnection;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.client.internal.impl.AUTAgentImpl;
import org.eclipse.jubula.communication.internal.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.internal.message.ConnectToAutMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.SendAUTListOfSupportedComponentsMessage;
import org.eclipse.jubula.tools.internal.constants.EnvConstants;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ComponentClass;
import org.eclipse.jubula.tools.internal.xml.businessprocess.ProfileBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTConnection
extends BaseAUTConnection {
    static final Logger LOGGER = LoggerFactory.getLogger(AUTConnection.class);
    private static AUTConnection instance = null;

    private AUTConnection() throws ConnectionException {
    }

    public static synchronized AUTConnection getInstance() throws ConnectionException {
        if (instance == null) {
            instance = new AUTConnection();
        }
        return instance;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        instance = null;
    }

    public boolean connectToAut(AutIdentifier autId, Map<ComponentClass, String> typeMapping) {
        return this.connectToAutImpl(autId, typeMapping, 10000);
    }

    public boolean connectToAut(AutIdentifier autId, Map<ComponentClass, String> typeMapping, int timeOut) {
        return timeOut <= 0 ? this.connectToAut(autId, typeMapping) : this.connectToAutImpl(autId, typeMapping, timeOut);
    }

    private boolean connectToAutImpl(AutIdentifier autId, Map<ComponentClass, String> typeMapping, int timeOut) {
        if (!this.isConnected()) {
            block7: {
                LOGGER.info("Establishing connection to AUT...");
                this.run();
                this.getCommunicator().addCommunicationErrorListener((ICommunicationErrorListener)new AUTAgentImpl.ErrorListener(Thread.currentThread()));
                AutAgentConnection autAgent = AutAgentConnection.getInstance();
                autAgent.getCommunicator().send((Message)new ConnectToAutMessage(EnvConstants.LOCALHOST_FQDN, this.getCommunicator().getLocalPort(), autId));
                long startTime = System.currentTimeMillis();
                while (!this.isConnected() && autAgent.isConnected() && startTime + (long)timeOut > System.currentTimeMillis()) {
                    TimeUtil.delay((long)200L);
                }
                if (!this.isConnected()) break block7;
                this.setConnectedAutId(autId);
                LOGGER.info("Connection to AUT established.");
                this.setup(typeMapping);
                return true;
            }
            try {
                LOGGER.error("Connection to AUT could not be established.");
            }
            catch (CommunicationException e) {
                LOGGER.error("Error occurred while establishing connection to AUT.", (Throwable)e);
            }
            catch (JBVersionException e) {
                LOGGER.error("Version error occurred while establishing connection to AUT.", (Throwable)e);
            }
        } else {
            LOGGER.warn("Cannot establish new connection to AUT: Connection to AUT already exists.");
        }
        return false;
    }

    public void setup(Map<ComponentClass, String> technicalTypeMapping) throws BaseConnection.NotConnectedException, ConnectionException, CommunicationException {
        this.sendKeyboardLayoutToAut();
        TimeUtil.delay((long)1000L);
        this.sendComponentSupportToAUT(technicalTypeMapping);
    }

    private void sendComponentSupportToAUT(Map<ComponentClass, String> technicalTypeMapping) throws CommunicationException {
        SendAUTListOfSupportedComponentsMessage message = new SendAUTListOfSupportedComponentsMessage();
        message.setTechTypeToTesterClassMapping(technicalTypeMapping);
        message.setProfile(ProfileBuilder.getDefaultProfile());
        this.send((Message)message);
    }
}

