/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.compcheck;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.rules.SingleJobRule;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

public enum ProblemPropagator {
    INSTANCE;

    private static final ISchedulingRule PROPAGATIONRULE;

    static {
        PROPAGATIONRULE = new SingleJobRule();
    }

    public void propagate() {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            ProblemPropagationJob pp = new ProblemPropagationJob(Messages.ProblemPropagationJobName, project);
            pp.setRule((ISchedulingRule)new MultiRule(new ISchedulingRule[]{SingleJobRule.COMPLETENESSRULE, PROPAGATIONRULE, SingleJobRule.TESTSTYLERULE}));
            pp.schedule(1000L);
            Job[] jobArray = Job.getJobManager().find((Object)pp);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job != pp) {
                    job.cancel();
                }
                ++n2;
            }
        }
    }

    public static void setProblem(INodePO node, int severity) {
        switch (severity) {
            case 4: {
                node.addProblem(ProblemFactory.ERROR_IN_CHILD);
                break;
            }
            case 2: {
                node.addProblem(ProblemFactory.WARNING_IN_CHILD);
                break;
            }
        }
    }

    public static class ProblemCleanupOperation
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (alreadyVisited) {
                return false;
            }
            boolean hasHadProblems = false;
            hasHadProblems |= node.removeProblem(ProblemFactory.ERROR_IN_CHILD);
            return hasHadProblems |= node.removeProblem(ProblemFactory.WARNING_IN_CHILD);
        }
    }

    private final class ProblemPropagationJob
    extends Job {
        private final IProjectPO m_project;

        private ProblemPropagationJob(String name, IProjectPO project) {
            super(name);
            this.m_project = project;
        }

        public boolean belongsTo(Object family) {
            if (family instanceof ProblemPropagationJob) {
                return true;
            }
            return super.belongsTo(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            int status = 0;
            try {
                TreeTraverser treeTraverser = new TreeTraverser((INodePO)this.m_project, (ITreeNodeOperation<INodePO>)new ProblemCleanupOperation(), false, true);
                treeTraverser.addOperation(new ProblemPropagationOperation());
                treeTraverser.setMonitor(monitor);
                treeTraverser.traverse(true);
            }
            finally {
                if (monitor.isCanceled()) {
                    status = 8;
                } else {
                    DataEventDispatcher.getInstance().fireProblemPropagationFinished();
                }
                monitor.done();
            }
            return new Status(status, "org.eclipse.jubula.client.core", this.getName());
        }
    }

    public static class ProblemPropagationOperation
    implements ITreeNodeOperation<INodePO> {
        @Override
        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            return node.isActive();
        }

        @Override
        public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (ProblemFactory.hasProblem(node)) {
                ProblemPropagator.setProblem(parent, ProblemFactory.getWorstProblem(node.getProblems()).getStatus().getSeverity());
            }
        }
    }
}

