/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.treeoperations;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;

public class CheckReusedComponentNamesOp
extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
    private Set<String> m_compNameGuids;
    private Set<String> m_usedCompNameGuids = new HashSet<String>();

    public CheckReusedComponentNamesOp(Set<String> compNameGuidsToCheck) {
        this.m_compNameGuids = compNameGuidsToCheck;
    }

    @Override
    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        if (node instanceof ICapPO) {
            ICapPO cap = (ICapPO)node;
            if (cap.getComponentName() != null && this.m_compNameGuids.contains(cap.getComponentName())) {
                this.m_usedCompNameGuids.add(cap.getComponentName());
            }
        } else if (node instanceof IExecTestCasePO) {
            IExecTestCasePO execTc = (IExecTestCasePO)node;
            for (ICompNamesPairPO pair : execTc.getCompNamesPairs()) {
                if (this.m_compNameGuids.contains(pair.getFirstName())) {
                    this.m_usedCompNameGuids.add(pair.getFirstName());
                }
                if (!this.m_compNameGuids.contains(pair.getSecondName())) continue;
                this.m_usedCompNameGuids.add(pair.getSecondName());
            }
        }
        return true;
    }

    public Set<String> getUsedCompNameGuids() {
        return this.m_usedCompNameGuids;
    }
}

