/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.archive.JsonStorage;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.project.RefreshProjectHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportProjectHandler
extends AbstractProjectHandler {
    public static final String XML = ".xml";
    public static final String JUB = ".jub";
    private static Logger log = LoggerFactory.getLogger(ExportProjectHandler.class);

    private void showExportDialog() {
        FileDialog fileDialog = new FileDialog(this.getActiveShell(), 73728);
        fileDialog.setText(Messages.ActionBuilderSaveAs);
        String[] filters = new String[]{"*.jub"};
        fileDialog.setFilterExtensions(filters);
        fileDialog.setFilterPath(Utils.getLastDirPath());
        StringBuilder sb = new StringBuilder(GeneralStorage.getInstance().getProject().getDisplayName());
        fileDialog.setFileName(sb.toString());
        String fileNameTemp = fileDialog.open();
        if (fileNameTemp == null) {
            return;
        }
        String extension = filters[fileDialog.getFilterIndex()].replace("*", "");
        File file = new File(fileNameTemp = fileNameTemp.endsWith(extension) ? fileNameTemp : String.valueOf(fileNameTemp) + extension);
        if (file.exists()) {
            MessageBox mb = new MessageBox(fileDialog.getParent(), 200);
            mb.setText(Messages.ExportFileActionConfirmOverwriteTitle);
            mb.setMessage(NLS.bind((String)Messages.ExportFileActionConfirmOverwrite, (Object)fileNameTemp));
            if (mb.open() == 128) {
                return;
            }
        }
        Plugin.startLongRunning(Messages.ExportFileActionWaitWhileExporting);
        String fileName = fileNameTemp;
        Utils.storeLastDirPath(fileDialog.getFilterPath());
        Plugin console = Plugin.getDefault();
        ExportFileOperation op = new ExportFileOperation(fileName, extension, console);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
        }
        catch (InvocationTargetException ite) {
            log.error(ite.getLocalizedMessage(), ite.getCause());
        }
        catch (InterruptedException interruptedException) {}
    }

    public Object executeImpl(ExecutionEvent event) {
        if (Plugin.getDefault().showSaveEditorDialog(this.getActiveShell())) {
            this.showExportDialog();
        }
        Plugin.stopLongRunning();
        return null;
    }

    private static final class ExportFileOperation
    implements IRunnableWithProgress {
        private final String m_fileName;
        private final String m_fileExt;
        private IProgressConsole m_console;

        private ExportFileOperation(String fileName, String fileExt, IProgressConsole console) {
            this.m_fileName = fileName;
            this.m_fileExt = fileExt;
            this.m_console = console;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run(IProgressMonitor monitor) {
            if (this.m_fileName != null) {
                try {
                    try {
                        this.m_console.writeStatus((IStatus)new Status(1, "org.eclipse.jubula.client.core", Messages.RefreshProjectOperationRefreshing));
                        GeneralStorage gstorage = GeneralStorage.getInstance();
                        gstorage.validateProjectExists(gstorage.getProject());
                        final AtomicReference statusOfRefresh = new AtomicReference();
                        Plugin.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                RefreshProjectHandler rph = new RefreshProjectHandler();
                                statusOfRefresh.set((IStatus)rph.executeImpl(null));
                            }
                        });
                        if (statusOfRefresh.get() == null || !((IStatus)statusOfRefresh.get()).isOK()) return;
                        this.m_console.writeStatus((IStatus)new Status(1, "org.eclipse.jubula.client.core", Messages.ExportFileActionExporting));
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ExportFileActionExporting, (int)1);
                        JsonStorage.save((IProjectPO)gstorage.getProject(), (String)this.m_fileName, (boolean)true, (IProgressMonitor)subMonitor.newChild(1), (IProgressConsole)this.m_console);
                        return;
                    }
                    catch (PMException e) {
                        ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), null, null);
                        monitor.done();
                        Plugin.stopLongRunning();
                        return;
                    }
                    catch (ProjectDeletedException projectDeletedException) {
                        PMExceptionHandler.handleProjectDeletedException();
                        monitor.done();
                        Plugin.stopLongRunning();
                        return;
                    }
                }
                finally {
                    monitor.done();
                    Plugin.stopLongRunning();
                }
            } else {
                monitor.done();
            }
        }
    }
}

