/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.e3.accessor;

import java.lang.reflect.Field;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.classloader.IUrlLocator;
import org.eclipse.jubula.rc.rcp.common.classloader.EclipseUrlLocator;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStartup
implements BundleActivator {
    public static final String JUBULA_ACCESSOR_SIMPLE = "JUBULA_ACCESSOR_SIMPLE";
    private static final Logger LOG = LoggerFactory.getLogger(SimpleStartup.class);
    private static int sleeptime = 30;

    public void start(BundleContext context) throws Exception {
        String env = EnvironmentUtils.getProcessOrSystemProperty((String)JUBULA_ACCESSOR_SIMPLE);
        if (env == null) {
            LOG.info("using standard accessor");
            return;
        }
        LOG.warn("Using simple accessor");
        if (env.equals("")) {
            LOG.info("with default " + sleeptime + "s sleeptime");
        } else {
            try {
                sleeptime = Integer.parseInt(env);
                LOG.info("with " + env + "s sleeptime");
            }
            catch (NumberFormatException numberFormatException) {
                LOG.debug("failed to get number from environment");
                LOG.debug("using default " + sleeptime + "s sleeptime");
            }
        }
        Thread thread = new Thread(new WaitForDisplay());
        thread.start();
    }

    private Object getDefaultDisplay() throws Exception {
        Class<Display> clazz = Display.class;
        try {
            Field field = clazz.getDeclaredField("Default");
            field.setAccessible(true);
            Object defaultDisplayValue = field.get(null);
            return defaultDisplayValue;
        }
        catch (NoSuchFieldException nsfe) {
            throw new Exception(nsfe);
        }
        catch (SecurityException se) {
            throw new Exception(se);
        }
        catch (IllegalAccessException e) {
            throw new Exception(e);
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    private class WaitForDisplay
    implements Runnable {
        private static final int WAIT_FOR_DISPLAY_TIMEOUT = 30000;

        private WaitForDisplay() {
        }

        public void run() {
            LOG.info("starting wait for default Display job");
            long start = System.currentTimeMillis();
            boolean wait = true;
            while (wait) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    LOG.debug("Sleep interrupted");
                }
                if (System.currentTimeMillis() - start <= (long)(sleeptime * 1000)) continue;
                wait = false;
            }
            LOG.info("wait for Default display");
            try {
                start = System.currentTimeMillis();
                boolean waitforDisplay = true;
                while (waitforDisplay) {
                    Object obj = SimpleStartup.this.getDefaultDisplay();
                    if (obj != null) {
                        waitforDisplay = false;
                    }
                    if (System.currentTimeMillis() - start > 30000L) {
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.debug("Sleep interrupted");
                    }
                }
            }
            catch (Exception e) {
                LOG.debug("getting the Display via reflection failed", (Throwable)e);
            }
            Display display = Display.getDefault();
            LOG.info("starting AUT server");
            AUTServer autServer = this.initAutServer(display);
            AdapterFactoryRegistry.initRegistration((IUrlLocator)new EclipseUrlLocator());
            autServer.addToolKitEventListenerToAUT();
        }

        private AUTServer initAutServer(Display display) {
            AUTServer instance = AUTServer.getInstance((String)"org.eclipse.jubula.rc.swt.SwtAUTServer");
            ((SwtAUTServer)instance).setDisplay(display);
            instance.setAutAgentHost(EnvironmentUtils.getProcessOrSystemProperty((String)"com.bredexsw.guidancer.aut.register.autAgentHost"));
            instance.setAutAgentPort(EnvironmentUtils.getProcessOrSystemProperty((String)"com.bredexsw.guidancer.aut.register.autAgentPort"));
            instance.setAutID(EnvironmentUtils.getProcessOrSystemProperty((String)"com.bredexsw.guidancer.aut.register.autName"));
            instance.start(true);
            return instance;
        }
    }
}

