/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the Application component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * 
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2016-05-25T08:17:59.642Z")
public interface Application {
    
    
        /**
         * Performs arbitrary clicks into the currently active AUT window
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP clickInActiveWindow(@NonNull Integer numberOfClicks,@NonNull InteractionMode mouseButton,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param activationMethod 
         *        the AUT activation method to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP activate(@NonNull AUTActivationMethod activationMethod
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP inputText(@NonNull String text
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param modifierKeys 
         *        the modifier keys
         * @param baseKey 
         *        the base key to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP keyCombination(@NonNull Modifier[] modifierKeys,@NonNull String baseKey
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param key 
         *        the toggle key
         * @param activateKey 
         *        the activate key
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP setToggleKey(@NonNull Integer key,@NonNull Boolean activateKey
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param millisecs 
         *        the amount of milliseconds
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP delay(@NonNull Integer millisecs
        ) throws IllegalArgumentException;
        
        @NonNull public CAP pauseTestExecution(
        ) ;
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP waitForWindow(@NonNull String title,@NonNull Operator operator,@NonNull Integer timeoutInMs,@NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP waitForWindowActivation(@NonNull String title,@NonNull Operator operator,@NonNull Integer timeoutInMs,@NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterClosure 
         *        the static delay after closure
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP waitForWindowToClose(@NonNull String title,@NonNull Operator operator,@NonNull Integer timeoutInMs,@NonNull Integer delayAfterClosure
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param destination 
         *        the destination to use
         * @param delay 
         *        the static delay
         * @param fileAccess 
         *        the file access type
         * @param scalingFactor 
         *        the scaling factor
         * @param createDirectories 
         *        whether to implicitly create directories
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP takeScreenshot(@NonNull String destination,@NonNull Integer delay,@NonNull String fileAccess,@NonNull Integer scalingFactor,@NonNull Boolean createDirectories
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param modifierKeys 
         *        the modifier keys
         * @param baseKey 
         *        the base key to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP externalKeyCombination(@NonNull Modifier[] modifierKeys,@NonNull String baseKey
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP externalInputText(@NonNull String text
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP copyTextToClipboard(@NonNull String text
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param value1 
         *        the first value
         * @param comparisonMethod 
         *        the comparison method
         * @param value2 
         *        the second value
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.0
         */
        @NonNull public CAP checkNumericValues(@NonNull String value1,@NonNull NumberComparisonOperator comparisonMethod,@NonNull String value2
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param destination 
         *        the destination to use
         * @param delay 
         *        the static delay
         * @param fileAccess 
         *        the file access type
         * @param scalingFactor 
         *        the scaling factor
         * @param createDirectories 
         *        whether to implicitly create directories
         * @param marginTop 
         *        the top margin
         * @param marginRight 
         *        the right margin
         * @param marginBottom 
         *        the bottom margin
         * @param marginLeft 
         *        the left margin
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP takeScreenshotOfActiveWindow(@NonNull String destination,@NonNull Integer delay,@NonNull String fileAccess,@NonNull Integer scalingFactor,@NonNull Boolean createDirectories,@NonNull Integer marginTop,@NonNull Integer marginRight,@NonNull Integer marginBottom,@NonNull Integer marginLeft
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param value1 
         *        the first value
         * @param value2Operator 
         *        the operator used for comparison with value 2
         * @param value2 
         *        the second value
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkStringValues(@NonNull String value1,@NonNull String value2Operator,@NonNull String value2
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkExistenceOfWindow(@NonNull String title,@NonNull Operator operator,@NonNull Boolean exists
        ) throws IllegalArgumentException;
        
} 