/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.xml.businessmodell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.jubula.tools.internal.exception.ConfigXmlException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.xml.businessmodell.AbstractComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.InvalidComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;
import org.eclipse.jubula.tools.internal.xml.businessprocess.ConfigVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompSystem {
    private static Logger log = LoggerFactory.getLogger(CompSystem.class);
    private List<Component> m_components;
    private Map<String, Component> m_componentsByType;
    private Map<String, Component> m_componentsByTypeLowerCase;
    private List<AbstractComponent> m_abstractComponents;
    private List<ConcreteComponent> m_concreteComponents;
    private Map<String, Integer> m_eventTypes;
    private Component m_mostAbstractComponent;
    private Map<String, ToolkitDescriptor> m_toolkitDescriptors;
    private boolean m_initialized = false;
    private ConfigVersion m_configVersion = null;
    private Set<String> m_dataTypes = null;
    private Set<Param> m_parameter = null;

    public CompSystem() {
        this.init();
    }

    private void init() {
        if (this.m_components == null) {
            this.m_components = new ArrayList<Component>();
        }
        if (this.m_componentsByType == null) {
            this.m_componentsByType = new HashMap<String, Component>(1001);
        }
        if (this.m_componentsByTypeLowerCase == null) {
            this.m_componentsByTypeLowerCase = new HashMap<String, Component>(1001);
        }
        if (this.m_abstractComponents == null) {
            this.m_abstractComponents = new ArrayList<AbstractComponent>();
        }
        if (this.m_concreteComponents == null) {
            this.m_concreteComponents = new ArrayList<ConcreteComponent>();
        }
        if (this.m_eventTypes == null) {
            this.m_eventTypes = new HashMap<String, Integer>(4);
        }
        if (this.m_toolkitDescriptors == null) {
            this.m_toolkitDescriptors = new HashMap<String, ToolkitDescriptor>();
        }
        this.m_eventTypes.put("TestErrorEvent.Action", new Integer(7));
        this.m_eventTypes.put("TestErrorEvent.CompNotFound", new Integer(7));
        this.m_eventTypes.put("TestErrorEvent.Config", new Integer(1));
        this.m_eventTypes.put("TestErrorEvent.VerifyFailed", new Integer(1));
        this.m_initialized = true;
    }

    public List<Component> getComponents() {
        return this.m_components;
    }

    public List<Component> getComponents(String toolkitId, boolean addReferencedToolkits) {
        ArrayList<Component> toolkitComponents = new ArrayList<Component>();
        ToolkitDescriptor currDescriptor = this.getToolkitDescriptor(toolkitId);
        String includesToolkit = currDescriptor.getIncludes();
        ToolkitDescriptor includesDescriptor = this.getToolkitDescriptor(includesToolkit);
        if (includesDescriptor != null) {
            String includesLevel = includesDescriptor.getLevel();
            if (!"toolkit".equals(includesLevel)) {
                includesToolkit = "NoValidIncludeToolkit";
            }
        } else {
            includesToolkit = "NoValidIncludeToolkit";
        }
        List<String> dependsToolkits = this.getDependsToolkitIds(toolkitId);
        for (Component component : this.getComponents()) {
            String compToolkitId = component.getToolkitDesriptor().getToolkitID();
            if (!toolkitId.equals(compToolkitId) && (!includesToolkit.equals(compToolkitId) || !addReferencedToolkits) && (!dependsToolkits.contains(compToolkitId) || !addReferencedToolkits)) continue;
            toolkitComponents.add(component);
        }
        return toolkitComponents;
    }

    public List<AbstractComponent> getAbstractComponents() {
        return this.m_abstractComponents;
    }

    public List<ConcreteComponent> getConcreteComponents() {
        return this.m_concreteComponents;
    }

    private List<String> getIncludesToolkits(String toolkitId, List<String> toolkits) {
        String includes;
        toolkits.add(toolkitId);
        ToolkitDescriptor toolkitPluginDescriptor = this.getToolkitDescriptor(toolkitId);
        if (toolkitPluginDescriptor != null && !"null".equals(includes = toolkitPluginDescriptor.getIncludes())) {
            this.getIncludesToolkits(includes, toolkits);
        }
        return toolkits;
    }

    private List<String> getDependsToolkitIds(String toolkitId) {
        ArrayList<String> dependsToolkits = new ArrayList<String>();
        for (String tkId : this.m_toolkitDescriptors.keySet()) {
            ToolkitDescriptor tkDescr = this.m_toolkitDescriptors.get(tkId);
            if (!toolkitId.equals(tkDescr.getDepends())) continue;
            dependsToolkits.add(tkId);
        }
        return dependsToolkits;
    }

    public String[] getComponentTypes(String toolkitId) {
        ArrayList<String> compTypes = new ArrayList<String>();
        List<String> toolkits = new ArrayList<String>();
        toolkits = this.getIncludesToolkits(toolkitId, toolkits);
        toolkits.addAll(this.getDependsToolkitIds(toolkitId));
        for (Component comp : this.getComponents()) {
            String compToolkitId = comp.getToolkitDesriptor().getToolkitID();
            if (comp.isExtender() || !toolkits.contains(compToolkitId)) continue;
            compTypes.add(comp.getType());
        }
        return compTypes.toArray(new String[compTypes.size()]);
    }

    public Map<String, Integer> getEventTypes() {
        return this.m_eventTypes;
    }

    private void check(Component component) {
        for (Component current : this.getComponents()) {
            if (!current.getType().equals(component.getType())) continue;
            String msg = "multiple definition of component type " + component.getType();
            log.error(msg);
            throw new ConfigXmlException(msg, MessageIDs.E_MULTIPLE_COMPONENT);
        }
    }

    private void addAll(List components) {
        for (Component component : components) {
            this.check(component);
            this.getComponents().add(component);
            this.m_componentsByType.put(component.getType(), component);
            this.m_componentsByTypeLowerCase.put(component.getType().toLowerCase(), component);
        }
    }

    public void addEventType(String eventType, Integer reentryProp) {
        this.m_eventTypes.put(eventType, reentryProp);
    }

    public void addToolkitPluginDescriptor(String toolkitId, ToolkitDescriptor descriptor) {
        if (this.m_toolkitDescriptors == null) {
            this.m_toolkitDescriptors = new HashMap<String, ToolkitDescriptor>();
        }
        this.m_toolkitDescriptors.put(toolkitId, descriptor);
    }

    public ToolkitDescriptor getToolkitDescriptor(String toolkitId) {
        if (this.m_toolkitDescriptors == null) {
            this.m_toolkitDescriptors = new HashMap<String, ToolkitDescriptor>();
        }
        return this.m_toolkitDescriptors.get(toolkitId);
    }

    public List<ToolkitDescriptor> getAllToolkitDescriptors() {
        if (this.m_toolkitDescriptors == null) {
            this.m_toolkitDescriptors = new HashMap<String, ToolkitDescriptor>();
        }
        return new ArrayList<ToolkitDescriptor>(this.m_toolkitDescriptors.values());
    }

    public List<ToolkitDescriptor> getIndependentToolkitDescriptors(String level) {
        List<ToolkitDescriptor> toolkitDesriptors = this.getAllToolkitDescriptors();
        Collections.sort(toolkitDesriptors);
        Iterator<ToolkitDescriptor> descIt = toolkitDesriptors.iterator();
        while (descIt.hasNext()) {
            boolean removeDueToToolkitLevel;
            ToolkitDescriptor desc = descIt.next();
            String includes = desc.getIncludes();
            String toolkitID = desc.getToolkitID();
            boolean bl = removeDueToToolkitLevel = level != null && !level.equals(desc.getLevel());
            if (!removeDueToToolkitLevel && ("abstract".equals(level) || !"".equals(includes) && !"null".equals(includes.toLowerCase()) && !"".equals(toolkitID) && !"null".equals(toolkitID.toLowerCase()))) continue;
            descIt.remove();
        }
        return toolkitDesriptors;
    }

    public Set<String> getAllDataTypes() {
        if (this.m_dataTypes != null && !this.m_dataTypes.isEmpty()) {
            return this.m_dataTypes;
        }
        this.m_dataTypes = new HashSet<String>();
        List<Component> components = this.getComponents();
        for (Component component : components) {
            for (Action action : component.getActions()) {
                for (Param param : action.getParams()) {
                    this.m_dataTypes.add(param.getType());
                }
            }
        }
        return this.m_dataTypes;
    }

    public Component findComponent(String typeName) {
        Validate.notNull((Object)typeName);
        if ("".equals(typeName)) {
            if (log.isDebugEnabled()) {
                log.debug("CompSystem.findComponent(...) called with empty String. Returning InvalidComponent.");
            }
            return new InvalidComponent();
        }
        Component comp = this.m_componentsByType.get(typeName);
        if (comp != null) {
            return comp;
        }
        if (log.isDebugEnabled()) {
            String translatedName = CompSystemI18n.getString(typeName, true);
            String message = "Component " + translatedName + " does not exist";
            log.debug(message);
        }
        return new InvalidComponent();
    }

    public List<Component> findComponents(String typeName) {
        Validate.notNull((Object)typeName);
        LinkedList<Component> comps = new LinkedList<Component>();
        if ("".equals(typeName)) {
            if (log.isDebugEnabled()) {
                log.debug("CompSystem.findComponent(...) called with empty String. Returning InvalidComponent.");
            }
            comps.add(new InvalidComponent());
            return comps;
        }
        for (Component comp : this.getComponents()) {
            ConcreteComponent ccomp;
            if (!(comp instanceof ConcreteComponent) || !typeName.equals((ccomp = (ConcreteComponent)comp).getComponentClass().getName())) continue;
            comps.add(ccomp);
        }
        if (!comps.isEmpty()) {
            return comps;
        }
        if (log.isDebugEnabled()) {
            String translatedName = CompSystemI18n.getString(typeName, true);
            String message = "Component " + translatedName + " does not exist";
            log.debug(message);
        }
        comps.add(new InvalidComponent());
        return comps;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Abstract comps", this.m_abstractComponents).append("Concrete comps", this.m_concreteComponents).toString();
    }

    public void merge(CompSystem compSystem) {
        if (!this.m_initialized) {
            this.init();
        }
        if (compSystem.m_abstractComponents != null) {
            this.m_abstractComponents.addAll(compSystem.m_abstractComponents);
        }
        if (compSystem.m_concreteComponents != null) {
            this.m_concreteComponents.addAll(compSystem.m_concreteComponents);
        }
        if (compSystem.m_toolkitDescriptors != null) {
            this.m_toolkitDescriptors.putAll(compSystem.m_toolkitDescriptors);
        }
    }

    public void postProcess() {
        if (!this.m_initialized) {
            this.init();
        }
        this.addAll(this.m_concreteComponents);
        this.addAll(this.m_abstractComponents);
        for (Component component : this.getComponents()) {
            component.completeActions(this);
            this.handleRealizer(component);
            this.handleExtender(component);
            this.handleDepender(component);
        }
        this.validateComponents();
        for (Component component : this.getAbstractComponents()) {
            if (!component.getRealized().isEmpty()) continue;
            this.m_mostAbstractComponent = component;
            break;
        }
    }

    private void handleDepender(Component component) {
        ToolkitDescriptor dependsDescr;
        ToolkitDescriptor toolkitDesriptor = component.getToolkitDesriptor();
        String depends = toolkitDesriptor.getDepends();
        if (!component.isExtender() && !component.isRealizer() && !"null".equals(depends) && toolkitDesriptor.isUserToolkit() && (dependsDescr = this.m_toolkitDescriptors.get(depends)) != null) {
            component.setToolkitDesriptor(dependsDescr);
        }
    }

    private void validateComponents() {
        for (AbstractComponent ac : this.m_abstractComponents) {
            if (!ac.getRealizers().isEmpty()) continue;
            String message = "AbstractComponent " + ac.getType() + " has no realizing concreteComponents";
            if (ac.isVisible()) {
                log.error("visible " + message);
                throw new ConfigXmlException("visible " + message, MessageIDs.E_NO_ABSTRACT_COMPONENT);
            }
            log.warn(message);
        }
        for (ConcreteComponent cc : this.m_concreteComponents) {
            if (!cc.isExtender() || StringUtils.isBlank((String)cc.getComponentClass().getName())) continue;
            String msg = "Extending ConcreteComponent '" + cc.getType() + "' must not have a componentClass!";
            log.error(msg);
            throw new ConfigXmlException(msg, MessageIDs.E_GENERAL_COMPONENT_ERROR);
        }
    }

    private void handleRealizer(Component component) {
        boolean isConcrete = component.isConcrete();
        Set<Component> realizedSet = component.getAllRealized();
        for (Component realized : realizedSet) {
            if (isConcrete) {
                realized.addRealizer((ConcreteComponent)component);
            }
            realized.addAllRealizer(component);
        }
        if (isConcrete) {
            component.addRealizer((ConcreteComponent)component);
        }
        component.addAllRealizer(component);
    }

    private void handleExtender(Component component) {
        if (component.isExtender()) {
            List<Action> extenderActions = component.getActions();
            List<String> extendedTypes = component.getExtendedTypes();
            boolean isExtenderVisible = component.isVisible();
            for (String extendedType : extendedTypes) {
                Component extendedComponent = this.findComponent(extendedType);
                if (!extendedComponent.isVisible()) {
                    extendedComponent.setVisible(isExtenderVisible);
                }
                for (Action extenderAction : extenderActions) {
                    extendedComponent.addAction(extenderAction);
                    if (!(component instanceof ConcreteComponent) || !(extendedComponent instanceof ConcreteComponent)) continue;
                    ConcreteComponent extender = (ConcreteComponent)component;
                    ConcreteComponent extended = (ConcreteComponent)extendedComponent;
                    extended.setTesterClass(extender.getTesterClass());
                }
            }
        }
    }

    public ConfigVersion getConfigVersion() {
        return this.m_configVersion;
    }

    public Component getComponentForType(String type) {
        return this.m_componentsByTypeLowerCase.get(type.toLowerCase());
    }

    public final Component getMostAbstractComponent() {
        return this.m_mostAbstractComponent;
    }

    public final String getMoreConcreteType(String type1, String type2) {
        Component comp2;
        Component comp1 = this.getComponentForType(type1);
        Component moreConcreteComp = this.getMoreConcreteComponent(comp1, comp2 = this.getComponentForType(type2));
        return moreConcreteComp != null ? moreConcreteComp.getType() : null;
    }

    public final Component getMostConcrete(Component[] components) {
        Component mostConcrete = null;
        if (components.length > 0) {
            mostConcrete = components[0];
        }
        int i = 1;
        while (i < components.length && mostConcrete != null) {
            mostConcrete = this.getMoreConcreteComponent(mostConcrete, components[i]);
            ++i;
        }
        return mostConcrete;
    }

    private Component getMoreConcreteComponent(Component comp1, Component comp2) {
        return this.getMoreConcreteComponentImpl(comp1, comp2, true);
    }

    private Component getMoreConcreteComponentImpl(Component comp1, Component comp2, boolean isFirstCall) {
        if (comp1 == null || comp2 == null) {
            return null;
        }
        if (comp1.equals(comp2)) {
            return comp1;
        }
        String comp2Type = comp2.getType();
        for (Component realizer : comp1.getAllRealizers()) {
            if (!realizer.getType().equals(comp2Type)) continue;
            return realizer;
        }
        return isFirstCall ? this.getMoreConcreteComponentImpl(comp2, comp1, false) : null;
    }

    public final boolean isRealizing(String realizingType, String realizedType) {
        if (realizingType.equals(realizedType)) {
            return true;
        }
        Component realizer = this.findComponent(realizingType);
        return realizer.isRealizing(realizedType);
    }

    public List<ToolkitDescriptor> getIndependentToolkitDescriptors(boolean toolkitLevel) {
        String level = toolkitLevel ? "toolkit" : null;
        return this.getIndependentToolkitDescriptors(level);
    }

    public static String getComponentType(String componentClassName, Collection<Component> availableComponents) {
        Validate.notNull((Object)componentClassName);
        Validate.allElementsOfType(availableComponents, Component.class);
        for (Component currentComp : availableComponents) {
            if (!(currentComp instanceof ConcreteComponent) || !componentClassName.equals(((ConcreteComponent)currentComp).getComponentClass().getName())) continue;
            return currentComp.getType();
        }
        return null;
    }
}

