/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.core.model.LogicComponentNotManagedException;
import org.eclipse.jubula.client.core.model.ObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.ObjectMappingProfilePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.utils.ObjectMappingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

@Entity
@Table(name="OBJ_MAP")
class ObjectMappingPO
implements IObjectMappingPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
PersistenceWeavedRest {
    private transient Long m_id = null;
    private transient Integer m_version = null;
    private Long m_parentProjectId = null;
    private long m_timestamp = 0L;
    private IObjectMappingProfilePO m_profile = null;
    private IObjectMappingCategoryPO m_mappedCategory;
    private IObjectMappingCategoryPO m_unmappedLogicalCategory;
    private IObjectMappingCategoryPO m_unmappedTechnicalCategory;
    private Set<IObjectMappingAssoziationPO> m_mappings;
    private Map<String, IObjectMappingAssoziationPO> m_logicalNameToAssoc;
    static final long serialVersionUID = -6154970398733949103L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    private ObjectMappingPO() {
        this.m_logicalNameToAssoc = new HashMap<String, IObjectMappingAssoziationPO>(1001);
    }

    ObjectMappingPO(IObjectMappingCategoryPO mappedCategory, IObjectMappingCategoryPO unmappedLogicalCategory, IObjectMappingCategoryPO unmappedTechnicalCategory) {
        this.m_mappedCategory = mappedCategory;
        this.m_unmappedLogicalCategory = unmappedLogicalCategory;
        this.m_unmappedTechnicalCategory = unmappedTechnicalCategory;
        this.m_logicalNameToAssoc = new HashMap<String, IObjectMappingAssoziationPO>(1001);
    }

    @Override
    public IObjectMappingAssoziationPO addObjectMappingAssoziation(String logic, IComponentIdentifier technical) {
        IObjectMappingAssoziationPO oma = this.assignLogicalToTechnicalName(logic, technical);
        IObjectMappingCategoryPO assocSection = oma.getSection();
        IObjectMappingCategoryPO mappedSection = this.getMappedCategory();
        if (mappedSection == null || !mappedSection.equals(assocSection)) {
            IObjectMappingCategoryPO catToCreateIn = ObjectMappingEventDispatcher.getCategoryToCreateIn();
            IObjectMappingCategoryPO currentCategory = oma.getCategory();
            if (currentCategory != null) {
                currentCategory.removeAssociation(oma);
            }
            if (catToCreateIn != null) {
                catToCreateIn.addAssociation(oma);
            } else {
                this.getMappedCategory().addAssociation(oma);
            }
        }
        oma.setParentProjectId(this.getParentProjectId());
        return oma;
    }

    @Override
    public void removeAssociationFromCache(IObjectMappingAssoziationPO assoc) {
        if (this.m_mappings != null) {
            this.m_mappings.remove(assoc);
        }
        for (String logicalName : assoc.getLogicalNames()) {
            this.m_logicalNameToAssoc.remove(logicalName);
        }
    }

    @Override
    public IObjectMappingAssoziationPO addTechnicalName(IComponentIdentifier tech, IAUTMainPO aut) {
        if (!this.existTechnicalName(tech)) {
            IObjectMappingAssoziationPO asso = PoMaker.createObjectMappingAssoziationPO(tech);
            if (aut != null) {
                IObjectMappingCategoryPO categoryToCreateIn = ObjectMappingEventDispatcher.getCategoryToCreateIn();
                if (categoryToCreateIn != null) {
                    categoryToCreateIn.addAssociation(asso);
                } else {
                    this.getUnmappedTechnicalCategory().addAssociation(asso);
                }
            }
            asso.setParentProjectId(this.getParentProjectId());
            return asso;
        }
        return null;
    }

    @Override
    public IObjectMappingAssoziationPO assignLogicalToTechnicalName(String logic, IComponentIdentifier technical) {
        IObjectMappingAssoziationPO oma = null;
        if (this.existLogicalName(logic)) {
            oma = this.getLogicalNameAssoc(logic);
            oma.removeLogicalName(logic);
            if (oma.getLogicalNames().size() == 0 && oma.getTechnicalName() == null) {
                this.getMappings().remove(oma);
            }
        }
        if (!this.existTechnicalName(technical)) {
            oma = PoMaker.createObjectMappingAssoziationPO(technical, logic);
        } else {
            for (IObjectMappingAssoziationPO assoc : this.getMappings()) {
                oma = assoc;
                if (!technical.equals(oma.getTechnicalName())) continue;
                oma.addLogicalName(logic);
                break;
            }
        }
        oma.setParentProjectId(this.getParentProjectId());
        return oma;
    }

    @Override
    public boolean existTechnicalName(IComponentIdentifier technical) {
        for (IObjectMappingAssoziationPO oma : this.getMappings()) {
            if (!technical.equals(oma.getTechnicalName())) continue;
            return true;
        }
        return false;
    }

    private boolean existLogicalName(String logical) {
        return this.getLogicalNameAssoc(logical) != null;
    }

    @Override
    public IObjectMappingAssoziationPO getLogicalNameAssoc(String compNameGuid) {
        IObjectMappingAssoziationPO res = this.m_logicalNameToAssoc.get(compNameGuid);
        if (res != null) {
            return res;
        }
        for (IObjectMappingAssoziationPO assoc : this.getMappings()) {
            if (!assoc.getLogicalNames().contains(compNameGuid)) continue;
            this.m_logicalNameToAssoc.put(compNameGuid, assoc);
            return assoc;
        }
        return null;
    }

    @Override
    @Transient
    public int getTechnicalNamesSize() {
        int size = 0;
        for (IObjectMappingAssoziationPO oma : this.getMappings()) {
            if (oma.getTechnicalName() == null) continue;
            ++size;
        }
        return size;
    }

    @Override
    public IComponentIdentifier getTechnicalName(String logical) throws LogicComponentNotManagedException {
        IComponentNamePO compNamePo;
        IObjectMappingAssoziationPO asso = this.getLogicalNameAssoc(logical);
        if (asso == null && (compNamePo = ComponentNamesBP.getInstance().getCompNamePo(logical)) != null) {
            asso = this.getLogicalNameAssoc(compNamePo.getName());
        }
        if (asso == null) {
            throw new LogicComponentNotManagedException(NLS.bind((String)Messages.TheLogicComponentIsNotManaged, (Object)logical), MessageIDs.E_COMPONENT_NOT_MANAGED);
        }
        return ObjectMappingUtil.createCompIdentifierFromAssoziation(asso);
    }

    @Override
    @Transient
    public Set<IObjectMappingAssoziationPO> getMappings() {
        if (this.m_mappings == null) {
            HashSet<IObjectMappingAssoziationPO> mappings = new HashSet<IObjectMappingAssoziationPO>();
            this.addAssociations(mappings, this.getMappedCategory());
            this.addAssociations(mappings, this.getUnmappedLogicalCategory());
            this.addAssociations(mappings, this.getUnmappedTechnicalCategory());
            this.m_mappings = mappings;
        }
        return this.m_mappings;
    }

    private void clearMappingsCache() {
        this.m_logicalNameToAssoc.clear();
        this.m_mappings = null;
    }

    private void addAssociations(Set<IObjectMappingAssoziationPO> assocSet, IObjectMappingCategoryPO category) {
        Validate.noNullElements(category.getUnmodifiableAssociationList());
        assocSet.addAll(category.getUnmodifiableAssociationList());
        for (IObjectMappingCategoryPO subcategory : category.getUnmodifiableCategoryList()) {
            this.addAssociations(assocSet, subcategory);
        }
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    private void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
        for (IObjectMappingAssoziationPO assoPO : this.getMappings()) {
            assoPO.setParentProjectId(projectId);
        }
    }

    @Basic
    @Column(name="PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Transient
    public String getName() {
        return this.toString();
    }

    @Override
    @Basic
    @Column(name="TIMESTAMP")
    public long getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.m_timestamp = timestamp;
    }

    @Override
    @Transient
    public IObjectMappingProfilePO getProfile() {
        return this.getHbmProfile();
    }

    @Override
    public void setProfile(IObjectMappingProfilePO profile) {
        this.setHbmProfile(profile);
    }

    @ManyToOne(targetEntity=ObjectMappingProfilePO.class, optional=false, cascade={CascadeType.ALL})
    @JoinColumn(name="FK_PROFILE")
    private IObjectMappingProfilePO getHbmProfile() {
        return this.m_profile;
    }

    private void setHbmProfile(IObjectMappingProfilePO profile) {
        this.m_profile = profile;
    }

    @Override
    @OneToOne(targetEntity=ObjectMappingCategoryPO.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, optional=false)
    @BatchFetch(value=BatchFetchType.JOIN)
    public IObjectMappingCategoryPO getMappedCategory() {
        this.clearMappingsCache();
        return this.m_mappedCategory;
    }

    private void setMappedCategory(IObjectMappingCategoryPO mappedCategory) {
        this.m_mappedCategory = mappedCategory;
        this.clearMappingsCache();
    }

    @Override
    @OneToOne(targetEntity=ObjectMappingCategoryPO.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, optional=false)
    @BatchFetch(value=BatchFetchType.JOIN)
    public IObjectMappingCategoryPO getUnmappedLogicalCategory() {
        this.clearMappingsCache();
        return this.m_unmappedLogicalCategory;
    }

    private void setUnmappedLogicalCategory(IObjectMappingCategoryPO unmappedLogicalCategory) {
        this.m_unmappedLogicalCategory = unmappedLogicalCategory;
        this.clearMappingsCache();
    }

    @Override
    @OneToOne(targetEntity=ObjectMappingCategoryPO.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, optional=false)
    @BatchFetch(value=BatchFetchType.JOIN)
    public IObjectMappingCategoryPO getUnmappedTechnicalCategory() {
        this.clearMappingsCache();
        return this.m_unmappedTechnicalCategory;
    }

    private void setUnmappedTechnicalCategory(IObjectMappingCategoryPO unmappedTechnicalCategory) {
        this.m_unmappedTechnicalCategory = unmappedTechnicalCategory;
        this.clearMappingsCache();
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ObjectMappingPO();
    }

    public Object _persistence_get(String string) {
        if (string == "unmappedTechnicalCategory") {
            return this.unmappedTechnicalCategory;
        }
        if (string == "hbmProfile") {
            return this.hbmProfile;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "mappedCategory") {
            return this.mappedCategory;
        }
        if (string == "timestamp") {
            return this.timestamp;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        if (string == "unmappedLogicalCategory") {
            return this.unmappedLogicalCategory;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "unmappedTechnicalCategory") {
            this.unmappedTechnicalCategory = (IObjectMappingCategoryPO)object;
            return;
        }
        if (string == "hbmProfile") {
            this.hbmProfile = (IObjectMappingProfilePO)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        if (string == "mappedCategory") {
            this.mappedCategory = (IObjectMappingCategoryPO)object;
            return;
        }
        if (string == "timestamp") {
            this.timestamp = (Long)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        if (string == "unmappedLogicalCategory") {
            this.unmappedLogicalCategory = (IObjectMappingCategoryPO)object;
            return;
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

