/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.persistence.EntityManager;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.OMEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.JBException;

public class OMEditorBP {
    private transient IObjectMappingCategoryPO m_categoryToCreateIn;
    private ObjectMappingMultiPageEditor m_editor;

    public OMEditorBP(ObjectMappingMultiPageEditor editor) {
        this.setEditor(editor);
    }

    public IObjectMappingCategoryPO getCategoryToCreateIn() {
        return this.m_categoryToCreateIn;
    }

    public void setCategoryToCreateIn(IObjectMappingCategoryPO categoryToCreateIn) {
        this.m_categoryToCreateIn = categoryToCreateIn;
        ObjectMappingEventDispatcher.setCategoryToCreateIn((IObjectMappingCategoryPO)categoryToCreateIn);
    }

    public IObjectMappingCategoryPO deleteCategory(IObjectMappingCategoryPO toDelete) {
        IObjectMappingCategoryPO parent = toDelete.getParent();
        parent.removeCategory(toDelete);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)parent, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)toDelete, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.onlyInEditor);
        return parent;
    }

    public IObjectMappingCategoryPO deleteCompName(IComponentNamePO toDelete) {
        IObjectMappingCategoryPO originalCategory = null;
        IWritableComponentNameMapper compNameMapper = this.getEditor().getEditorHelper().getEditSupport().getCompMapper();
        IObjectMappingAssoziationPO parent = this.getAssociation(toDelete.getGuid());
        try {
            IComponentNamePO toRem;
            IObjectMappingCategoryPO category;
            compNameMapper.changeReuse((IComponentNameReuser)parent, toDelete.getGuid(), null);
            originalCategory = category = parent.getCategory();
            if (parent.getLogicalNames().isEmpty()) {
                if (originalCategory != null) {
                    originalCategory.removeAssociation(parent);
                }
                if (parent.getTechnicalName() != null) {
                    Stack<String> catPath = new Stack<String>();
                    while (category.getParent() != null) {
                        catPath.push(category.getName());
                        category = category.getParent();
                    }
                    IObjectMappingCategoryPO newCategory = this.getEditor().getAut().getObjMap().getUnmappedTechnicalCategory();
                    while (!catPath.isEmpty()) {
                        String catName = (String)catPath.pop();
                        IObjectMappingCategoryPO subcategory = this.findSubcategory(newCategory, catName);
                        if (subcategory == null) {
                            subcategory = PoMaker.createObjectMappingCategoryPO((String)catName);
                            newCategory.addCategory(subcategory);
                        }
                        newCategory = subcategory;
                    }
                    newCategory.addAssociation(parent);
                } else {
                    this.getEditor().getEditorHelper().getEditSupport().getSession().remove((Object)parent);
                }
            }
            EntityManager sess = this.getEditor().getEditorHelper().getEditSupport().getSession();
            if (toDelete.getId() != null && (toRem = (IComponentNamePO)sess.find(toDelete.getClass(), (Object)toDelete.getId())) != null) {
                sess.detach((Object)toRem);
            }
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.getEditor().getAut().getObjMap(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        }
        catch (IncompatibleTypeException ite) {
            ErrorHandlingUtil.createMessageDialog((JBException)((Object)ite), (Object[])ite.getErrorMessageParams(), null);
        }
        catch (PMException pme) {
            PMExceptionHandler.handlePMExceptionForEditor(pme, this.getEditor());
        }
        return originalCategory;
    }

    public IObjectMappingCategoryPO deleteAssociation(IObjectMappingAssoziationPO toDelete) {
        IObjectMappingCategoryPO parent = toDelete.getCategory();
        parent.removeAssociation(toDelete);
        this.getEditor().getAut().getObjMap().removeAssociationFromCache(toDelete);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)parent, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        return parent;
    }

    private IObjectMappingCategoryPO findSubcategory(IObjectMappingCategoryPO category, String subcategoryName) {
        for (IObjectMappingCategoryPO subcategory : category.getUnmodifiableCategoryList()) {
            if (!subcategoryName.equals(subcategory.getName())) continue;
            return subcategory;
        }
        return null;
    }

    public IObjectMappingAssoziationPO getAssociation(String compNameGuid) {
        IObjectMappingPO objMap = this.getEditor().getAut().getObjMap();
        return objMap.getLogicalNameAssoc(compNameGuid);
    }

    public boolean existCategory(IObjectMappingCategoryPO start, String name) {
        for (IObjectMappingCategoryPO child : start.getUnmodifiableCategoryList()) {
            if (!child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public IObjectMappingCategoryPO getSection(IComponentNamePO compNamePo) {
        IObjectMappingAssoziationPO assoc = this.getAssociation(compNamePo.getGuid());
        if (assoc != null) {
            return OMEditorDndSupport.getSection(assoc);
        }
        return null;
    }

    public IObjectMappingCategoryPO getCategory(IComponentNamePO compNamePo) {
        IObjectMappingAssoziationPO assoc = this.getAssociation(compNamePo.getGuid());
        return assoc.getCategory();
    }

    public IObjectMappingCategoryPO createCategory(IObjectMappingCategoryPO section, IObjectMappingCategoryPO subcategory) {
        IObjectMappingCategoryPO curCat = section;
        for (String pathEntry : this.getCatPath(subcategory)) {
            boolean childExists = false;
            for (IObjectMappingCategoryPO child : curCat.getUnmodifiableCategoryList()) {
                if (!child.getName().equals(pathEntry)) continue;
                curCat = child;
                childExists = true;
                break;
            }
            if (childExists) continue;
            IObjectMappingCategoryPO newCat = PoMaker.createObjectMappingCategoryPO((String)pathEntry);
            curCat.addCategory(newCat);
            curCat = newCat;
        }
        return curCat;
    }

    private List<String> getCatPath(IObjectMappingCategoryPO category) {
        ArrayList<String> catPath = new ArrayList<String>();
        IObjectMappingCategoryPO curCat = category;
        while (curCat.getParent() != null) {
            catPath.add(curCat.getName());
            curCat = curCat.getParent();
        }
        Collections.reverse(catPath);
        return catPath;
    }

    public void collectNewLogicalComponentNames() {
        if (this.getEditor().cleanupNames() > 0) {
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.getEditor().getAut().getObjMap(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        }
    }

    private void setEditor(ObjectMappingMultiPageEditor editor) {
        this.m_editor = editor;
    }

    private ObjectMappingMultiPageEditor getEditor() {
        return this.m_editor;
    }
}

