/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete;

import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.ToolkitInfo;


/**
 * Factory for creating components from the concrete toolkit.
 * @noextend This class is not intended to be extended by clients.
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.FactoryGenerator", 
           date =  "2016-11-23T10:28:05.019Z")
public class ConcreteComponents {
    

    private ConcreteComponents() {
        super();
    }
    

    /** create a new representative for a ButtonComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ButtonComponent createButtonComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.ButtonComponent(componentIdentifier);
    }
    
    /** create a new representative for a ButtonComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ButtonComponentActionHandler createButtonComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ButtonComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.handler.ButtonComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a ComboComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ComboComponent createComboComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.ComboComponent(componentIdentifier);
    }
    
    /** create a new representative for a ComboComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ComboComponentActionHandler createComboComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ComboComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.handler.ComboComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a ListComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.ListComponent createListComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.ListComponent(componentIdentifier);
    }
    
    /** create a new representative for a ListComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.ListComponentActionHandler createListComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.ListComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.handler.ListComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a TextComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextComponent createTextComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.TextComponent(componentIdentifier);
    }
    
    /** create a new representative for a TextComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextComponentActionHandler createTextComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.handler.TextComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a TabComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TabComponent createTabComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.TabComponent(componentIdentifier);
    }
    
    /** create a new representative for a TabComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TabComponentActionHandler createTabComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TabComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.handler.TabComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a TableComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TableComponent createTableComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TableComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.TableComponent(componentIdentifier);
    }
    
    /** create a new representative for a TableComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TableComponentActionHandler createTableComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TableComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.handler.TableComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a TextInputComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TextInputComponent createTextInputComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.TextInputComponent(componentIdentifier);
    }
    
    /** create a new representative for a TextInputComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TextInputComponentActionHandler createTextInputComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TextInputComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.handler.TextInputComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a TreeComponent UI component.
     * 
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.TreeComponent createTreeComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TreeComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.TreeComponent(componentIdentifier);
    }
    
    /** create a new representative for a TreeComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.TreeComponentActionHandler createTreeComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.TreeComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.handler.TreeComponentActionHandler(componentIdentifier);
    }
    /** create a new representative for a SliderComponent UI component.
     * @since 4.0
     */
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.SliderComponent createSliderComponent (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.SliderComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.SliderComponent(componentIdentifier);
    }
    
    /** create a new representative for a SliderComponent UI component.
     * @since 4.0
     */
    @Beta
    @NonNull public static org.eclipse.jubula.toolkit.concrete.components.handler.SliderComponentActionHandler createSliderComponentActionHandler (@NonNull ComponentIdentifier<? extends org.eclipse.jubula.toolkit.concrete.components.SliderComponent> componentIdentifier) {
        Validate.notNull(componentIdentifier);
        return new org.eclipse.jubula.toolkit.concrete.internal.impl.handler.SliderComponentActionHandler(componentIdentifier);
    }
}