/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.IObjectMappingObserver;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;

public class ObjectMappingEventDispatcher {
    private static List<IObjectMappingObserver> observer = new ArrayList<IObjectMappingObserver>();
    private static IObjectMappingCategoryPO categoryToCreateIn;

    private ObjectMappingEventDispatcher() {
    }

    public static synchronized void notifyRecordObserver(ISpecTestCasePO tc) {
        ObjectMappingEventDispatcher.notifyRecordObserverTS(new ITestSuitePO[0]);
    }

    public static synchronized void notifyRecordObserverTS(ITestSuitePO ... testSuites) {
        IProjectPO iProjectPO;
        List<IObjectMappingObserver> obs = Collections.unmodifiableList(observer);
        if (obs.isEmpty()) {
            return;
        }
        Set<Object> autList = new HashSet(1);
        if (testSuites.length == 0 && (iProjectPO = GeneralStorage.getInstance().getProject()) != null) {
            autList = iProjectPO.getAutMainList();
        }
        ITestSuitePO[] iTestSuitePOArray = testSuites;
        int n = testSuites.length;
        int n2 = 0;
        while (n2 < n) {
            ITestSuitePO iTestSuitePO = iTestSuitePOArray[n2];
            IAUTMainPO aut = iTestSuitePO.getAut();
            if (aut != null) {
                autList.add(aut);
            }
            ++n2;
        }
        for (IAUTMainPO iAUTMainPO : autList) {
            for (IObjectMappingObserver obsvr : obs) {
                try {
                    obsvr.update(1, iAUTMainPO);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void notifyObjectMappedObserver(IComponentIdentifier[] tech) {
        List<IObjectMappingObserver> obs = Collections.unmodifiableList(observer);
        for (IObjectMappingObserver obsvr : obs) {
            try {
                obsvr.update(2, tech);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void addObserver(IObjectMappingObserver obs) {
        if (!observer.contains(obs)) {
            observer.add(obs);
        }
    }

    public static void removeObserver(IObjectMappingObserver obs) {
        if (observer.contains(obs)) {
            observer.remove(obs);
        }
    }

    public static IObjectMappingCategoryPO getCategoryToCreateIn() {
        return categoryToCreateIn;
    }

    public static void setCategoryToCreateIn(IObjectMappingCategoryPO c) {
        categoryToCreateIn = c;
    }
}

