/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.EventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ParamNodePO;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

@Entity
@DiscriminatorValue(value="T")
abstract class TestCasePO
extends ParamNodePO
implements ITestCasePO,
PersistenceWeaved,
PersistenceObject {
    private Map<String, IEventExecTestCasePO> m_eventExecTcMap = new HashMap<String, IEventExecTestCasePO>(4);
    static final long serialVersionUID = 5364633016625734724L;

    public TestCasePO(String name, boolean isGenerated) {
        super(name, isGenerated);
    }

    public TestCasePO(String name, String guid, boolean isGenerated) {
        super(name, guid, isGenerated);
    }

    TestCasePO() {
    }

    @Override
    @OneToMany(targetEntity=EventExecTestCasePO.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinTable(name="EVENT_HANDLERS", inverseJoinColumns={@JoinColumn(name="TEST_CASE_ID")}, joinColumns={@JoinColumn(name="EVENT_HANDLER_ID")})
    @MapKeyColumn(name="EVENT_TYPE_KEY", nullable=false, table="EVENT_HANDLERS")
    @BatchFetch(value=BatchFetchType.JOIN)
    public Map<String, IEventExecTestCasePO> getEventExecTcMap() {
        return this.m_eventExecTcMap;
    }

    private void setEventExecTcMap(Map<String, IEventExecTestCasePO> eventExecTestCaseList) {
        this.m_eventExecTcMap = eventExecTestCaseList;
    }

    @Override
    public void addEventTestCase(IEventExecTestCasePO eventTC) throws InvalidDataException {
        if (this.getEventExecTcMap().containsKey(eventTC.getEventType())) {
            throw new InvalidDataException(String.valueOf(Messages.DoubleEventTestCaseForTheSameEvent) + " " + "/" + eventTC.getEventType() + "/", MessageIDs.E_DOUBLE_EVENT);
        }
        this.getEventExecTcMap().put(eventTC.getEventType(), eventTC);
        eventTC.setParentProjectId(this.getParentProjectId());
        eventTC.setParentNode(this);
    }

    @Override
    public IEventExecTestCasePO getEventExecTC(String eventType) {
        this.setParents(this.getEventExecTcMap().values());
        return this.getEventExecTcMap().get(eventType);
    }

    @Override
    @Transient
    public Collection<IEventExecTestCasePO> getAllEventEventExecTC() {
        Collection<IEventExecTestCasePO> evHandlers = this.getEventExecTcMap().values();
        this.setParents(evHandlers);
        return Collections.unmodifiableCollection(evHandlers);
    }

    @Override
    public Iterator<INodePO> getAllNodeIter() {
        return new AllNodeIterator(this);
    }

    @Override
    public void setParentProjectId(Long projectId) {
        super.setParentProjectId(projectId);
        for (IEventExecTestCasePO eh : this.getAllEventEventExecTC()) {
            eh.setParentProjectId(projectId);
        }
    }

    private void setParents(Collection<IEventExecTestCasePO> evHandlers) {
        for (IEventExecTestCasePO evTc : evHandlers) {
            evTc.setParentNode(this);
        }
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TestCasePO();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "eventExecTcMap") {
            return this.eventExecTcMap;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "eventExecTcMap") {
            this.eventExecTcMap = (Map)object;
            return;
        }
        super._persistence_set(string, object);
    }

    private class AllNodeIterator
    implements Iterator<INodePO> {
        private Iterator<INodePO> m_normals;
        private Iterator<IEventExecTestCasePO> m_events;

        private AllNodeIterator(ITestCasePO tc) {
            this.m_normals = tc.getNodeListIterator();
            this.m_events = tc.getAllEventEventExecTC().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.m_normals != null) {
                if (this.m_normals.hasNext()) {
                    return true;
                }
                this.m_normals = null;
            }
            return this.m_events.hasNext();
        }

        @Override
        public INodePO next() {
            if (!this.hasNext()) {
                return null;
            }
            if (this.m_normals != null) {
                return this.m_normals.next();
            }
            return this.m_events.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support remove.");
        }
    }
}

