/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jubula.client.core.businessprocess.CompNameMapperFactory;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesDecorator;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITcParamDescriptionPO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.JBFatalAbortException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditSupport {
    private static Logger log = LoggerFactory.getLogger(EditSupport.class);
    private EntityManager m_session;
    private IPersistentObject m_workVersion;
    private List<IPersistentObject> m_lockedObjects = new ArrayList<IPersistentObject>();
    private EntityTransaction m_transaction = null;
    private boolean m_isLocked = false;
    private boolean m_isValid = true;
    private ParamNameBPDecorator m_paramMapper = null;
    private IWritableComponentNameMapper m_compMapper;

    public EditSupport(IPersistentObject po, ParamNameBPDecorator paramMapper) throws PMException {
        this.init();
        this.m_workVersion = this.createWorkVersion(po);
        this.m_paramMapper = paramMapper;
        this.m_compMapper = CompNameMapperFactory.createCompNameMapper(this.m_workVersion, new ComponentNamesDecorator(this.getSession()));
    }

    private void init() {
        this.m_workVersion = null;
        this.m_isValid = true;
        this.m_session = Persistor.instance().openSession();
        this.m_transaction = Persistor.instance().getTransaction(this.m_session);
    }

    public IPersistentObject createWorkVersion(IPersistentObject po) throws PMException {
        Assert.verify((boolean)this.m_isValid, (String)Messages.InvalidInstanceForInvokingOfThisMethod);
        Validate.notNull((Object)po, (String)(String.valueOf(Messages.OriginalObjectForCreatingOfWorkversionIsNull) + "."));
        try {
            IPersistentObject result = (IPersistentObject)this.m_session.find(po.getClass(), (Object)po.getId());
            if (result == null) {
                throw new EntityNotFoundException(String.valueOf(Messages.UnableToFind) + " " + po.getClass().getName() + " " + Messages.WithID + " " + po.getId());
            }
            if (result.getVersion() == null || po.getVersion() > result.getVersion()) {
                this.m_session.detach((Object)result);
                result = (IPersistentObject)this.m_session.find(po.getClass(), (Object)po.getId());
                if (result == null) {
                    throw new EntityNotFoundException(String.valueOf(Messages.UnableToFind) + " " + po.getClass().getName() + " " + Messages.WithID + " " + po.getId());
                }
            }
            return result;
        }
        catch (PersistenceException e) {
            PersistenceManager.handleDBExceptionForEditor(po, e, this);
            return null;
        }
    }

    public void lockWorkVersion() throws PMReadException, PMAlreadyLockedException, PMDirtyVersionException, PMException {
        Assert.verify((boolean)this.m_isValid, (String)Messages.InvalidInstanceForInvokingOfThisMethod);
        try {
            if (this.m_workVersion instanceof ISpecTestCasePO) {
                List<IParamDescriptionPO> list = ((ISpecTestCasePO)this.m_workVersion).getParameterList();
                for (IParamDescriptionPO desc : list) {
                    ((ITcParamDescriptionPO)desc).setParamNameMapper(this.m_paramMapper);
                }
            } else if (this.m_workVersion instanceof ITestDataCategoryPO) {
                for (IParameterInterfacePO iParameterInterfacePO : ((ITestDataCategoryPO)this.m_workVersion).getTestDataChildren()) {
                    List<IParamDescriptionPO> params = iParameterInterfacePO.getParameterList();
                    for (IParamDescriptionPO desc : params) {
                        ((ITcParamDescriptionPO)desc).setParamNameMapper(this.m_paramMapper);
                    }
                }
            }
            Persistor.instance().lockPO(this.m_session, this.m_workVersion);
            this.m_lockedObjects.add(this.m_workVersion);
            this.m_isLocked = true;
        }
        catch (PersistenceException persistenceException) {
            PersistenceManager.handleDBExceptionForEditor(this.m_workVersion, persistenceException, this);
        }
    }

    private void closeSession() {
        if (Persistor.instance() != null) {
            Persistor.instance().dropSession(this.m_session);
        }
        this.invalidate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveWorkVersion() throws PMReadException, PMSaveException, PMException, ProjectDeletedException, IncompatibleTypeException {
        if (!this.m_isValid) throw new JBFatalAbortException(String.valueOf(Messages.NotAllowedToSaveAnUnlockedWorkversion) + ".", MessageIDs.E_CANNOT_SAVE_INVALID);
        if (!this.m_isLocked) throw new JBFatalAbortException(String.valueOf(Messages.NotAllowedToSaveAnUnlockedWorkversion) + ".", MessageIDs.E_CANNOT_SAVE_UNLOCKED);
        this.trackChanges();
        boolean stayLocked = false;
        try {
            try {
                boolean mayModifyParamNames;
                boolean bl = mayModifyParamNames = this.m_workVersion instanceof ISpecTestCasePO || this.m_workVersion instanceof ITestDataCategoryPO;
                if (mayModifyParamNames) {
                    this.saveParamNames();
                }
                if (mayModifyParamNames || ((JpaEntityManager)this.m_session.unwrap(JpaEntityManager.class)).getUnitOfWork().hasChanges()) {
                    this.saveComponentNames();
                    Persistor.instance().commitTransaction(this.m_session, this.m_transaction);
                    Long projId = GeneralStorage.getInstance().getProject().getId();
                    if (this.m_paramMapper != null) {
                        this.m_paramMapper.updateStandardMapperAndCleanup(projId);
                    }
                    if (this.m_compMapper != null) {
                        this.m_compMapper.getCompNameCache().updateStandardMapperAndCleanup(projId);
                    }
                    this.refreshOriginalVersions();
                } else {
                    Persistor.instance().rollbackTransaction(this.m_session, this.m_transaction);
                }
                this.m_lockedObjects.clear();
                if (this.m_session != null) {
                    this.m_transaction = this.m_session.getTransaction();
                    this.m_transaction.begin();
                    return;
                } else {
                    this.init();
                }
                return;
            }
            catch (IncompatibleTypeException ite) {
                stayLocked = true;
                throw ite;
            }
            catch (PersistenceException e) {
                PersistenceManager.handleDBExceptionForEditor(this.m_workVersion, e, this);
                this.m_isLocked = stayLocked;
                return;
            }
        }
        finally {
            this.m_isLocked = stayLocked;
        }
    }

    private void trackChanges() {
        if (this.m_workVersion instanceof ISpecTestCasePO || this.m_workVersion instanceof ITestSuitePO || this.m_workVersion instanceof ITestJobPO) {
            INodePO node = (INodePO)this.m_workVersion;
            node.addTrackedChange("modified", true);
        }
    }

    private void saveParamNames() throws PMException {
        this.m_paramMapper.persist(this.m_session, GeneralStorage.getInstance().getProject().getId());
    }

    private void saveComponentNames() throws PMException, IncompatibleTypeException {
        if (this.m_compMapper != null) {
            CompNamePM.flushCompNames(this.m_session, GeneralStorage.getInstance().getProject().getId(), this.m_compMapper);
        }
    }

    private void refreshOriginalVersions() throws ProjectDeletedException {
        try {
            EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
            IPersistentObject original = this.getOriginal();
            if (original != null) {
                masterSession.refresh(masterSession.merge((Object)this.getWorkVersion()));
                GeneralStorage.getInstance().fireDataModified(original);
            }
        }
        catch (PersistenceException e) {
            log.error(String.valueOf(Messages.RefreshOfOriginalVersionFailed) + ".", (Throwable)e);
            GeneralStorage.getInstance().reloadMasterSession((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void close() {
        Assert.verify((boolean)this.m_isValid, (String)Messages.InvalidInstanceForInvokingOfThisMethod);
        this.closeSession();
    }

    private void invalidate() {
        this.m_isValid = false;
        this.m_isLocked = false;
        this.m_workVersion = null;
        this.m_transaction = null;
        this.m_session = null;
        this.m_lockedObjects.clear();
    }

    public IPersistentObject getOriginal() {
        return (IPersistentObject)GeneralStorage.getInstance().getMasterSession().find(this.m_workVersion.getClass(), (Object)this.m_workVersion.getId());
    }

    public List<IPersistentObject> getLockedObjects() {
        return this.m_lockedObjects;
    }

    public IPersistentObject getWorkVersion() {
        return this.m_workVersion;
    }

    public EntityManager getSession() {
        return this.m_session;
    }

    public void reinitializeEditSupport() throws PMException {
        try {
            IPersistentObject workVersion = this.m_workVersion;
            this.close();
            this.init();
            this.m_workVersion = workVersion;
            this.m_compMapper.setCompNameCache(new ComponentNamesDecorator(this.getSession()));
            this.m_workVersion = (IPersistentObject)this.m_session.merge((Object)this.m_workVersion);
            this.m_compMapper.setContext(this.m_workVersion);
        }
        catch (PersistenceException persistenceException) {
            String msg = Messages.ReinitOfSessionFailed;
            log.error(msg);
            throw new PMException(msg, MessageIDs.E_DATABASE_GENERAL);
        }
    }

    public void reloadEditSession() throws PMException {
        try {
            IPersistentObject workVersion = this.m_workVersion;
            this.close();
            this.init();
            this.m_workVersion = this.createWorkVersion(workVersion);
            this.m_compMapper.setCompNameCache(new ComponentNamesDecorator(this.getSession()));
            this.m_compMapper.setContext(this.m_workVersion);
            if (this.m_paramMapper != null) {
                Long projId = GeneralStorage.getInstance().getProject().getId();
                this.m_paramMapper.updateStandardMapperAndCleanup(projId);
            }
        }
        catch (PersistenceException persistenceException) {
            String msg = Messages.ReinitOfSessionFailed;
            log.error(msg);
            throw new PMException(msg, MessageIDs.E_DATABASE_GENERAL);
        }
    }

    public IProjectPO getWorkProject() throws PMException {
        IProjectPO masterProj = GeneralStorage.getInstance().getProject();
        IProjectPO workProj = null;
        try {
            workProj = (IProjectPO)this.m_session.find(masterProj.getClass(), (Object)masterProj.getId());
            if (workProj == null) {
                throw new EntityNotFoundException(String.valueOf(Messages.UnableToFind) + " " + masterProj.getClass().getName() + " " + Messages.WithID + " " + masterProj.getId());
            }
            return workProj;
        }
        catch (PersistenceException e) {
            PersistenceManager.handleDBExceptionForEditor(masterProj, e, this);
            return null;
        }
    }

    public ParamNameBPDecorator getParamMapper() {
        return this.m_paramMapper;
    }

    public IWritableComponentNameMapper getCompMapper() {
        return this.m_compMapper;
    }
}

