/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.filter;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jubula.client.core.model.IDataSetPO;

public class DataSetFilter
extends ViewerFilter {
    private final String m_dotStar = ".*";
    private String m_searchString;

    public void setSearchText(String origText) {
        String text = this.cleanText(origText);
        this.m_searchString = text == null ? null : ".*" + text + ".*";
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.m_searchString == null || this.m_searchString.length() == 0 || !(element instanceof IDataSetPO)) {
            return true;
        }
        for (String value : ((IDataSetPO)element).getColumnStringValues()) {
            if (value == null || !value.matches(this.m_searchString)) continue;
            return true;
        }
        return false;
    }

    private String cleanText(String searchString) {
        if (searchString == null || searchString.isEmpty()) {
            return null;
        }
        String result = searchString;
        while (result.startsWith("*")) {
            result = result.substring(1, result.length());
        }
        while (result.endsWith("*")) {
            result = result.substring(0, result.length() - 1);
        }
        result = result.replace("*", ".*");
        return result;
    }
}

