/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.util.Collection;
import java.util.List;
import javax.persistence.PersistenceException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTreeItemHandlerTCEditor
extends AbstractDeleteTreeItemHandler {
    private static Logger log = LoggerFactory.getLogger(DeleteTreeItemHandlerTCEditor.class);

    public Object executeImpl(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractJBEditor) {
            final AbstractJBEditor tce = (AbstractJBEditor)activePart;
            tce.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    IStructuredSelection structuredSelection = DeleteTreeItemHandlerTCEditor.this.getSelection();
                    if (DeleteTreeItemHandlerTCEditor.this.confirmDelete(structuredSelection)) {
                        DeleteTreeItemHandlerTCEditor.deleteNodesFromEditor(structuredSelection.toList(), tce);
                    }
                }
            });
        }
        return null;
    }

    public static void deleteNodesFromEditor(List<? extends INodePO> nodes, AbstractJBEditor editor) {
        editor.getEditorHelper().getClipboard().clearContents();
        for (INodePO iNodePO : nodes) {
            try {
                iNodePO.getParentNode().removeNode(iNodePO);
                if (iNodePO instanceof IExecTestCasePO) {
                    IExecTestCasePO po = (IExecTestCasePO)iNodePO;
                    Collection col = po.getCompNamesPairs();
                    for (ICompNamesPairPO iCompNamesPairPO : col) {
                        iCompNamesPairPO.getSecondName();
                    }
                    int i = po.getDataManager().getDataSetCount() - 1;
                    while (i >= 0) {
                        po.getDataManager().removeDataSet(i);
                        --i;
                    }
                }
                if (iNodePO.getId() != null) {
                    editor.getEditorHelper().getEditSupport().getSession().remove((Object)iNodePO);
                }
                DeleteTreeItemHandlerTCEditor.createReuseEvents(editor, iNodePO);
                editor.getEditorHelper().setDirty(true);
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)iNodePO, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.onlyInEditor);
            }
            catch (PersistenceException e) {
                try {
                    PersistenceManager.handleDBExceptionForEditor((IPersistentObject)iNodePO, (PersistenceException)e, (EditSupport)editor.getEditorHelper().getEditSupport());
                }
                catch (PMException pme) {
                    PMExceptionHandler.handlePMExceptionForMasterSession(pme);
                }
            }
        }
    }

    private static void createReuseEvents(AbstractJBEditor editor, INodePO node) {
        if (node instanceof IExecTestCasePO) {
            IWritableComponentNameMapper mapper = editor.getEditorHelper().getEditSupport().getCompMapper();
            IWritableComponentNameCache cache = mapper.getCompNameCache();
            IExecTestCasePO exec = (IExecTestCasePO)node;
            Collection compNamesPairs = exec.getCompNamesPairs();
            for (ICompNamesPairPO iCompNamesPairPO : compNamesPairs) {
                IComponentNamePO compName = cache.getCompNamePo(iCompNamesPairPO.getFirstName());
                try {
                    new CompNamesBP().updateCompNamesPair(exec, iCompNamesPairPO, compName.getName(), mapper);
                }
                catch (IncompatibleTypeException | PMException e) {
                    log.warn("error occured during update of component names from deleted node", e);
                }
            }
        }
    }
}

