/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets.autconfig;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.ui.rcp.businessprocess.RemoteFileBrowserBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.widgets.autconfig.AutConfigComponent;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.client.ui.widgets.I18nEnumCombo;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.jubula.toolkit.common.monitoring.MonitoringRegistry;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaAutConfigComponent
extends AutConfigComponent {
    public static final String AUT_CONFIG_DIALOG_MODE_KEY_DEFAULT = AutConfigComponent.Mode.BASIC.name();
    private static final String MAIN_CLASS = "Main-Class";
    private static final String DEFAULT_WIN_JRE = "../jre/bin/java.exe";
    private static boolean isExecFieldEmpty = true;
    private static String executablePath;
    private static Logger log;
    private boolean m_isExecFieldValid = true;
    private Text m_jarTextField;
    private Button m_jarButton;
    private Text m_execTextField;
    private Button m_execButton;
    private Text m_autArgsTextField;
    private I18nEnumCombo<IAUTConfigPO.ActivationMethod> m_activationMethodCombo;
    private Text m_autJreTextField;
    private Button m_autJreButton;
    private Composite m_autJreComposite;
    private Text m_autJreParamTextField;
    private DirectCombo<String> m_monitoringCombo;
    private Text m_envTextArea;
    private WidgetModifyListener m_modifyListener;
    private WidgetFocusListener m_focusListener;
    private WidgetSelectionListener m_selectionListener;

    static {
        log = LoggerFactory.getLogger(JavaAutConfigComponent.class);
    }

    public JavaAutConfigComponent(Composite parent, int style, Map<String, String> autConfig, String autName) {
        super(parent, style, autConfig, autName, true);
    }

    public static boolean isExecFieldEmpty() {
        return isExecFieldEmpty;
    }

    @Override
    protected void createBasicArea(Composite basicAreaComposite) {
        super.createBasicArea(basicAreaComposite);
        this.initGUIAutConfigSettings(basicAreaComposite);
    }

    private void initGUIAutConfigSettings(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.exec");
        this.m_execTextField = UIComponentHelper.createTextField((Composite)parent, (int)1);
        LayoutUtil.setMaxChar((Text)this.m_execTextField, (int)4000);
        this.m_execButton = new Button(UIComponentHelper.createLayoutComposite((Composite)parent), 8);
        this.m_execButton.setText(Messages.AUTConfigComponentBrowse);
        this.m_execButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_execButton.setEnabled(Utils.isLocalhost());
    }

    @Override
    protected boolean putConfigValue(String key, String value) {
        boolean hasChanged = super.putConfigValue(key, value);
        if (hasChanged) {
            boolean isJarEmpty;
            for (Control field : this.getJavaRelatedFields()) {
                field.setEnabled(true);
            }
            boolean enableJarField = true;
            this.m_jarTextField.setEnabled(enableJarField);
            this.m_jarButton.setEnabled(enableJarField && (this.checkLocalhostServer() || this.isRemoteRequest()));
            String exe = this.getConfigValue("EXECUTABLE");
            boolean isEmpty = exe == null || exe.length() == 0;
            for (Control field : this.getJavaRelatedFields()) {
                field.setEnabled(isEmpty && field.isEnabled());
            }
            String jar = this.getConfigValue("JAR_FILE");
            boolean enableExe = isJarEmpty = jar == null || jar.length() == 0;
            this.m_execTextField.setEnabled(enableExe);
            this.m_execButton.setEnabled(enableExe && (this.checkLocalhostServer() || this.isRemoteRequest()));
        }
        return hasChanged;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        this.m_activationMethodCombo.addSelectionListener((SelectionListener)selectionListener);
        this.m_autJreParamTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_envTextArea.addModifyListener((ModifyListener)modifyListener);
        this.m_jarButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_jarTextField.addModifyListener((ModifyListener)modifyListener);
        this.getAUTAgentHostNameCombo().addModifyListener((ModifyListener)modifyListener);
        this.m_autJreButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_autJreTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_autArgsTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_execTextField.addFocusListener((FocusListener)this.getFocusListener());
        this.m_execTextField.addModifyListener((ModifyListener)modifyListener);
        this.m_execButton.addSelectionListener((SelectionListener)selectionListener);
        this.m_monitoringCombo.addSelectionListener((SelectionListener)selectionListener);
    }

    @Override
    protected void deinstallListeners() {
        super.deinstallListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        WidgetSelectionListener selectionListener = this.getSelectionListener();
        this.m_activationMethodCombo.removeSelectionListener((SelectionListener)selectionListener);
        this.m_autJreParamTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_envTextArea.removeModifyListener((ModifyListener)modifyListener);
        this.m_autJreButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_autJreTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_jarButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_jarTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_autArgsTextField.removeModifyListener((ModifyListener)modifyListener);
        this.getAUTAgentHostNameCombo().removeModifyListener((ModifyListener)modifyListener);
        this.m_execTextField.removeFocusListener((FocusListener)this.getFocusListener());
        this.m_execTextField.removeModifyListener((ModifyListener)modifyListener);
        this.m_execButton.removeSelectionListener((SelectionListener)selectionListener);
        this.m_monitoringCombo.removeSelectionListener((SelectionListener)selectionListener);
    }

    private void initGuiEnvironmentEditor(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.envVariables");
        this.m_envTextArea = new Text(parent, 578);
        LayoutUtil.setMaxChar((Text)this.m_envTextArea, (int)4000);
        GridData textGridData = new GridData();
        textGridData.horizontalAlignment = 4;
        textGridData.horizontalSpan = 2;
        textGridData.grabExcessHorizontalSpace = false;
        textGridData.widthHint = 250;
        textGridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)LayoutUtil.getFontMetrics((Control)this.m_envTextArea), (int)2);
        this.m_envTextArea.setLayoutData((Object)textGridData);
    }

    private void initGuiJarChooser(Composite parent) {
        UIComponentHelper.createLabel((Composite)parent, (String)"AUTConfigComponent.jar");
        this.m_jarTextField = UIComponentHelper.createTextField((Composite)parent, (int)1);
        LayoutUtil.setMaxChar((Text)this.m_jarTextField, (int)4000);
        this.m_jarButton = new Button(UIComponentHelper.createLayoutComposite((Composite)parent), 8);
        this.m_jarButton.setText(Messages.AUTConfigComponentBrowse);
        this.m_jarButton.setLayoutData((Object)BUTTON_LAYOUT);
        this.m_jarButton.setEnabled(Utils.isLocalhost());
    }

    @Override
    protected void initState() {
        this.m_activationMethodCombo.setEnabled(true);
        this.m_autJreParamTextField.setEnabled(true);
        this.m_envTextArea.setEnabled(true);
        this.m_jarTextField.setEnabled(true);
        this.m_jarButton.setEnabled(true);
        this.checkLocalhostServer();
        RemoteFileBrowserBP.clearCache();
    }

    DialogStatusParameter modifyEnvFieldAction() {
        this.putConfigValue("ENVIRONMENT", this.m_envTextArea.getText());
        return null;
    }

    DialogStatusParameter modifyJreParamFieldAction() {
        this.putConfigValue("JRE_PARAMETER", this.m_autJreParamTextField.getText());
        return null;
    }

    DialogStatusParameter modifyAutParamFieldAction() {
        String params = this.m_autArgsTextField.getText();
        this.putConfigValue("AUT_ARGUMENTS", params);
        return null;
    }

    boolean handleActivationComboEvent() {
        this.putConfigValue("ACTIVATION_METHOD", IAUTConfigPO.ActivationMethod.getRCString((IAUTConfigPO.ActivationMethod)((IAUTConfigPO.ActivationMethod)this.m_activationMethodCombo.getSelectedObject())));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    DialogStatusParameter modifyJarFieldAction() {
        block25: {
            block26: {
                error = null;
                v0 = isEmpty = this.m_jarTextField.getText().length() == 0;
                if (!this.isValid((Widget)this.m_jarTextField, true) || isEmpty) break block26;
                if (!this.checkLocalhostServer()) break block25;
                filename = this.m_jarTextField.getText();
                file = new File(filename);
                workingDir = StringUtils.defaultString((String)this.getConfigValue("WORKING_DIR"));
                if (!file.isAbsolute() && workingDir.length() != 0) {
                    filename = String.valueOf(workingDir) + "/" + filename;
                    file = new File(filename);
                }
                jarFile = null;
                try {
                    if (!file.exists()) {
                        error = this.createWarningStatus(Messages.AUTConfigComponentFileNotFound);
                    } else {
                        jarFile = new JarFile(file);
                        jarManifest = jarFile.getManifest();
                        if (jarManifest == null) {
                            error = this.createErrorStatus(Messages.AUTConfigComponentNoManifest);
                        } else if (jarManifest.getMainAttributes().getValue("Main-Class") == null) {
                            error = this.createErrorStatus(Messages.AUTConfigComponentNoMainClass);
                        }
                    }
                }
                catch (ZipException v1) {
                    error = this.createErrorStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotJar, (Object)filename));
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e) {
                            JavaAutConfigComponent.log.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    break block25;
                }
                catch (IOException v2) {
                    try {
                        error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotFound, (Object)filename));
                        break block25;
                    }
                    catch (Throwable var8_12) {
                        throw var8_12;
                    }
                    finally {
                        if (jarFile != null) {
                            try {
                                jarFile.close();
                            }
                            catch (IOException e) {
                                JavaAutConfigComponent.log.error(e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                ** if (jarFile == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {
                        JavaAutConfigComponent.log.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block25;
                }
            }
            if (!isEmpty) {
                error = this.createErrorStatus(Messages.AUTConfigComponentWrongJAR);
            }
        }
        this.putConfigValue("JAR_FILE", this.m_jarTextField.getText());
        return error;
    }

    @Override
    protected void populateExpertArea(Map<String, String> data) {
        this.m_activationMethodCombo.setSelectedObject((Object)IAUTConfigPO.ActivationMethod.getEnum((String)data.get("ACTIVATION_METHOD")));
        String monitoringAgentId = data.get("MONITORING_AGENT_ID");
        if (StringUtils.isEmpty((String)monitoringAgentId)) {
            this.m_monitoringCombo.deselectAll();
        } else {
            this.m_monitoringCombo.setSelectedObject((Object)monitoringAgentId);
            if (this.m_monitoringCombo.getSelectedObject() == null) {
                ArrayList<String> values = new ArrayList<String>(this.m_monitoringCombo.getValues());
                ArrayList<String> displayValues = new ArrayList<String>(Arrays.asList(this.m_monitoringCombo.getItems()));
                values.add(0, monitoringAgentId);
                values.remove(null);
                displayValues.add(0, monitoringAgentId);
                displayValues.remove("");
                this.m_monitoringCombo.setItems(values, displayValues);
                this.m_monitoringCombo.setSelectedObject((Object)monitoringAgentId);
            }
        }
        if (!this.isDataNew(data)) {
            this.m_autJreParamTextField.setText(StringUtils.defaultString((String)data.get("JRE_PARAMETER")));
            this.m_envTextArea.setText(StringUtils.defaultString((String)data.get("ENVIRONMENT")));
        }
    }

    @Override
    protected void populateMonitoringArea(Map<String, String> data) {
        Composite composite = this.getMonitoringAreaComposite();
        Control[] ca = composite.getChildren();
        int i = 0;
        while (i < ca.length) {
            if (ca[i].getData("MONITORING_KEY") != null) {
                Button b;
                Text t;
                String value;
                if (ca[i] instanceof Text && (value = data.get(String.valueOf((t = (Text)ca[i]).getData("MONITORING_KEY")))) != null && !value.equals("")) {
                    t.setText(value);
                }
                if (ca[i] instanceof Button && (value = data.get(String.valueOf((b = (Button)ca[i]).getData("MONITORING_KEY")))) != null) {
                    b.setSelection(Boolean.valueOf(value).booleanValue());
                }
            }
            ++i;
        }
    }

    @Override
    protected void populateAdvancedArea(Map<String, String> data) {
        this.m_autArgsTextField.setText(StringUtils.defaultString((String)data.get("AUT_ARGUMENTS")));
        String jreDirectory = StringUtils.defaultString((String)this.getConfigValue("JRE_BINARY"));
        if (this.isConfigNew()) {
            jreDirectory = this.getDefaultJreBin();
            this.modifyJREFieldAction();
        }
        this.m_autJreTextField.setText(jreDirectory);
    }

    private String getDefaultJreBin() {
        File jreBin = new File(DEFAULT_WIN_JRE);
        if (jreBin.exists()) {
            return DEFAULT_WIN_JRE;
        }
        return "";
    }

    @Override
    protected void populateBasicArea(Map<String, String> data) {
        super.populateBasicArea(data);
        if (!this.isDataNew(data)) {
            this.getAUTAgentHostNameCombo().select(this.getAUTAgentHostNameCombo().indexOf(StringUtils.defaultString((String)data.get("SERVER"))));
            this.m_jarTextField.setText(StringUtils.defaultString((String)data.get("JAR_FILE")));
            this.m_execTextField.setText(StringUtils.defaultString((String)data.get("EXECUTABLE")));
        }
    }

    DialogStatusParameter modifyJREFieldAction() {
        DialogStatusParameter error = null;
        this.putConfigValue("JRE_BINARY", this.m_autJreTextField.getText());
        if (!this.isValid((Widget)this.m_autJreTextField, true) && this.m_autJreTextField.getText().length() != 0) {
            error = this.createErrorStatus(Messages.AUTConfigComponentWrongJRE);
        }
        return error;
    }

    private void setWorkingDirToExecFilePath(String directory) {
        if ((StringUtils.isEmpty((String)this.getAutWorkingDirField().getText()) || this.isBasicMode()) && JavaAutConfigComponent.isFilePathAbsolute(directory) && this.m_isExecFieldValid) {
            File wd = new File(directory);
            if ((wd = wd.getParentFile()) != null) {
                String execPath = wd.getAbsolutePath();
                this.getAutWorkingDirField().setText(execPath);
                this.putConfigValue("WORKING_DIR", execPath);
            }
        }
    }

    private static boolean isFilePathAbsolute(String filename) {
        File execFile = new File(filename);
        return execFile.isAbsolute();
    }

    void browseLocal(String[] extensionFilters, String title, Text textField, String configVarKey) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 81920);
        if (extensionFilters != null) {
            fileDialog.setFilterExtensions(extensionFilters);
        }
        fileDialog.setText(title);
        String filterPath = Utils.getLastDirPath();
        File path = new File(textField.getText());
        if (!path.isAbsolute()) {
            path = new File(this.getConfigValue("WORKING_DIR"), textField.getText());
        }
        if (path.exists()) {
            try {
                filterPath = path.isDirectory() ? path.getCanonicalPath() : new File(path.getParent()).getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        fileDialog.setFilterPath(filterPath);
        String directory = fileDialog.open();
        if (directory != null) {
            textField.setText(directory);
            Utils.storeLastDirPath(fileDialog.getFilterPath());
            this.putConfigValue(configVarKey, directory);
        }
    }

    void handleExecButtonEvent(FileDialog fileDialog) {
        fileDialog.setText(Messages.AUTConfigComponentSelectExecutable);
        String filterPath = Utils.getLastDirPath();
        File path = new File(this.getConfigValue("EXECUTABLE"));
        if (!path.isAbsolute()) {
            path = new File(this.getConfigValue("WORKING_DIR"), this.getConfigValue("EXECUTABLE"));
        }
        if (path.exists()) {
            try {
                filterPath = path.isDirectory() ? path.getCanonicalPath() : new File(path.getParent()).getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        fileDialog.setFilterPath(filterPath);
        String directory = fileDialog.open();
        if (directory != null) {
            this.m_execTextField.setText(directory);
            Utils.storeLastDirPath(fileDialog.getFilterPath());
            this.putConfigValue("EXECUTABLE", directory);
            executablePath = directory;
            this.setWorkingDirToExecFilePath(executablePath);
        }
    }

    private void handleExecButtonEventForRemote() {
        if (this.remoteBrowse(false, "EXECUTABLE", this.m_execTextField, Messages.AUTConfigComponentSelectExecutable)) {
            this.setWorkingDirToExecFilePath(executablePath);
        }
    }

    DialogStatusParameter modifyExecTextField() {
        String filename;
        DialogStatusParameter error;
        block10: {
            error = null;
            this.m_isExecFieldValid = true;
            isExecFieldEmpty = this.m_execTextField.getText().length() == 0;
            filename = this.m_execTextField.getText();
            if (this.isValid((Widget)this.m_execTextField, true) && !isExecFieldEmpty) {
                if (this.checkLocalhostServer()) {
                    String workingDirString;
                    File file = new File(filename);
                    if (!file.isAbsolute() && (workingDirString = this.getConfigValue("WORKING_DIR")) != null && workingDirString.length() != 0) {
                        filename = String.valueOf(workingDirString) + "/" + filename;
                        file = new File(filename);
                    }
                    try {
                        if (!file.isFile()) {
                            error = this.createWarningStatus(Messages.AUTConfigComponentFileNotFound);
                            break block10;
                        }
                        new JarFile(file);
                        error = this.createErrorStatus(NLS.bind((String)Messages.AUTConfigComponentFileJar, (Object)file.getCanonicalPath()));
                    }
                    catch (ZipException zipException) {
                    }
                    catch (IOException iOException) {
                        error = this.createWarningStatus(NLS.bind((String)Messages.AUTConfigComponentFileNotFound, (Object)filename));
                    }
                }
            } else if (!isExecFieldEmpty) {
                error = this.createErrorStatus(Messages.AUTConfigComponentWrongExecutable);
            }
        }
        if (error != null) {
            this.m_isExecFieldValid = false;
        }
        this.putConfigValue("EXECUTABLE", this.m_execTextField.getText());
        executablePath = filename;
        return error;
    }

    @Override
    protected boolean checkLocalhostServer() {
        boolean enable = super.checkLocalhostServer();
        boolean browseEnabled = enable || this.isRemoteRequest();
        this.m_jarButton.setEnabled(browseEnabled && this.m_jarTextField.getEnabled());
        this.m_execButton.setEnabled(browseEnabled && this.m_execButton.isEnabled());
        this.m_autJreButton.setEnabled(browseEnabled && this.m_autJreButton.isEnabled());
        return enable;
    }

    @Override
    protected boolean isJavaAut() {
        return true;
    }

    protected void handleMonitoringComboEvent() {
        if (this.m_monitoringCombo.getSelectedObject() != null) {
            this.putConfigValue("MONITORING_AGENT_ID", ((String)this.m_monitoringCombo.getSelectedObject()).toString());
            this.cleanComposite(this.getMonitoringAreaComposite());
            this.createActualMonitoringArea(this.getMonitoringAreaComposite());
        } else {
            this.cleanComposite(this.getMonitoringAreaComposite());
            this.putConfigValue("MONITORING_AGENT_ID", "");
        }
        String autId = this.getConfigValue("AUT_ID");
        this.showMonitoringInfoDialog(autId);
    }

    @Override
    protected void createAdvancedArea(Composite advancedAreaComposite) {
        this.initGuiJarChooser(advancedAreaComposite);
        this.createAutDirectoryEditor(advancedAreaComposite);
        ControlDecorator.decorateInfo((Control)UIComponentHelper.createLabel((Composite)advancedAreaComposite, (String)"AUTConfigComponent.autArguments"), "ControlDecorator.AUTArguments", false);
        this.m_autArgsTextField = UIComponentHelper.createTextField((Composite)advancedAreaComposite, (int)2);
        UIComponentHelper.createLabel((Composite)advancedAreaComposite, (String)"AUTConfigComponent.jre");
        this.m_autJreTextField = UIComponentHelper.createTextField((Composite)advancedAreaComposite, (int)1);
        LayoutUtil.setMaxChar((Text)this.m_autJreTextField, (int)4000);
        GridData comboGrid = new GridData(4, 2, true, false, 1, 1);
        LayoutUtil.addToolTipAndMaxWidth((GridData)comboGrid, (Control)this.m_autJreTextField);
        this.m_autJreTextField.setLayoutData((Object)comboGrid);
        ((GridData)this.m_autJreTextField.getLayoutData()).widthHint = 250;
        this.m_autJreComposite = UIComponentHelper.createLayoutComposite((Composite)advancedAreaComposite);
        this.m_autJreButton = new Button(this.m_autJreComposite, 8);
        this.m_autJreButton.setText(Messages.AUTConfigComponentBrowse);
        this.m_autJreButton.setLayoutData((Object)BUTTON_LAYOUT);
        super.createAdvancedArea(advancedAreaComposite);
    }

    @Override
    protected void createExpertArea(Composite expertAreaComposite) {
        ControlDecorator.decorateInfo((Control)UIComponentHelper.createLabel((Composite)expertAreaComposite, (String)"AUTConfigComponent.jreArguments"), "ControlDecorator.JREArguments", false);
        this.m_autJreParamTextField = UIComponentHelper.createTextField((Composite)expertAreaComposite, (int)2);
        this.initGuiEnvironmentEditor(expertAreaComposite);
        UIComponentHelper.createLabel((Composite)expertAreaComposite, (String)"AUTConfigComponent.activationMethod");
        this.m_activationMethodCombo = UIComponentHelper.createEnumCombo((Composite)expertAreaComposite, (int)2, (String)"AUTConfigComponent.ActivationMethod", IAUTConfigPO.ActivationMethod.class);
        UIComponentHelper.createSeparator((Composite)expertAreaComposite, (int)3);
        ControlDecorator.decorateInfo((Control)UIComponentHelper.createLabel((Composite)expertAreaComposite, (String)"AUTConfigComponent.labelMonitoring"), "AUTConfigComponent.labelMonitoring.helpText", false);
        this.m_monitoringCombo = UIComponentHelper.createCombo((Composite)expertAreaComposite, (int)2, (List)MonitoringRegistry.getAllRegisteredMonitoringIds(), (List)MonitoringRegistry.getAllRegisteredMonitoringNames(), (boolean)true);
        super.createExpertArea(expertAreaComposite);
    }

    @Override
    protected void openServerPrefPage() {
        boolean checkListeners;
        super.openServerPrefPage();
        boolean bl = checkListeners = this.m_selectionListener != null;
        if (checkListeners) {
            this.deinstallListeners();
        }
        if (checkListeners) {
            this.installListeners();
        }
    }

    protected List<Control> getJavaRelatedFields() {
        ArrayList<Control> javaFields = new ArrayList<Control>();
        javaFields.add((Control)this.m_autJreButton);
        javaFields.add((Control)this.m_autJreTextField);
        javaFields.add((Control)this.m_autJreComposite);
        javaFields.add((Control)this.m_autJreParamTextField);
        javaFields.add((Control)this.m_jarButton);
        javaFields.add((Control)this.m_jarTextField);
        return javaFields;
    }

    private WidgetSelectionListener getSelectionListener() {
        if (this.m_selectionListener == null) {
            this.m_selectionListener = new WidgetSelectionListener();
        }
        return this.m_selectionListener;
    }

    private WidgetModifyListener getModifyListener() {
        if (this.m_modifyListener == null) {
            this.m_modifyListener = new WidgetModifyListener();
        }
        return this.m_modifyListener;
    }

    private WidgetFocusListener getFocusListener() {
        if (this.m_focusListener == null) {
            this.m_focusListener = new WidgetFocusListener();
        }
        return this.m_focusListener;
    }

    @Override
    protected void checkAll(List<DialogStatusParameter> paramList) {
        super.checkAll(paramList);
        this.addError(paramList, this.modifyAutConfigFieldAction());
        this.addError(paramList, this.modifyAutParamFieldAction());
        this.addError(paramList, this.modifyEnvFieldAction());
        this.addError(paramList, this.modifyJarFieldAction());
        this.addError(paramList, this.modifyExecTextField());
        this.addError(paramList, this.modifyJREFieldAction());
        this.addError(paramList, this.modifyJreParamFieldAction());
        this.addError(paramList, this.modifyServerComboAction());
    }

    public void dispose() {
        RemoteFileBrowserBP.clearCache();
        super.dispose();
    }

    @Override
    protected void createMonitoringArea(Composite monitoringComposite) {
        super.createActualMonitoringArea(monitoringComposite);
        this.setCompositeVisible(monitoringComposite, true);
    }

    private class WidgetFocusListener
    implements FocusListener {
        private WidgetFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source.equals(JavaAutConfigComponent.this.m_execTextField)) {
                JavaAutConfigComponent.this.setWorkingDirToExecFilePath(executablePath);
            }
        }
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (source.equals(JavaAutConfigComponent.this.getAUTAgentHostNameCombo())) {
                boolean checkListeners;
                JavaAutConfigComponent.this.checkLocalhostServer();
                boolean bl = checkListeners = JavaAutConfigComponent.this.m_selectionListener != null;
                if (checkListeners) {
                    JavaAutConfigComponent.this.deinstallListeners();
                }
                if (checkListeners) {
                    JavaAutConfigComponent.this.installListeners();
                }
            }
            JavaAutConfigComponent.this.checkAll();
        }
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source.equals(JavaAutConfigComponent.this.m_autJreButton)) {
                if (JavaAutConfigComponent.this.isRemoteRequest()) {
                    JavaAutConfigComponent.this.remoteBrowse(false, "JRE_BINARY", JavaAutConfigComponent.this.m_autJreTextField, Messages.AUTConfigComponentSelectJRE);
                } else {
                    JavaAutConfigComponent.this.browseLocal(null, Messages.AUTConfigComponentSelectJRE, JavaAutConfigComponent.this.m_autJreTextField, "JRE_BINARY");
                }
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_jarButton)) {
                if (JavaAutConfigComponent.this.isRemoteRequest()) {
                    JavaAutConfigComponent.this.remoteBrowse(false, "JAR_FILE", JavaAutConfigComponent.this.m_jarTextField, Messages.AUTConfigComponentSelectJAR);
                } else {
                    JavaAutConfigComponent.this.browseLocal(new String[]{"*.jar"}, Messages.AUTConfigComponentSelectJAR, JavaAutConfigComponent.this.m_jarTextField, "JAR_FILE");
                }
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_execButton)) {
                if (JavaAutConfigComponent.this.isRemoteRequest()) {
                    JavaAutConfigComponent.this.handleExecButtonEventForRemote();
                } else {
                    JavaAutConfigComponent.this.handleExecButtonEvent(new FileDialog(JavaAutConfigComponent.this.getShell(), 81920));
                }
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_activationMethodCombo)) {
                JavaAutConfigComponent.this.handleActivationComboEvent();
                return;
            }
            if (source.equals(JavaAutConfigComponent.this.m_monitoringCombo)) {
                JavaAutConfigComponent.this.handleMonitoringComboEvent();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "(" + source + ")" + "."));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object source = e.getSource();
            new DirectoryDialog(JavaAutConfigComponent.this.getShell(), 65536);
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "(" + source + ")" + "."));
        }
    }
}

