/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jubula.client.archive.JsonStorage;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesDecorator;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.ProjectComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ImportFileBP;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.wizards.pages.ProjectSettingWizardPage;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.version.IVersion;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectWizard
extends Wizard
implements INewWizard {
    private static final String PROJECT_SETTING_WP = "org.eclipse.jubula.client.ui.rcp.wizards.pages.ProjectSettingWizardPage";
    private static final String LIBRARY_PREFIX = "unbound_modules_";
    private static Logger log = LoggerFactory.getLogger(ProjectWizard.class);
    private IAUTMainPO m_autMain;
    private IAUTConfigPO m_autConfig;
    private ProjectSettingWizardPage m_projectSettingWizardPage;

    public ProjectSettingWizardPage getProjectSettingWizardPage() {
        return this.m_projectSettingWizardPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.ProjectWizardNewProjectWizard);
        this.setDefaultPageImageDescriptor(IconConstants.PROJECT_WIZARD_IMAGE_DESCRIPTOR);
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(true);
    }

    public boolean performFinish() {
        final String name = this.m_projectSettingWizardPage.getNewProjectName();
        if (ProjectPM.doesProjectNameExist((String)name)) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_PROJECTNAME_ALREADY_EXISTS, (Object[])new Object[]{name}, null);
            return false;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    monitor.beginTask(NLS.bind((String)Messages.ProjectWizardCreatingProject, (Object)name), -1);
                    try {
                        try {
                            boolean needTemplate = ProjectWizard.this.m_projectSettingWizardPage.needProjectTamplet();
                            String projectToolkit = ProjectWizard.this.m_projectSettingWizardPage.getProjectToolkit();
                            ProjectWizard.this.createNewProject(name, projectToolkit, needTemplate, monitor);
                        }
                        catch (ToolkitPluginException e) {
                            Plugin.getDefault().writeStatus((IStatus)new Status(4, "org.eclipse.jubula.client.core", e.getMessage()));
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
            log.error(ite.getLocalizedMessage(), ite.getCause());
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    public boolean performCancel() {
        Plugin.stopLongRunning();
        ProjectNameBP.getInstance().clearCache();
        return true;
    }

    public void addPages() {
        Plugin.startLongRunning();
        this.m_autMain = PoMaker.createAUTMainPO((String)"");
        this.m_autConfig = PoMaker.createAUTConfigPO();
        this.m_autMain.addAutConfigToSet(this.m_autConfig);
        this.m_projectSettingWizardPage = new ProjectSettingWizardPage(PROJECT_SETTING_WP, this.m_autMain, this.m_autConfig);
        this.m_projectSettingWizardPage.setTitle(Messages.ProjectWizardProjectSettings);
        this.m_projectSettingWizardPage.setDescription(Messages.ProjectWizardNewProject);
        this.addPage((IWizardPage)this.m_projectSettingWizardPage);
        Plugin.stopLongRunning();
    }

    private void createNewProject(String newProjectName, String projectToolkit, boolean needTemplate, IProgressMonitor monitor) throws InterruptedException, ToolkitPluginException {
        Plugin.closeAllOpenedJubulaEditors(false);
        ParamNameBPDecorator paramNameMapper = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
        ComponentNamesDecorator compNameCache = new ComponentNamesDecorator(null);
        IProjectPO project = null;
        if (needTemplate) {
            try {
                URL templateUrl = ImportFileBP.getInstance().getProjectTemplateUrl();
                project = new JsonStorage().readProject(templateUrl, paramNameMapper, (IWritableComponentNameCache)compNameCache, true, true, monitor, (IProgressConsole)Plugin.getDefault());
            }
            catch (PMReadException | JBVersionException e) {
                e.printStackTrace();
            }
        }
        if (project == null) {
            project = NodeMaker.createProjectPO((String)newProjectName, (Integer)IVersion.JB_CLIENT_METADATA_VERSION);
        }
        project.setToolkit(projectToolkit);
        if (this.m_autMain.getName() != null && !this.m_autMain.getName().isEmpty() && this.m_autMain.getToolkit() != null) {
            project.addAUTMain(this.m_autMain);
            for (ITestSuitePO ts : TestSuiteBP.getListOfTestSuites((IProjectPO)project)) {
                ts.setAut(this.m_autMain);
            }
        }
        if (this.m_autConfig.getName() == null || this.m_autConfig.getName().isEmpty()) {
            this.m_autMain.removeAutConfig(this.m_autConfig);
        }
        this.addUnboundModules(project);
        ArrayList<ParamNameBPDecorator> mapperList = new ArrayList<ParamNameBPDecorator>();
        ArrayList<ProjectComponentNameMapper> compNameMapperList = new ArrayList<ProjectComponentNameMapper>();
        mapperList.add(paramNameMapper);
        compNameMapperList.add(new ProjectComponentNameMapper((IWritableComponentNameCache)compNameCache, project));
        try {
            GeneralStorage.getInstance().reset();
            ProjectPM.attachProjectToROSession((IProjectPO)project, (String)newProjectName, mapperList, compNameMapperList, (IProgressMonitor)monitor);
        }
        catch (PMSaveException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession((PMException)((Object)new PMSaveException(e.getMessage(), MessageIDs.E_CREATE_NEW_PROJECT_FAILED)));
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
        catch (InterruptedException ie) {
            throw ie;
        }
    }

    private void addUnboundModules(IProjectPO newProject) {
        ToolkitDescriptor desc = ComponentBuilder.getInstance().getCompSystem().getToolkitDescriptor(newProject.getToolkit());
        while (desc != null) {
            try {
                String moduleName = LIBRARY_PREFIX + StringUtils.lowerCase((String)desc.getName());
                IProjectPO ubmProject = ProjectPM.loadLatestVersionOfProjectByName((String)moduleName);
                if (ubmProject != null) {
                    IReusedProjectPO[] reusedProj = new IReusedProjectPO[newProject.getUsedProjects().size()];
                    newProject.getUsedProjects().toArray(reusedProj);
                    int i = 0;
                    while (i < reusedProj.length) {
                        IReusedProjectPO oldReusedProject = reusedProj[i];
                        if (oldReusedProject != null && oldReusedProject.getName().equals(ubmProject.getName()) && oldReusedProject.getProjectVersion().compareTo(ubmProject.getProjectVersion()) <= 0) {
                            newProject.removeUsedProject(oldReusedProject);
                        }
                        ++i;
                    }
                    newProject.addUsedProject(PoMaker.createReusedProjectPO((IProjectPO)ubmProject));
                } else if (log.isInfoEnabled()) {
                    log.info(String.valueOf(Messages.Project) + " " + "'" + moduleName + "'" + Messages.DoesNotExist + ".");
                }
            }
            catch (JBException e) {
                log.error((Object)((Object)e) + ":" + " " + e.getMessage());
            }
            desc = ComponentBuilder.getInstance().getCompSystem().getToolkitDescriptor(desc.getIncludes());
        }
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage().isPageComplete();
    }

    public IAUTMainPO getAutMain() {
        return this.m_autMain;
    }
}

