/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.api.gen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.CommonGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.ComponentGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.utils.GenerateUtil;
import org.eclipse.jubula.toolkit.api.gen.internal.utils.NameLoader;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;

public class ActionHandlerGenerator {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "/*******************************************************************************" + this.NL + " * Copyright (c) 2016 BREDEX GmbH." + this.NL + " * All rights reserved. This program and the accompanying materials" + this.NL + " * are made available under the terms of the Eclipse Public License v1.0" + this.NL + " * which accompanies this distribution, and is available at" + this.NL + " * http://www.eclipse.org/legal/epl-v10.html" + this.NL + " *" + this.NL + " * Contributors:" + this.NL + " *     BREDEX GmbH - initial API and implementation and/or initial documentation" + this.NL + " *******************************************************************************/" + this.NL + "package ";
    protected final String TEXT_2 = ".handler;" + this.NL + this.NL + "import org.eclipse.jdt.annotation.NonNull;" + this.NL + "import org.eclipse.jdt.annotation.Nullable;" + this.NL + "import org.eclipse.jubula.client.AUTRegistry;" + this.NL + "import org.eclipse.jubula.client.Result;" + this.NL + "import org.eclipse.jubula.communication.CAP;" + this.NL + "import org.eclipse.jubula.toolkit.CapBuilder;" + this.NL + "import org.eclipse.jubula.toolkit.annotations.Beta;" + this.NL + "import org.eclipse.jubula.toolkit.enums.ValueSets.*;" + this.NL + "import javax.annotation.Generated;" + this.NL;
    protected final String TEXT_3 = String.valueOf(this.NL) + "import org.apache.commons.lang.Validate;" + this.NL + "import org.apache.commons.lang.StringUtils;" + this.NL + this.NL + "import org.eclipse.jubula.communication.internal.message.MessageCap;" + this.NL + "import org.eclipse.jubula.communication.internal.message.MessageParam;" + this.NL + "import org.eclipse.jubula.tools.ComponentIdentifier;" + this.NL + "import org.eclipse.jubula.tools.internal.constants.TestDataConstants;" + this.NL + "import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;" + this.NL + "import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;" + this.NL + "import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;";
    protected final String TEXT_4 = String.valueOf(this.NL) + this.NL + "/**" + this.NL + " * An ActionHandler directly executes the remote controlling commands for a" + this.NL + " * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}" + this.NL + " *" + this.NL + " * ";
    protected final String TEXT_5 = "Interface";
    protected final String TEXT_6 = "Class";
    protected final String TEXT_7 = " representing the ";
    protected final String TEXT_8 = "{@link ";
    protected final String TEXT_9 = "}";
    protected final String TEXT_10 = "ActionHandler";
    protected final String TEXT_11 = " component from the ";
    protected final String TEXT_12 = " toolkit.";
    protected final String TEXT_13 = String.valueOf(this.NL) + " * @noextend This interface is not intended to be extended by clients." + this.NL + " * @noimplement This interface is not intended to be implemented by clients.";
    protected final String TEXT_14 = String.valueOf(this.NL) + " * ";
    protected final String TEXT_15 = String.valueOf(this.NL) + " */";
    protected final String TEXT_16 = String.valueOf(this.NL) + "@RealizedType(realizedType=\"";
    protected final String TEXT_17 = "\")";
    protected final String TEXT_18 = String.valueOf(this.NL) + "@TesterClass(testerClass=\"";
    protected final String TEXT_19 = "\")";
    protected final String TEXT_20 = String.valueOf(this.NL) + "@Generated(value = \"";
    protected final String TEXT_21 = "\", " + this.NL + "           date =  \"";
    protected final String TEXT_22 = "\")" + this.NL + "@Beta" + this.NL + "public ";
    protected final String TEXT_23 = "interface";
    protected final String TEXT_24 = "class";
    protected final String TEXT_25 = " ";
    protected final String TEXT_26 = "ActionHandler";
    protected final String TEXT_27 = " extends ";
    protected final String TEXT_28 = "ActionHandler";
    protected final String TEXT_29 = " implements ";
    protected final String TEXT_30 = "ActionHandler";
    protected final String TEXT_31 = " {";
    protected final String TEXT_32 = String.valueOf(this.NL) + "            public ";
    protected final String TEXT_33 = "ActionHandler() {" + this.NL + "                super();" + this.NL + "            }";
    protected final String TEXT_34 = String.valueOf(this.NL) + "            public ";
    protected final String TEXT_35 = "ActionHandler(@NonNull ComponentIdentifier componentIdentifier) {" + this.NL + "                super(componentIdentifier);" + this.NL + "            }";
    protected final String TEXT_36 = String.valueOf(this.NL) + "            public ";
    protected final String TEXT_37 = "ActionHandler() {" + this.NL + "                super();" + this.NL + "            }";
    protected final String TEXT_38 = String.valueOf(this.NL) + "            @NonNull protected IComponentIdentifier m_componentIdentifier;" + this.NL + "            public ";
    protected final String TEXT_39 = "ActionHandler(@NonNull ComponentIdentifier componentIdentifier) {" + this.NL + "                super();" + this.NL + "                Validate.isTrue(componentIdentifier instanceof IComponentIdentifier);" + this.NL + "                m_componentIdentifier = (IComponentIdentifier) componentIdentifier;" + this.NL + "            }";
    protected final String TEXT_40 = String.valueOf(this.NL) + "    ";
    protected final String TEXT_41 = String.valueOf(this.NL) + "    protected IComponentIdentifier getPseudoComponentIdentifier() {";
    protected final String TEXT_42 = String.valueOf(this.NL) + "        org.eclipse.jubula.tools.internal.objects.ComponentIdentifier pseudoIdentifier =" + this.NL + "            new org.eclipse.jubula.tools.internal.objects.ComponentIdentifier();" + this.NL + "        pseudoIdentifier.setComponentClassName(\"";
    protected final String TEXT_43 = "\"); //$NON-NLS-1$" + this.NL + "        return pseudoIdentifier;";
    protected final String TEXT_44 = String.valueOf(this.NL) + "        return null;";
    protected final String TEXT_45 = String.valueOf(this.NL) + "    }";
    protected final String TEXT_46 = String.valueOf(this.NL) + "    ";
    protected final String TEXT_47 = String.valueOf(this.NL) + "        /**" + this.NL + "         * ";
    protected final String TEXT_48 = String.valueOf(this.NL) + "         ";
    protected final String TEXT_49 = "* @param ";
    protected final String TEXT_50 = " " + this.NL + "         *        ";
    protected final String TEXT_51 = String.valueOf(this.NL) + "         ";
    protected final String TEXT_52 = "* ";
    protected final String TEXT_53 = String.valueOf(this.NL) + "         */";
    protected final String TEXT_54 = "@Deprecated";
    protected final String TEXT_55 = String.valueOf(this.NL) + "        public void ";
    protected final String TEXT_56 = "(";
    protected final String TEXT_57 = String.valueOf(this.NL) + "            @Nullable ";
    protected final String TEXT_58 = "[]";
    protected final String TEXT_59 = " ";
    protected final String TEXT_60 = ",";
    protected final String TEXT_61 = String.valueOf(this.NL) + "        ) ";
    protected final String TEXT_62 = ";";
    protected final String TEXT_63 = " {";
    protected final String TEXT_64 = String.valueOf(this.NL) + "            if (";
    protected final String TEXT_65 = " == null) return;";
    protected final String TEXT_66 = String.valueOf(this.NL) + "            ";
    protected final String TEXT_67 = String.valueOf(this.NL) + "            AUTRegistry.INSTANCE.get().execute(" + this.NL + "                new CapBuilder(\"";
    protected final String TEXT_68 = "\")" + this.NL + "                            .setDefaultMapping(";
    protected final String TEXT_69 = ")";
    protected final String TEXT_70 = String.valueOf(this.NL) + "                            .setComponentIdentifier(m_componentIdentifier)";
    protected final String TEXT_71 = String.valueOf(this.NL) + "                            .setComponentIdentifier(getPseudoComponentIdentifier())";
    protected final String TEXT_72 = String.valueOf(this.NL) + "                            .add";
    protected final String TEXT_73 = "Optional";
    protected final String TEXT_74 = "Parameter(";
    protected final String TEXT_75 = ".rcIntValue())";
    protected final String TEXT_76 = String.valueOf(this.NL) + "                            .add";
    protected final String TEXT_77 = "Optional";
    protected final String TEXT_78 = "Parameter(";
    protected final String TEXT_79 = ".rcValue())";
    protected final String TEXT_80 = String.valueOf(this.NL) + "                            .add";
    protected final String TEXT_81 = "Optional";
    protected final String TEXT_82 = "Parameter(StringUtils.join(";
    protected final String TEXT_83 = ", TestDataConstants.COMBI_VALUE_SEPARATOR))";
    protected final String TEXT_84 = String.valueOf(this.NL) + "                            .add";
    protected final String TEXT_85 = "Optional";
    protected final String TEXT_86 = "Parameter(";
    protected final String TEXT_87 = ")";
    protected final String TEXT_88 = String.valueOf(this.NL) + "                            .build(), null);" + this.NL + "        }";
    protected final String TEXT_89 = String.valueOf(this.NL) + "        ";
    protected final String TEXT_90 = String.valueOf(this.NL) + "}";
    protected final String TEXT_91 = " ";

    public static synchronized ActionHandlerGenerator create(String lineSeparator) {
        nl = lineSeparator;
        ActionHandlerGenerator result = new ActionHandlerGenerator();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        CommonGenInfo genInfo = (CommonGenInfo)argument;
        Object specInfo = genInfo.getSpecificInformation();
        String fqnGeneratorClassName = this.getClass().getName();
        if (specInfo instanceof ComponentGenInfo) {
            ComponentGenInfo compGenInfo = (ComponentGenInfo)specInfo;
            String toolkitName = genInfo.getToolkitPackageName();
            String className = genInfo.getClassName();
            Component component = compGenInfo.getComponent();
            Boolean genInterface = compGenInfo.generatesInterface();
            Boolean hasDefaultMapping = compGenInfo.hasDefaultMapping();
            Map<String, String> compNameMap = compGenInfo.getCompNameMap();
            String packageName = null;
            if (genInterface.booleanValue()) {
                packageName = compGenInfo.getInterfacePackageName();
                compNameMap.put("interfacePackageName", packageName);
                compNameMap.put("componentTypeName", className);
                compNameMap.put("hasDefaultMapping", hasDefaultMapping.toString());
                CommonGenInfo faketory = new CommonGenInfo(component.getToolkitDesriptor(), false);
                compNameMap.put("factoryName", faketory.getFqClassName());
            } else {
                packageName = genInfo.getClassPackageName();
                compNameMap.put("implClassPackageName", packageName);
            }
            String implementedTypeFqn = String.valueOf(compGenInfo.getInterfacePackageName()) + ".handler." + compGenInfo.getClassName();
            NameLoader nameLoader = NameLoader.getInstance();
            ArrayList actions = new ArrayList(component.getActions());
            List realized = component.getRealized();
            Component realizedComponent = realized.size() > 0 ? (Component)realized.get(0) : null;
            Boolean hasRealizedType = realizedComponent != null;
            String realizedType = null;
            CommonGenInfo superInfo = null;
            List superActions = null;
            String realizedTypeFqn = null;
            if (hasRealizedType.booleanValue()) {
                realizedType = realizedComponent.getType();
                superInfo = new CommonGenInfo(realizedComponent);
                superActions = realizedComponent.getActions();
                if (genInterface.booleanValue()) {
                    ComponentGenInfo superCompGenInfo = new ComponentGenInfo(realizedComponent, true, superInfo.getToolkitPackageName(), superInfo.getClassName(), null);
                    realizedTypeFqn = String.valueOf(superCompGenInfo.getInterfacePackageName()) + ".handler." + superCompGenInfo.getClassName();
                    compNameMap.put("superComp", realizedComponent.getType());
                } else {
                    realizedTypeFqn = String.valueOf(superInfo.getClassPackageName()) + ".handler." + superInfo.getClassName();
                }
            }
            String testerClass = "";
            String componentClassName = "";
            Boolean hasComponentClass = false;
            if (component instanceof ConcreteComponent) {
                ConcreteComponent concreteComponent = (ConcreteComponent)component;
                testerClass = concreteComponent.getTesterClass();
                componentClassName = concreteComponent.getComponentClass().getName();
                if (!componentClassName.isEmpty()) {
                    hasComponentClass = true;
                }
            }
            String sinceC = "@since ";
            String sinceCVersion = component.getSince();
            sinceC = sinceCVersion != null && !sinceCVersion.isEmpty() ? String.valueOf(sinceC) + sinceCVersion : String.valueOf(sinceC) + "4.0";
            stringBuffer.append(this.TEXT_1);
            stringBuffer.append(packageName);
            stringBuffer.append(this.TEXT_2);
            if (!genInterface.booleanValue()) {
                stringBuffer.append(this.TEXT_3);
            }
            stringBuffer.append(this.TEXT_4);
            if (genInterface.booleanValue()) {
                stringBuffer.append("Interface");
            } else {
                stringBuffer.append("Class");
            }
            stringBuffer.append(" representing the ");
            if (!hasDefaultMapping.booleanValue() && hasComponentClass.booleanValue()) {
                stringBuffer.append("{@link ");
                stringBuffer.append(componentClassName);
                stringBuffer.append("}");
            } else {
                stringBuffer.append(className);
                stringBuffer.append("ActionHandler");
            }
            stringBuffer.append(" component from the ");
            stringBuffer.append(toolkitName);
            stringBuffer.append(" toolkit.");
            if (genInterface.booleanValue()) {
                stringBuffer.append(this.TEXT_13);
            }
            stringBuffer.append(this.TEXT_14);
            stringBuffer.append(sinceC);
            stringBuffer.append(this.TEXT_15);
            if (!genInterface.booleanValue()) {
                if (realizedType != null && !realizedType.isEmpty()) {
                    stringBuffer.append(this.TEXT_16);
                    stringBuffer.append(realizedType);
                    stringBuffer.append("\")");
                }
                if (testerClass != null && !testerClass.isEmpty()) {
                    stringBuffer.append(this.TEXT_18);
                    stringBuffer.append(testerClass);
                    stringBuffer.append("\")");
                }
            }
            stringBuffer.append(this.TEXT_20);
            stringBuffer.append(fqnGeneratorClassName);
            stringBuffer.append(this.TEXT_21);
            stringBuffer.append(GenerateUtil.getISO8601Timestamp());
            stringBuffer.append(this.TEXT_22);
            if (genInterface.booleanValue()) {
                stringBuffer.append("interface");
            } else {
                stringBuffer.append("class");
            }
            stringBuffer.append(" ");
            stringBuffer.append(className);
            stringBuffer.append("ActionHandler");
            if (hasRealizedType.booleanValue()) {
                stringBuffer.append(" extends ");
                stringBuffer.append(realizedTypeFqn);
                stringBuffer.append("ActionHandler");
            }
            if (!genInterface.booleanValue()) {
                stringBuffer.append(" implements ");
                stringBuffer.append(implementedTypeFqn);
                stringBuffer.append("ActionHandler");
            }
            stringBuffer.append(" {");
            if (!genInterface.booleanValue()) {
                if (hasRealizedType.booleanValue()) {
                    if (hasDefaultMapping.booleanValue()) {
                        stringBuffer.append(this.TEXT_32);
                        stringBuffer.append(className);
                        stringBuffer.append(this.TEXT_33);
                    } else {
                        stringBuffer.append(this.TEXT_34);
                        stringBuffer.append(className);
                        stringBuffer.append(this.TEXT_35);
                    }
                } else if (hasDefaultMapping.booleanValue()) {
                    stringBuffer.append(this.TEXT_36);
                    stringBuffer.append(className);
                    stringBuffer.append(this.TEXT_37);
                } else {
                    stringBuffer.append(this.TEXT_38);
                    stringBuffer.append(className);
                    stringBuffer.append(this.TEXT_39);
                }
            }
            stringBuffer.append(this.TEXT_40);
            if (!genInterface.booleanValue() && hasDefaultMapping.booleanValue()) {
                stringBuffer.append(this.TEXT_41);
                if (hasComponentClass.booleanValue()) {
                    stringBuffer.append(this.TEXT_42);
                    stringBuffer.append(componentClassName);
                    stringBuffer.append(this.TEXT_43);
                } else {
                    stringBuffer.append(this.TEXT_44);
                }
                stringBuffer.append(this.TEXT_45);
            }
            stringBuffer.append(this.TEXT_46);
            if (superActions != null) {
                actions.removeAll(superActions);
            }
            for (Action action : actions) {
                Param param;
                Iterator paramIterator;
                String sinceA = "";
                String sinceAVersion = action.getSince();
                if (sinceAVersion != null && !sinceAVersion.isEmpty()) {
                    sinceA = "@since " + sinceAVersion;
                }
                if (action.isITEInvolved()) continue;
                String methodName = nameLoader.translateFromCompSystem(action.getName());
                String actionDescription = "";
                String actionDescrKey = action.getDescriptionKey();
                if (actionDescrKey != null) {
                    actionDescription = CompSystemI18n.getString((String)actionDescrKey);
                }
                compNameMap.put(action.getName(), methodName);
                List params = action.getParams();
                HashMap<String, String> paramMap = new HashMap<String, String>();
                HashMap<String, String> paramTypeMap = new HashMap<String, String>();
                if (!params.isEmpty()) {
                    paramIterator = params.iterator();
                    stringBuffer.append(this.TEXT_47);
                    stringBuffer.append(actionDescription);
                    stringBuffer.append(this.TEXT_48);
                    while (paramIterator.hasNext()) {
                        param = (Param)paramIterator.next();
                        String paramName = nameLoader.translateFromCompSystem(param.getName());
                        String paramDescription = "";
                        String paramDescrKey = param.getDescriptionKey();
                        if (paramDescrKey != null) {
                            paramDescription = CompSystemI18n.getString((String)paramDescrKey);
                        }
                        stringBuffer.append("* @param ");
                        stringBuffer.append(paramName);
                        stringBuffer.append(this.TEXT_50);
                        stringBuffer.append(paramDescription);
                        stringBuffer.append(this.TEXT_51);
                    }
                    stringBuffer.append("* ");
                    stringBuffer.append(sinceA);
                    stringBuffer.append(this.TEXT_53);
                }
                if (action.isDeprecated()) {
                    stringBuffer.append("@Deprecated");
                }
                stringBuffer.append(this.TEXT_55);
                stringBuffer.append(methodName);
                stringBuffer.append("(");
                paramIterator = params.iterator();
                while (paramIterator.hasNext()) {
                    param = (Param)paramIterator.next();
                    boolean hasCombineableValueSet = param.hasValueSet() && param.getValueSet().isCombinable();
                    String type = param.getType();
                    String name = param.getName();
                    String fqParamType = nameLoader.findTypeForParameter(type, name);
                    String paramType = NameLoader.beautifyParamType(fqParamType);
                    String paramName = nameLoader.translateFromCompSystem(name);
                    String fixedType = nameLoader.getRealTypeForParameter(type, name);
                    paramMap.put(name, fqParamType);
                    paramTypeMap.put(name, fixedType);
                    stringBuffer.append(this.TEXT_57);
                    stringBuffer.append(paramType);
                    if (hasCombineableValueSet) {
                        stringBuffer.append("[]");
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append(paramName);
                    if (!paramIterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.TEXT_61);
                if (genInterface.booleanValue()) {
                    stringBuffer.append(";");
                } else {
                    stringBuffer.append(" {");
                    for (Param parameter : params) {
                        boolean isOptional = parameter.isOptional();
                        String paramName = parameter.getName();
                        String translatedParamName = nameLoader.translateFromCompSystem(paramName);
                        if (!isOptional) {
                            stringBuffer.append(this.TEXT_64);
                            stringBuffer.append(translatedParamName);
                            stringBuffer.append(" == null) return;");
                        }
                        stringBuffer.append(this.TEXT_66);
                    }
                    stringBuffer.append(this.TEXT_67);
                    stringBuffer.append(action.getMethod());
                    stringBuffer.append(this.TEXT_68);
                    stringBuffer.append(hasDefaultMapping);
                    stringBuffer.append(")");
                    if (!hasDefaultMapping.booleanValue()) {
                        stringBuffer.append(this.TEXT_70);
                    } else {
                        stringBuffer.append(this.TEXT_71);
                    }
                    for (Param parameter : params) {
                        boolean isOptional = parameter.isOptional();
                        boolean hasCombineableValueSet = parameter.hasValueSet() && parameter.getValueSet().isCombinable();
                        String paramName = parameter.getName();
                        String translatedParamName = nameLoader.translateFromCompSystem(paramName);
                        String paramEnumType = (String)paramMap.get(paramName);
                        String fqParamType = (String)paramTypeMap.get(paramName);
                        if (nameLoader.isInEnumMap(paramEnumType)) {
                            if (!hasCombineableValueSet) {
                                if (fqParamType.contains("Integer")) {
                                    stringBuffer.append(this.TEXT_72);
                                    if (isOptional) {
                                        stringBuffer.append("Optional");
                                    }
                                    stringBuffer.append("Parameter(");
                                    stringBuffer.append(translatedParamName);
                                    stringBuffer.append(".rcIntValue())");
                                    continue;
                                }
                                stringBuffer.append(this.TEXT_76);
                                if (isOptional) {
                                    stringBuffer.append("Optional");
                                }
                                stringBuffer.append("Parameter(");
                                stringBuffer.append(translatedParamName);
                                stringBuffer.append(".rcValue())");
                                continue;
                            }
                            stringBuffer.append(this.TEXT_80);
                            if (isOptional) {
                                stringBuffer.append("Optional");
                            }
                            stringBuffer.append("Parameter(StringUtils.join(");
                            stringBuffer.append(translatedParamName);
                            stringBuffer.append(", TestDataConstants.COMBI_VALUE_SEPARATOR))");
                            continue;
                        }
                        stringBuffer.append(this.TEXT_84);
                        if (isOptional) {
                            stringBuffer.append("Optional");
                        }
                        stringBuffer.append("Parameter(");
                        stringBuffer.append(translatedParamName);
                        stringBuffer.append(")");
                    }
                    stringBuffer.append(this.TEXT_88);
                }
                stringBuffer.append(this.TEXT_89);
            }
            stringBuffer.append(this.TEXT_90);
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }
}

