/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.IObjectMappingObserver;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;

public class ObjectMappingEventDispatcher {
    private static List<IObjectMappingObserver> observer = new ArrayList<IObjectMappingObserver>();
    private static IObjectMappingCategoryPO categoryToCreateIn;

    private ObjectMappingEventDispatcher() {
    }

    public static synchronized void updateObjectMappings(INodePO node) {
        IAUTMainPO iAUTMainPO;
        List<IObjectMappingObserver> obs = Collections.unmodifiableList(observer);
        if (obs.isEmpty()) {
            return;
        }
        Set<Object> autList = new HashSet();
        if (node instanceof ISpecTestCasePO) {
            IProjectPO iProjectPO = GeneralStorage.getInstance().getProject();
            if (iProjectPO != null) {
                autList = iProjectPO.getAutMainList();
            }
        } else if (node instanceof ITestSuitePO && (iAUTMainPO = ((ITestSuitePO)node).getAut()) != null) {
            autList.add(iAUTMainPO);
        }
        for (IAUTMainPO iAUTMainPO2 : autList) {
            for (IObjectMappingObserver obsvr : obs) {
                try {
                    obsvr.update(1, iAUTMainPO2);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void notifyObjectMappedObserver(IComponentIdentifier[] tech) {
        List<IObjectMappingObserver> obs = Collections.unmodifiableList(observer);
        for (IObjectMappingObserver obsvr : obs) {
            try {
                obsvr.update(2, tech);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void addObserver(IObjectMappingObserver obs) {
        if (!observer.contains(obs)) {
            observer.add(obs);
        }
    }

    public static void removeObserver(IObjectMappingObserver obs) {
        if (observer.contains(obs)) {
            observer.remove(obs);
        }
    }

    public static IObjectMappingCategoryPO getCategoryToCreateIn() {
        return categoryToCreateIn;
    }

    public static void setCategoryToCreateIn(IObjectMappingCategoryPO c) {
        categoryToCreateIn = c;
    }
}

