/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.TDCell;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.RefToken;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;

public abstract class AbstractEditorDndSupport {
    protected static void postDropAction(INodePO node, AbstractJBEditor targetEditor) {
        TreeViewer tree = targetEditor.getTreeViewer();
        IPersistentObject root = targetEditor.getEditorHelper().getEditSupport().getWorkVersion();
        tree.setExpandedState((Object)root, true);
        targetEditor.getCompNameCache();
        targetEditor.setFocus();
        targetEditor.refresh();
        if (node != null) {
            targetEditor.getEditorHelper().setDirty(true);
            tree.setExpandedState((Object)node.getParentNode(), true);
            targetEditor.setSelection((ISelection)new StructuredSelection((Object)node));
        }
        LocalSelectionTransfer.getInstance().setSelection(null);
    }

    protected static INodePO moveNode(INodePO node, INodePO target, int pos) {
        int newPos = pos;
        INodePO par = node.getParentNode();
        if (par == target && par.indexOf(node) < pos) {
            --newPos;
        }
        par.removeNode(node);
        target.addNode(newPos, node);
        return node;
    }

    protected static void fillExec(IExecTestCasePO origExec, IExecTestCasePO newExec, boolean deleteRefDatas) {
        AbstractEditorDndSupport.fillParamNode((IParamNodePO)origExec, (IParamNodePO)newExec, deleteRefDatas);
        newExec.setName(origExec.getRealName());
        ISpecTestCasePO origSpecTC = origExec.getSpecTestCase();
        if (!origExec.getDataManager().equals(origSpecTC.getDataManager())) {
            newExec.setHasReferencedTD(false);
            if (newExec.getDataManager().getUniqueIds().isEmpty()) {
                origExec.getDataManager().deepCopy(newExec.getDataManager());
            }
        } else {
            newExec.setHasReferencedTD(true);
        }
        for (ICompNamesPairPO origPair : origExec.getCompNamesPairs()) {
            ICompNamesPairPO newPair = PoMaker.createCompNamesPairPO((String)origPair.getFirstName(), (String)origPair.getSecondName(), (String)origPair.getType());
            newPair.setPropagated(origPair.isPropagated());
            newExec.addCompNamesPair(newPair);
        }
        if (newExec instanceof IEventExecTestCasePO || origExec instanceof IEventExecTestCasePO) {
            IEventExecTestCasePO newEvent = (IEventExecTestCasePO)newExec;
            IEventExecTestCasePO origEvent = (IEventExecTestCasePO)origExec;
            newEvent.setEventType(origEvent.getEventType());
            newEvent.setReentryProp(origEvent.getReentryProp());
            newEvent.setMaxRetries(origEvent.getMaxRetries());
        }
    }

    protected static void deleteRefDatas(IParamNodePO paramNode) {
        Iterator it = paramNode.getParamReferencesIterator();
        while (it.hasNext()) {
            TDCell cell = (TDCell)it.next();
            String guid = (String)paramNode.getDataManager().getUniqueIds().get(cell.getCol());
            IParamDescriptionPO childDesc = paramNode.getParameterForUniqueId(guid);
            if (childDesc == null) continue;
            ModelParamValueConverter conv = new ModelParamValueConverter(cell.getTestData(), (IParameterInterfacePO)paramNode, childDesc);
            List refTokens = conv.getRefTokens();
            for (RefToken refToken : refTokens) {
                String oldGUID = RefToken.extractCore((String)refToken.getModelString());
                conv.removeReference(oldGUID);
                cell.setTestData(conv.getModelString());
            }
        }
    }

    protected static void fillCap(ICapPO origCap, ICapPO newCap) {
        AbstractEditorDndSupport.fillParamNode((IParamNodePO)origCap, (IParamNodePO)newCap, false);
        newCap.setComponentName(origCap.getComponentName());
        newCap.setComponentType(origCap.getComponentType());
        newCap.setActionName(origCap.getActionName());
        newCap.getDataManager().clearUniqueIds();
        origCap.getDataManager().deepCopy(newCap.getDataManager());
    }

    protected static void fillRefTestSuit(IRefTestSuitePO origRefTS, IRefTestSuitePO newRefTS) {
        AbstractEditorDndSupport.fillNode((INodePO)origRefTS, (INodePO)newRefTS);
        newRefTS.setName(origRefTS.getRealName());
        newRefTS.setTestSuiteAutID(origRefTS.getTestSuiteAutID());
    }

    protected static void fillNode(INodePO origNode, INodePO newNode) {
        newNode.setActive(origNode.isActive());
        newNode.setComment(origNode.getComment());
        newNode.setGenerated(origNode.isGenerated());
        newNode.setDescription(origNode.getDescription());
        newNode.setToolkitLevel(origNode.getToolkitLevel());
    }

    protected static void fillParamNode(IParamNodePO origNode, IParamNodePO newNode, boolean delRef) {
        AbstractEditorDndSupport.fillNode((INodePO)origNode, (INodePO)newNode);
        if (delRef) {
            AbstractEditorDndSupport.deleteRefDatas(newNode);
        }
        newNode.setName(origNode.getName());
        newNode.setDataFile(origNode.getDataFile());
        newNode.setReferencedDataCube(origNode.getReferencedDataCube());
    }
}

