/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.TransactionSupport;
import org.eclipse.jubula.client.core.utils.NativeSQLUtils;
import org.eclipse.jubula.client.ui.rcp.actions.TransactionWrapper;

public class DeleteNodesTransaction
implements TransactionSupport.ITransaction {
    private Collection<INodePO> m_nodes;
    private Collection<INodePO> m_allNodes;
    private List<IPersistentObject> m_toLock;
    private Set<IPersistentObject> m_toRefresh;
    private IProgressMonitor m_monitor;

    public DeleteNodesTransaction(Collection<INodePO> topNodes, Collection<INodePO> allNodes, IProgressMonitor monitor) {
        this.m_nodes = topNodes;
        this.m_allNodes = allNodes;
        this.m_monitor = monitor;
        this.m_toRefresh = new HashSet<IPersistentObject>();
        IProjectPO proj = GeneralStorage.getInstance().getProject();
        if (NodeBP.isTC((INodePO)this.m_nodes.iterator().next())) {
            this.m_toRefresh.add((IPersistentObject)proj.getSpecObjCont());
        } else {
            this.m_toRefresh.add((IPersistentObject)proj.getExecObjCont());
        }
        for (INodePO node : topNodes) {
            INodePO par = node.getParentNode();
            if (par.equals((Object)ISpecObjContPO.TCB_ROOT_NODE) || par.equals((Object)IExecObjContPO.TSB_ROOT_NODE)) continue;
            this.m_toRefresh.add((IPersistentObject)par);
        }
        this.m_toLock = new ArrayList<IPersistentObject>();
        this.m_toLock.addAll(this.m_allNodes);
        this.m_toLock.addAll(this.m_toRefresh);
    }

    public Collection<? extends IPersistentObject> getToLock() {
        return this.m_toLock;
    }

    public Collection<? extends IPersistentObject> getToRefresh() {
        return this.m_toRefresh;
    }

    public Collection<? extends IPersistentObject> getToMerge() {
        return null;
    }

    public void run(EntityManager sess) {
        NativeSQLUtils.deleteFromTCTSTreeAFFECTS((EntityManager)sess, this.m_nodes, (IProgressMonitor)this.m_monitor);
    }

    public static void deleteTopNodes(Collection<INodePO> topNodes, Collection<INodePO> allNodes, IProgressMonitor monitor) {
        if (!TransactionWrapper.executeOperation(new DeleteNodesTransaction(topNodes, allNodes, monitor))) {
            return;
        }
        ArrayList<DataChangedEvent> eventList = new ArrayList<DataChangedEvent>();
        for (INodePO node : topNodes) {
            eventList.add(new DataChangedEvent((IPersistentObject)node, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all));
        }
        CompNameManager.getInstance().countUsage();
        DataEventDispatcher.getInstance().fireDataChangedListener(eventList.toArray(new DataChangedEvent[0]));
    }
}

