/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.wizards.pages;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnection;
import org.eclipse.jubula.client.core.preferences.database.H2ConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.MySQLConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.OracleConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.PostGreSQLConnectionInfo;
import org.eclipse.jubula.client.ui.databinding.SimpleIntegerToStringConverter;
import org.eclipse.jubula.client.ui.databinding.SimpleStringToIntegerConverter;
import org.eclipse.jubula.client.ui.databinding.validators.StringToPortValidator;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class DatabaseConnectionWizardPage
extends WizardPage {
    private IDetailAreaBuilder[] m_detailAreaBuilders = new IDetailAreaBuilder[]{new H2DetailBuilder(), new OracleDetailBuilder(), new PostGreSQLDetailBuilder(), new MySQLDetailBuilder()};
    private DatabaseConnection m_connectionToEdit;

    public DatabaseConnectionWizardPage(String pageName) {
        super(pageName);
    }

    public DatabaseConnectionWizardPage(String pageName, DatabaseConnection connectionToEdit) {
        super(pageName);
        this.m_connectionToEdit = connectionToEdit;
        IDetailAreaBuilder[] iDetailAreaBuilderArray = this.m_detailAreaBuilders;
        int n = this.m_detailAreaBuilders.length;
        int n2 = 0;
        while (n2 < n) {
            IDetailAreaBuilder builder = iDetailAreaBuilderArray[n2];
            builder.initializeInfo(this.m_connectionToEdit.getConnectionInfo());
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        this.setTitle(I18n.getString((String)"DatabaseConnectionWizardPage.title"));
        this.setDescription(I18n.getString((String)"DatabaseConnectionWizardPage.description"));
        DataBindingContext dbc = new DataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        GridDataFactory textGridDataFactory = GridDataFactory.fillDefaults().grab(true, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.setControl((Control)composite);
        UIComponentHelper.createLabel(composite, I18n.getString((String)"DatabaseConnection.Name"), 0);
        Text nameText = new Text(composite, 2048);
        DialogUtils.setWidgetName((Widget)nameText, "DatabaseConnection.Name");
        nameText.setLayoutData((Object)textGridDataFactory.create());
        dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)nameText, (int)24), BeansObservables.observeValue((Object)this.m_connectionToEdit, (String)"name"), new UpdateValueStrategy().setAfterGetValidator(new IValidator(){

            public IStatus validate(Object value) {
                if (StringUtils.isEmpty((String)((String)value))) {
                    return ValidationStatus.error((String)I18n.getString((String)"DatabaseConnectionWizardPage.Error.emptyName"));
                }
                return ValidationStatus.ok();
            }
        }), new UpdateValueStrategy());
        nameText.setFocus();
        nameText.selectAll();
        UIComponentHelper.createLabel(composite, I18n.getString((String)"DatabaseConnection.Type"), 0);
        ComboViewer typeComboViewer = new ComboViewer(composite);
        DialogUtils.setWidgetName((Widget)typeComboViewer.getControl(), "DatabaseConnection.Type");
        typeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        typeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IDetailAreaBuilder)element).getTypeName();
            }
        });
        typeComboViewer.setInput((Object)this.m_detailAreaBuilders);
        typeComboViewer.getControl().setLayoutData((Object)textGridDataFactory.create());
        Composite detailArea = DatabaseConnectionWizardPage.createDetailArea(composite, nameText.computeSize((int)-1, (int)-1).y);
        DialogUtils.setWidgetName((Widget)detailArea, "DatabaseConnection.DetailArea");
        IObservableValue connectionInfoObservable = BeansObservables.observeValue((Object)this.m_connectionToEdit, (String)"connectionInfo");
        this.bindComboViewer(dbc, typeComboViewer, detailArea, connectionInfoObservable);
        Text url = new Text(composite, 2048);
        DialogUtils.setWidgetName((Widget)url, "DatabaseConnection.URL");
        url.setEditable(false);
        url.setBackground(composite.getBackground());
        url.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)url), BeansObservables.observeDetailValue((IObservableValue)connectionInfoObservable, (String)"connectionUrl", null), new UpdateValueStrategy().setAfterGetValidator(new IValidator(){

            public IStatus validate(Object value) {
                if (StringUtils.isEmpty((String)((String)value))) {
                    return ValidationStatus.error((String)I18n.getString((String)"DatabaseConnectionWizardPage.Error.emptyName"));
                }
                return ValidationStatus.ok();
            }
        }), new UpdateValueStrategy());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jubula.client.ua.help.databaseConnectionConfigurationDialogContextId");
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.jubula.client.ua.help.databaseConnectionConfigurationDialogContextId");
    }

    private void bindComboViewer(final DataBindingContext dbc, ComboViewer typeComboViewer, final Composite detailArea, IObservableValue connectionInfoObservable) {
        dbc.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)typeComboViewer), connectionInfoObservable, new UpdateValueStrategy().setConverter(new IConverter(){

            public Object getToType() {
                return DatabaseConnectionInfo.class;
            }

            public Object getFromType() {
                return IDetailAreaBuilder.class;
            }

            public Object convert(Object fromObject) {
                Control[] controlArray = detailArea.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    child.dispose();
                    ++n2;
                }
                IDetailAreaBuilder fromBuilder = (IDetailAreaBuilder)fromObject;
                fromBuilder.createDetailArea(detailArea, dbc);
                detailArea.layout();
                ((Composite)DatabaseConnectionWizardPage.this.getControl()).layout();
                return fromBuilder.getConnectionInfo();
            }
        }), new UpdateValueStrategy().setConverter(new IConverter(){

            public Object getToType() {
                return IDetailAreaBuilder.class;
            }

            public Object getFromType() {
                return DatabaseConnectionInfo.class;
            }

            public Object convert(Object fromObject) {
                DatabaseConnectionInfo fromInfo = (DatabaseConnectionInfo)fromObject;
                IDetailAreaBuilder[] iDetailAreaBuilderArray = DatabaseConnectionWizardPage.this.m_detailAreaBuilders;
                int n = iDetailAreaBuilderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IDetailAreaBuilder builder = iDetailAreaBuilderArray[n2];
                    if (builder.getConnectionInfo() == fromInfo) {
                        Control[] controlArray = detailArea.getChildren();
                        int n3 = controlArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Control child = controlArray[n4];
                            child.dispose();
                            ++n4;
                        }
                        builder.createDetailArea(detailArea, dbc);
                        detailArea.layout();
                        ((Composite)DatabaseConnectionWizardPage.this.getControl()).layout();
                        return builder;
                    }
                    ++n2;
                }
                return null;
            }
        }));
    }

    private static Text createDetailText(Composite parent) {
        Text detailText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)detailText);
        return detailText;
    }

    private static Composite createDetailArea(Composite parent, int fieldHeight) {
        GridLayout detailAreaLayout = new GridLayout(2, false);
        Group detailArea = new Group(parent, 0);
        int totalFieldHeight = fieldHeight * 3;
        int totalVerticalSpacing = detailAreaLayout.verticalSpacing * 2;
        int totalMarginHeight = detailAreaLayout.marginHeight * 2 + detailAreaLayout.marginBottom + detailAreaLayout.marginTop;
        int detailAreaVerticalHint = totalFieldHeight + totalVerticalSpacing + totalMarginHeight;
        detailArea.setText(I18n.getString((String)"DatabaseConnectionWizardPage.DetailArea.title"));
        detailArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(2, 1).hint(-1, detailAreaVerticalHint).create());
        detailArea.setLayout((Layout)detailAreaLayout);
        return detailArea;
    }

    private static final class H2DetailBuilder
    implements IDetailAreaBuilder {
        private H2ConnectionInfo m_connInfo = new H2ConnectionInfo();

        private H2DetailBuilder() {
        }

        public void initializeInfo(DatabaseConnectionInfo sourceInfo) {
            if (sourceInfo instanceof H2ConnectionInfo) {
                this.m_connInfo = (H2ConnectionInfo)sourceInfo;
            }
        }

        public void createDetailArea(Composite parent, DataBindingContext dbc) {
            UIComponentHelper.createLabel(parent, I18n.getString((String)"DatabaseConnection.H2.Location"), 0);
            Text locationText = DatabaseConnectionWizardPage.createDetailText(parent);
            DialogUtils.setWidgetName((Widget)locationText, "H2.Location");
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)locationText, (int)24), PojoObservables.observeValue((Object)this.m_connInfo, (String)"location"), new UpdateValueStrategy().setAfterGetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    if (StringUtils.isEmpty((String)((String)value))) {
                        return ValidationStatus.error((String)Messages.DatabaseConnectionPreferencePageLocationEmpty);
                    }
                    return ValidationStatus.ok();
                }
            }), new UpdateValueStrategy());
        }

        public String getTypeName() {
            return "H2";
        }

        public DatabaseConnectionInfo getConnectionInfo() {
            return this.m_connInfo;
        }
    }

    private static interface IDetailAreaBuilder {
        public void createDetailArea(Composite var1, DataBindingContext var2);

        public String getTypeName();

        public void initializeInfo(DatabaseConnectionInfo var1);

        public DatabaseConnectionInfo getConnectionInfo();
    }

    private static final class MySQLDetailBuilder
    implements IDetailAreaBuilder {
        private MySQLConnectionInfo m_connInfo = new MySQLConnectionInfo();

        private MySQLDetailBuilder() {
        }

        public void createDetailArea(Composite parent, DataBindingContext dbc) {
            UIComponentHelper.createLabel(parent, I18n.getString((String)"DatabaseConnection.HostBased.Hostname"), 0);
            Text hostnameText = DatabaseConnectionWizardPage.createDetailText(parent);
            DialogUtils.setWidgetName((Widget)hostnameText, "MySQL.Hostname");
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)hostnameText, (int)24), BeansObservables.observeValue((Object)this.m_connInfo, (String)"hostname"), new UpdateValueStrategy().setAfterGetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    if (StringUtils.isEmpty((String)((String)value))) {
                        return ValidationStatus.error((String)Messages.DatabaseConnectionPreferencePageHostnameEmpty);
                    }
                    return ValidationStatus.ok();
                }
            }), new UpdateValueStrategy());
            UIComponentHelper.createLabel(parent, I18n.getString((String)"DatabaseConnection.HostBased.Port"), 0);
            Text portText = DatabaseConnectionWizardPage.createDetailText(parent);
            DialogUtils.setWidgetName((Widget)portText, "MySQL.Port");
            UpdateValueStrategy portTargetToModelUpdateStrategy = new UpdateValueStrategy();
            portTargetToModelUpdateStrategy.setConverter((IConverter)new SimpleStringToIntegerConverter()).setAfterGetValidator((IValidator)new StringToPortValidator(I18n.getString((String)"DatabaseConnection.HostBased.Port")));
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)portText, (int)24), BeansObservables.observeValue((Object)this.m_connInfo, (String)"port"), portTargetToModelUpdateStrategy, new UpdateValueStrategy().setConverter((IConverter)new SimpleIntegerToStringConverter()));
            UIComponentHelper.createLabel(parent, I18n.getString((String)"DatabaseConnection.MySQL.Database"), 0);
            Text schemaText = DatabaseConnectionWizardPage.createDetailText(parent);
            DialogUtils.setWidgetName((Widget)schemaText, "MySQL.Database");
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)schemaText, (int)24), BeansObservables.observeValue((Object)this.m_connInfo, (String)"databaseName"), new UpdateValueStrategy().setAfterGetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    if (StringUtils.isEmpty((String)((String)value))) {
                        return ValidationStatus.error((String)Messages.DatabaseConnectionPreferencePageDatabaseEmpty);
                    }
                    return ValidationStatus.ok();
                }
            }), new UpdateValueStrategy());
        }

        public String getTypeName() {
            return "(unsupported) MySQL";
        }

        public void initializeInfo(DatabaseConnectionInfo sourceInfo) {
            if (sourceInfo instanceof MySQLConnectionInfo) {
                this.m_connInfo = (MySQLConnectionInfo)sourceInfo;
            }
        }

        public DatabaseConnectionInfo getConnectionInfo() {
            return this.m_connInfo;
        }
    }

    private static final class OracleDetailBuilder
    implements IDetailAreaBuilder {
        private OracleConnectionInfo m_connInfo = new OracleConnectionInfo();

        private OracleDetailBuilder() {
        }

        public void createDetailArea(Composite parent, DataBindingContext dbc) {
            UIComponentHelper.createLabel(parent, I18n.getString((String)"DatabaseConnection.HostBased.Hostname"), 0);
            Text hostnameText = DatabaseConnectionWizardPage.createDetailText(parent);
            DialogUtils.setWidgetName((Widget)hostnameText, "Oracle.Hostname");
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)hostnameText, (int)24), BeansObservables.observeValue((Object)this.m_connInfo, (String)"hostname"), new UpdateValueStrategy().setAfterGetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    if (StringUtils.isEmpty((String)((String)value))) {
                        return ValidationStatus.error((String)Messages.DatabaseConnectionPreferencePageHostnameEmpty);
                    }
                    return ValidationStatus.ok();
                }
            }), new UpdateValueStrategy());
            UIComponentHelper.createLabel(parent, I18n.getString((String)"DatabaseConnection.HostBased.Port"), 0);
            Text portText = DatabaseConnectionWizardPage.createDetailText(parent);
            DialogUtils.setWidgetName((Widget)portText, "Oracle.Port");
            UpdateValueStrategy portTargetToModelUpdateStrategy = new UpdateValueStrategy();
            portTargetToModelUpdateStrategy.setConverter((IConverter)new SimpleStringToIntegerConverter()).setAfterGetValidator((IValidator)new StringToPortValidator(I18n.getString((String)"DatabaseConnection.HostBased.Port")));
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)portText, (int)24), BeansObservables.observeValue((Object)this.m_connInfo, (String)"port"), portTargetToModelUpdateStrategy, new UpdateValueStrategy().setConverter((IConverter)new SimpleIntegerToStringConverter()));
            UIComponentHelper.createLabel(parent, I18n.getString((String)"DatabaseConnection.Oracle.SID"), 0);
            Text schemaText = DatabaseConnectionWizardPage.createDetailText(parent);
            DialogUtils.setWidgetName((Widget)schemaText, "Oracle.SID");
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)schemaText, (int)24), BeansObservables.observeValue((Object)this.m_connInfo, (String)"databaseName"), new UpdateValueStrategy().setAfterGetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    if (StringUtils.isEmpty((String)((String)value))) {
                        return ValidationStatus.error((String)Messages.DatabaseConnectionPreferencePageSIDEmpty);
                    }
                    return ValidationStatus.ok();
                }
            }), new UpdateValueStrategy());
        }

        public String getTypeName() {
            return "Oracle";
        }

        public void initializeInfo(DatabaseConnectionInfo sourceInfo) {
            if (sourceInfo instanceof OracleConnectionInfo) {
                this.m_connInfo = (OracleConnectionInfo)sourceInfo;
            }
        }

        public DatabaseConnectionInfo getConnectionInfo() {
            return this.m_connInfo;
        }
    }

    private static final class PostGreSQLDetailBuilder
    implements IDetailAreaBuilder {
        private PostGreSQLConnectionInfo m_connInfo = new PostGreSQLConnectionInfo();

        private PostGreSQLDetailBuilder() {
        }

        public void createDetailArea(Composite parent, DataBindingContext dbc) {
            UIComponentHelper.createLabel(parent, I18n.getString((String)"DatabaseConnection.HostBased.Hostname"), 0);
            Text hostnameText = DatabaseConnectionWizardPage.createDetailText(parent);
            DialogUtils.setWidgetName((Widget)hostnameText, "PostGreSQL.Hostname");
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)hostnameText, (int)24), BeansObservables.observeValue((Object)this.m_connInfo, (String)"hostname"), new UpdateValueStrategy().setAfterGetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    if (StringUtils.isEmpty((String)((String)value))) {
                        return ValidationStatus.error((String)Messages.DatabaseConnectionPreferencePageHostnameEmpty);
                    }
                    return ValidationStatus.ok();
                }
            }), new UpdateValueStrategy());
            UIComponentHelper.createLabel(parent, I18n.getString((String)"DatabaseConnection.HostBased.Port"), 0);
            Text portText = DatabaseConnectionWizardPage.createDetailText(parent);
            DialogUtils.setWidgetName((Widget)portText, "PostGreSQL.Port");
            UpdateValueStrategy portTargetToModelUpdateStrategy = new UpdateValueStrategy();
            portTargetToModelUpdateStrategy.setConverter((IConverter)new SimpleStringToIntegerConverter()).setAfterGetValidator((IValidator)new StringToPortValidator(I18n.getString((String)"DatabaseConnection.HostBased.Port")));
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)portText, (int)24), BeansObservables.observeValue((Object)this.m_connInfo, (String)"port"), portTargetToModelUpdateStrategy, new UpdateValueStrategy().setConverter((IConverter)new SimpleIntegerToStringConverter()));
            UIComponentHelper.createLabel(parent, I18n.getString((String)"DatabaseConnection.PostGreSQL.Database"), 0);
            Text schemaText = DatabaseConnectionWizardPage.createDetailText(parent);
            DialogUtils.setWidgetName((Widget)schemaText, "PostGreSQL.Database");
            dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)schemaText, (int)24), BeansObservables.observeValue((Object)this.m_connInfo, (String)"databaseName"), new UpdateValueStrategy().setAfterGetValidator(new IValidator(){

                public IStatus validate(Object value) {
                    if (StringUtils.isEmpty((String)((String)value))) {
                        return ValidationStatus.error((String)Messages.DatabaseConnectionPreferencePageDatabaseEmpty);
                    }
                    return ValidationStatus.ok();
                }
            }), new UpdateValueStrategy());
        }

        public String getTypeName() {
            return "(unsupported) PostGreSQL";
        }

        public void initializeInfo(DatabaseConnectionInfo sourceInfo) {
            if (sourceInfo instanceof PostGreSQLConnectionInfo) {
                this.m_connInfo = (PostGreSQLConnectionInfo)sourceInfo;
            }
        }

        public DatabaseConnectionInfo getConnectionInfo() {
            return this.m_connInfo;
        }
    }
}

