/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.rc.common.driver.CheckWithTimeoutQueuer;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRobotFactory;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.AbstractMenuTester;
import org.eclipse.jubula.rc.common.tester.AbstractUITester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IWidgetComponent;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.common.util.ReflectionUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetTester
extends AbstractUITester {
    public static final String RC_METHOD_NAME_WAIT_FOR_COMPONENT = "rcWaitForComponent";
    public static final String RC_METHOD_NAME_CHECK_EXISTENCE = "rcVerifyExists";

    protected IWidgetComponent getWidgetAdapter() {
        return (IWidgetComponent)this.getComponent();
    }

    public void rcVerifyExists(boolean exists, int timeout) {
        Verifier.equals(exists, this.getWidgetAdapter().isShowing());
    }

    public void rcVerifyFocus(final boolean hasFocus, int timeout) {
        String name = "rcVerifyFocus";
        CheckWithTimeoutQueuer.invokeAndWait(name, timeout, new Runnable(){

            public void run() {
                Verifier.equals(hasFocus, WidgetTester.this.getWidgetAdapter().hasFocus());
            }
        });
    }

    public void rcVerifyEnabled(final boolean enabled, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait("rcVerifyEnabled", timeout, new Runnable(){

            public void run() {
                Verifier.equals(enabled, WidgetTester.this.getWidgetAdapter().isEnabled());
            }
        });
    }

    public void rcVerifyProperty(final String name, final String value, final String operator, int timeout) {
        final IWidgetComponent bean = (IWidgetComponent)this.getComponent();
        CheckWithTimeoutQueuer.invokeAndWait("rcVerifyProperty", timeout, new Runnable(){

            public void run() {
                bean.getPropteryValue(name);
                String propToStr = bean.getPropteryValue(name);
                Verifier.match(propToStr, value, operator);
            }
        });
    }

    public void rcClick(int count, int button) {
        this.getRobot().click(this.getComponent().getRealComponent(), null, ClickOptions.create().setClickCount(count).setMouseButton(button));
    }

    public void rcClick(int count) {
        this.rcClick(count, 1);
    }

    public void rcClickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        this.getRobot().click(this.getComponent().getRealComponent(), null, ClickOptions.create().setClickCount(count).setMouseButton(button), xPos, xUnits.equalsIgnoreCase(ValueSets.Unit.pixel.rcValue()), yPos, yUnits.equalsIgnoreCase(ValueSets.Unit.pixel.rcValue()));
    }

    public void rcDrag(int mouseButton, String modifier, int xPos, String xUnits, int yPos, String yUnits) {
        this.getWidgetAdapter().rcDrag(mouseButton, modifier, xPos, xUnits, yPos, yUnits);
    }

    public void rcDrop(int xPos, String xUnits, int yPos, String yUnits, int delayBeforeDrop) {
        this.getWidgetAdapter().rcDrop(xPos, xUnits, yPos, yUnits, delayBeforeDrop);
    }

    public void rcWaitForComponent(int timeout, int delay) {
    }

    public String rcStorePropertyValue(String variableName, String propertyName) {
        IWidgetComponent bean = (IWidgetComponent)this.getComponent();
        return bean.getPropteryValue(propertyName);
    }

    public void rcPopupSelectByIndexPath(String indexPath, int button) throws StepExecutionException {
        AbstractMenuTester popup = this.getWidgetAdapter().showPopup(button);
        popup.selectMenuItemByIndexpath(indexPath);
    }

    public void rcPopupSelectByTextPath(String textPath, String operator, int button) throws StepExecutionException {
        AbstractMenuTester popup = this.getWidgetAdapter().showPopup(button);
        popup.selectMenuItem(textPath, operator);
    }

    public void rcPopupSelectByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, int button) throws StepExecutionException {
        AbstractMenuTester popup = this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
        popup.selectMenuItem(textPath, operator);
    }

    public void rcPopupSelectByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, int button) throws StepExecutionException {
        AbstractMenuTester popup = this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
        popup.selectMenuItemByIndexpath(indexPath);
    }

    public void rcPopupVerifyEnabledByIndexPath(final String indexPath, final boolean enabled, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifyEnabledByIndexPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(button);
                popup.verifyEnabledByIndexpath(indexPath, enabled, 0);
            }
        });
    }

    public void rcPopupVerifyEnabledByIndexPath(final int xPos, final String xUnits, final int yPos, final String yUnits, final String indexPath, final boolean enabled, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifyEnabledByIndexPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
                popup.verifyEnabledByIndexpath(indexPath, enabled, 0);
            }
        });
    }

    public void rcPopupVerifyEnabledByTextPath(final String textPath, final String operator, final boolean enabled, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifyEnabledByTextPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(button);
                popup.verifyEnabled(textPath, operator, enabled, 0);
            }
        });
    }

    public void rcPopupVerifyEnabledByTextPath(final int xPos, final String xUnits, final int yPos, final String yUnits, final String textPath, final String operator, final boolean enabled, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifyEnabledByTextPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
                popup.verifyEnabled(textPath, operator, enabled, 0);
            }
        });
    }

    public void rcPopupVerifySelectedByIndexPath(final String indexPath, final boolean selected, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifySelectedByIndexPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(button);
                popup.verifySelectedByIndexpath(indexPath, selected, 0);
            }
        });
    }

    public void rcPopupVerifySelectedByIndexPath(final int xPos, final String xUnits, final int yPos, final String yUnits, final String indexPath, final boolean selected, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifySelectedByIndexPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
                popup.verifySelectedByIndexpath(indexPath, selected, 0);
            }
        });
    }

    public void rcPopupVerifySelectedByTextPath(final String textPath, final String operator, final boolean selected, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifySelectedByTextPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(button);
                popup.verifySelected(textPath, operator, selected, 0);
            }
        });
    }

    public void rcPopupVerifySelectedByTextPath(final int xPos, final String xUnits, final int yPos, final String yUnits, final String textPath, final String operator, final boolean selected, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifySelectedByTextPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
                popup.verifySelected(textPath, operator, selected, 0);
            }
        });
    }

    public void rcPopupVerifyExistsByIndexPath(final String indexPath, final boolean exists, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifyExistsByIndexPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(button);
                popup.verifyExistsByIndexpath(indexPath, exists, 0);
            }
        });
    }

    public void rcPopupVerifyExistsByIndexPath(final int xPos, final String xUnits, final int yPos, final String yUnits, final String indexPath, final boolean exists, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifyExistsByIndexPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
                popup.verifyExistsByIndexpath(indexPath, exists, 0);
            }
        });
    }

    public void rcPopupVerifyExistsByTextPath(final String textPath, final String operator, final boolean exists, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifyExistsByTextPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(button);
                popup.verifyExists(textPath, operator, exists, 0);
            }
        });
    }

    public void rcPopupVerifyExistsByTextPath(final int xPos, final String xUnits, final int yPos, final String yUnits, final String textPath, final String operator, final boolean exists, final int button, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcPopupVerifyExistaByTextPath", timeout, new Runnable(){

            public void run() {
                AbstractMenuTester popup = WidgetTester.this.getWidgetAdapter().showPopup(xPos, xUnits, yPos, yUnits, button);
                popup.verifyExists(textPath, operator, exists, 0);
            }
        });
    }

    protected ClickOptions.ClickModifier getClickModifier(String extendSelection) {
        ClickOptions.ClickModifier cm = ClickOptions.ClickModifier.create();
        if (ValueSets.BinaryChoice.yes.rcValue().equalsIgnoreCase(extendSelection)) {
            cm.add(1);
        }
        return cm;
    }

    public void rcShowText(String text, int textSize, int timePerWord, int windowWidth) {
        this.getWidgetAdapter().showToolTip(text, textSize, timePerWord, windowWidth);
    }

    protected void pressOrReleaseModifiers(String modifier, boolean press) {
        IRobot robot = this.getRobot();
        StringTokenizer modTok = new StringTokenizer(KeyStrokeUtil.getModifierString(modifier), " ");
        while (modTok.hasMoreTokens()) {
            String mod = modTok.nextToken();
            int keyCode = this.getKeyCode(mod);
            if (press) {
                robot.keyPress(null, keyCode);
                continue;
            }
            robot.keyRelease(null, keyCode);
        }
    }

    protected int getKeyCode(String mod) {
        return this.getWidgetAdapter().getKeyCode(mod);
    }

    public void rcInvokeMethod(String fqcn, String name, @Nullable String signature, @Nullable String args, @Nullable String argsSplit, int timeout) {
        IRobotFactory factory = this.getComponent().getRobotFactory();
        IEventThreadQueuer queuer = factory.getEventThreadQueuer();
        try {
            queuer.invokeAndWait("invokeMethod", this.createCallable(fqcn, name, signature, args, argsSplit), timeout);
        }
        catch (TimeoutException e) {
            throw new StepExecutionException(e.toString(), EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
        }
    }

    public String rcInvokeMethodStoreReturn(String variableName, String fqcn, String name, @Nullable String signature, @Nullable String args, @Nullable String argsSplit, int timeout) {
        IRobotFactory factory = this.getComponent().getRobotFactory();
        IEventThreadQueuer queuer = factory.getEventThreadQueuer();
        try {
            Object result = queuer.invokeAndWait("invokeMethod", this.createCallable(fqcn, name, signature, args, argsSplit), timeout);
            return result == null ? "NULL" : result.toString();
        }
        catch (TimeoutException e) {
            throw new StepExecutionException(e.toString(), EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
        }
    }

    private Callable<Object> createCallable(final String fqcn, final String name, final @Nullable String signature, final @Nullable String args, final @Nullable String argsSplit) {
        return new Callable<Object>(){

            @Override
            public Object call() {
                ClassLoader uiClassloader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = Class.forName(fqcn, true, uiClassloader);
                    Class[] parameterClasses = new Class[]{};
                    Object[] argObjects = new Object[]{};
                    if (!StringUtils.isEmpty((String)signature) && !StringUtils.isEmpty((String)args)) {
                        parameterClasses = ReflectionUtil.getParameterClasses(signature, uiClassloader);
                        argObjects = ReflectionUtil.getParameterValues(args, argsSplit, parameterClasses);
                    }
                    ArrayList<Object> argList = new ArrayList<Object>(Arrays.asList(argObjects));
                    argList.add(0, WidgetTester.this.getComponent().getRealComponent());
                    ArrayList<Class> clsList = new ArrayList<Class>(Arrays.asList(parameterClasses));
                    clsList.add(0, WidgetTester.this.getComponent().getRealComponent().getClass());
                    return MethodUtils.invokeStaticMethod(clazz, (String)name, (Object[])argList.toArray(), (Class[])clsList.toArray(new Class[parameterClasses.length + 1]));
                }
                catch (Throwable e) {
                    ReflectionUtil.handleException(e);
                    return null;
                }
            }
        };
    }

    public String rcInvokeMethod(String fqcn, String name, int timeout) {
        IRobotFactory factory = this.getComponent().getRobotFactory();
        IEventThreadQueuer queuer = factory.getEventThreadQueuer();
        try {
            queuer.invokeAndWait("invokeMethod", this.createCallable(fqcn, name), timeout);
        }
        catch (TimeoutException e) {
            throw new StepExecutionException(e.toString(), EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
        }
        return null;
    }

    public String rcInvokeMethodStoreReturn(String variableName, String fqcn, String name, int timeout) {
        IRobotFactory factory = this.getComponent().getRobotFactory();
        IEventThreadQueuer queuer = factory.getEventThreadQueuer();
        try {
            Object result = queuer.invokeAndWait("invokeMethod", this.createCallable(fqcn, name), timeout);
            return result == null ? "NULL" : result.toString();
        }
        catch (TimeoutException e) {
            throw new StepExecutionException(e.toString(), EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
        }
    }

    private Callable<Object> createCallable(final String fqcn, final String name) {
        return new Callable<Object>(){

            @Override
            public Object call() {
                ClassLoader uiClassloader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = Class.forName(fqcn, true, uiClassloader);
                    Object[] param = new Object[]{WidgetTester.this.getComponent().getRealComponent()};
                    Class[] paramClass = new Class[]{WidgetTester.this.getComponent().getRealComponent().getClass()};
                    return MethodUtils.invokeStaticMethod(clazz, (String)name, (Object[])param, (Class[])paramClass);
                }
                catch (Throwable e) {
                    ReflectionUtil.handleException(e);
                    return null;
                }
            }
        };
    }

    public static void waitBeforeDrop(int delayBeforeDrop) {
        TimeUtil.delay((long)delayBeforeDrop);
    }

    @Override
    public String[] getTextArrayFromComponent() {
        return null;
    }
}

