/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester;

import com.sun.javafx.scene.control.skin.TableHeaderRow;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import org.eclipse.jubula.rc.common.driver.CheckWithTimeoutQueuer;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.AbstractTableTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableComponent;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.util.AbstractTraverser;
import org.eclipse.jubula.rc.javafx.tester.util.GenericTraverseHelper;
import org.eclipse.jubula.rc.javafx.tester.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.tester.util.NodeTraverseHelper;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class TableTester
extends AbstractTableTester {
    private static AutServerLogger log = new AutServerLogger(TableTester.class);
    private EventHandler<ScrollToEvent> m_scrollConsumer = new EventHandler<ScrollToEvent>(){

        public void handle(ScrollToEvent event) {
            event.consume();
        }
    };

    public void rcDragCell(int mouseButton, String modifier, String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        super.rcDragCell(mouseButton, modifier, row, rowOperator, col, colOperator, xPos, xUnits, yPos, yUnits);
        Node table = (Node)this.getRealComponent();
        table.addEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
        DragAndDropHelper.getInstance().setDragMode(true);
    }

    public void rcDropCell(String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits, int delayBeforeDrop) throws StepExecutionException {
        try {
            ITableComponent adapter = (ITableComponent)this.getComponent();
            int implRow = adapter.getRowFromString(row, rowOperator);
            int implCol = adapter.getColumnFromString(col, colOperator);
            TableCell<?, ?> targetCell = this.getCellAt(implRow + 1, implCol + 1);
            if (targetCell == null) {
                throw new StepExecutionException("Drop target not visible", EventFactory.createActionError((String)"TestErrorEvent.NotVisible"));
            }
            super.rcDropCell(row, rowOperator, col, colOperator, xPos, xUnits, yPos, yUnits, delayBeforeDrop);
        }
        finally {
            Node table = (Node)this.getRealComponent();
            table.removeEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            dndHelper.setDragMode(false);
        }
    }

    public void rcDragRowByValue(int mouseButton, String modifier, String col, String colOperator, String value, String regexOp, String searchType) {
        super.rcDragRowByValue(mouseButton, modifier, col, colOperator, value, regexOp, searchType);
        Node table = (Node)this.getRealComponent();
        table.addEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
        DragAndDropHelper.getInstance().setDragMode(true);
    }

    public void rcDropRowByValue(String col, String colOperator, String value, String regexOp, String searchType, int delayBeforeDrop) {
        try {
            ITableComponent adapter = (ITableComponent)this.getComponent();
            int implRow = adapter.getRowFromString(value, regexOp);
            int implCol = adapter.getColumnFromString(col, colOperator);
            TableCell<?, ?> targetCell = this.getCellAt(implRow + 1, implCol + 1);
            if (targetCell == null) {
                throw new StepExecutionException("Drop target not visible", EventFactory.createActionError((String)"TestErrorEvent.NotVisible"));
            }
            super.rcDropRowByValue(col, colOperator, value, regexOp, searchType, delayBeforeDrop);
        }
        finally {
            Node table = (Node)this.getRealComponent();
            table.removeEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            dndHelper.setDragMode(false);
        }
    }

    public void rcDragCellByColValue(int mouseButton, String modifier, String row, String rowOperator, String value, String regex, String searchType) {
        super.rcDragCellByColValue(mouseButton, modifier, row, rowOperator, value, regex, searchType);
        Node table = (Node)this.getRealComponent();
        table.addEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
        DragAndDropHelper.getInstance().setDragMode(true);
    }

    public void rcDropCellByColValue(String row, String rowOperator, String value, String regex, String searchType, int delayBeforeDrop) {
        try {
            ITableComponent adapter = (ITableComponent)this.getComponent();
            int implRow = adapter.getRowFromString(row, rowOperator);
            int implCol = adapter.getColumnFromString(value, regex);
            TableCell<?, ?> targetCell = this.getCellAt(implRow + 1, implCol + 1);
            if (targetCell == null) {
                throw new StepExecutionException("Drop target not visible", EventFactory.createActionError((String)"TestErrorEvent.NotVisible"));
            }
            super.rcDropCellByColValue(row, rowOperator, value, regex, searchType, delayBeforeDrop);
        }
        finally {
            Node table = (Node)this.getRealComponent();
            table.removeEventFilter(ScrollToEvent.ANY, this.m_scrollConsumer);
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            dndHelper.setDragMode(false);
        }
    }

    protected Object setEditorToReplaceMode(Object editor, boolean replace) {
        Object returnvalue = editor;
        if (replace) {
            this.getRobot().clickAtCurrentPosition(editor, 3, 1);
        } else {
            returnvalue = this.getComponent().getRealComponent();
        }
        return returnvalue;
    }

    protected Object activateEditor(Cell cell, Rectangle rectangle) {
        Object table = this.getComponent().getRealComponent();
        this.getRobot().click(table, (Object)rectangle);
        TableCell<?, ?> realCell = this.getCellAt(cell.getRow(), cell.getCol());
        if (realCell.isEditing()) {
            ClickOptions co = ClickOptions.create().setClickCount(2);
            this.getRobot().click(table, (Object)rectangle, co);
        }
        return realCell;
    }

    private TableCell<?, ?> getCellAt(final int row, final int column) {
        TableCell result = (TableCell)EventThreadQueuerJavaFXImpl.invokeAndWait("getCellText", new Callable<TableCell<?, ?>>(){

            @Override
            public TableCell<?, ?> call() throws Exception {
                TableView table = (TableView)TableTester.this.getRealComponent();
                table.scrollTo(row);
                table.scrollToColumnIndex(column);
                table.layout();
                TableColumn col = table.getVisibleLeafColumn(column);
                List<TableCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)table, TableCell.class);
                for (TableCell cell : tCells) {
                    if (cell.getIndex() != row || cell.getTableColumn() != col || !NodeTraverseHelper.isVisible((Node)cell)) continue;
                    return cell;
                }
                return null;
            }
        });
        return result;
    }

    protected int getExtendSelectionModifier() {
        return 17;
    }

    protected Cell getCellAtMousePosition() throws StepExecutionException {
        final Point p = this.getRobot().getCurrentMousePosition();
        Cell result = EventThreadQueuerJavaFXImpl.invokeAndWait("getCellAtMousePosition", new Callable<Cell>(){

            @Override
            public Cell call() throws Exception {
                TableView table = (TableView)TableTester.this.getRealComponent();
                table.requestLayout();
                table.layout();
                List<TableCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)table, TableCell.class);
                for (TableCell cell : tCells) {
                    if (!NodeBounds.checkIfContains(new Point2D((double)p.x, (double)p.y), (Node)cell) || !cell.getTableView().equals(table) || !NodeTraverseHelper.isVisible((Node)cell)) continue;
                    TableColumn cellColumn = cell.getTableColumn();
                    int col = table.getVisibleLeafIndex(cellColumn);
                    return new Cell(cell.getIndex(), col);
                }
                return null;
            }
        });
        return result;
    }

    private String getColumnPath(TableColumnBase column, TableView table) {
        String colPath = "";
        TableColumnBase nxtColumn = column;
        while (nxtColumn.getParentColumn() != null) {
            colPath = String.valueOf('/').concat(String.valueOf(String.valueOf(nxtColumn.getParentColumn().getColumns().indexOf((Object)nxtColumn) + 1) + colPath));
            nxtColumn = nxtColumn.getParentColumn();
        }
        colPath = String.valueOf(table.getColumns().indexOf((Object)nxtColumn) + 1) + colPath;
        return colPath;
    }

    protected boolean isMouseOnHeader() {
        Point p = this.getRobot().getCurrentMousePosition();
        final Point2D pos = new Point2D((double)p.x, (double)p.y);
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("getTableHeader", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TableView table = (TableView)TableTester.this.getRealComponent();
                table.layout();
                Parent header = (Parent)table.lookup(TableHeaderRow.class.getSimpleName());
                return NodeBounds.checkIfContains(pos, (Node)header);
            }
        });
        return result;
    }

    public void rcToggleCheckboxInSelectedRow() {
        int row = EventThreadQueuerJavaFXImpl.invokeAndWait("rcToggleCheckboxInSelectedRow", new Callable<Integer>(){

            @Override
            public Integer call() throws StepExecutionException {
                TableView table = (TableView)TableTester.this.getRealComponent();
                return new Integer(table.getSelectionModel().getSelectedIndex());
            }
        });
        int column = this.getIndexOfColumnWithCheckbox(row);
        this.clickCheckBox(row, column);
    }

    private int getIndexOfColumnWithCheckbox(int row) {
        int columnCount = EventThreadQueuerJavaFXImpl.invokeAndWait("rcToggleCheckboxInSelectedRow", new Callable<Integer>(){

            @Override
            public Integer call() throws StepExecutionException {
                TableView table = (TableView)TableTester.this.getRealComponent();
                return new Integer(table.getColumns().size());
            }
        });
        HashMap<Node, Integer> possibleCheckBoxes = new HashMap<Node, Integer>();
        int column = 0;
        while (column < columnCount) {
            Node checkBox = this.getCheckBox(row, column);
            if (checkBox != null) {
                possibleCheckBoxes.put(checkBox, column);
            }
            ++column;
        }
        switch (possibleCheckBoxes.size()) {
            case 0: {
                throw new StepExecutionException("No checkbox found in selected row", EventFactory.createActionError((String)"TestErrorEvent.CheckboxNotFound"));
            }
            case 1: {
                return (Integer)possibleCheckBoxes.values().iterator().next();
            }
        }
        throw new StepExecutionException("Multiple checkboxes found in selected row", EventFactory.createActionError((String)"TestErrorEvent.CheckboxNotUnique"));
    }

    public void rcToggleCheckboxInRowAtMousePosition() {
        Cell cell = this.getCellAtMousePosition();
        this.clickCheckBox(cell.getRow(), cell.getCol());
    }

    public void rcVerifyCheckboxInSelectedRow(final boolean checked, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyCheckboxInSelectedRow", (long)timeout, (Runnable)new Runnable(){

            @Override
            public void run() {
                Cell selectedCell = ((ITableComponent)TableTester.this.getComponent()).getSelectedCell();
                int row = selectedCell.getRow();
                int column = TableTester.this.getIndexOfColumnWithCheckbox(row);
                TableTester.this.verifyCheckboxInRow(checked, row, column);
            }
        });
    }

    public void rcVerifyCheckboxInRowAtMousePosition(final boolean checked, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyCheckboxInRowAtMousePosition", (long)timeout, (Runnable)new Runnable(){

            @Override
            public void run() {
                Cell cell = TableTester.this.getCellAtMousePosition();
                if (cell == null) {
                    throw new StepExecutionException("No checkbox found", EventFactory.createActionError((String)"TestErrorEvent.CheckboxNotFound"));
                }
                int row = cell.getRow();
                int column = cell.getCol();
                TableTester.this.verifyCheckboxInRow(checked, row, column);
            }
        });
    }

    private void clickCheckBox(int row, int column) {
        Node box = this.getCheckBox(row, column);
        if (box == null) {
            throw new StepExecutionException("No checkbox found", EventFactory.createActionError((String)"TestErrorEvent.CheckboxNotFound"));
        }
        this.getRobot().click((Object)box, null, ClickOptions.create().setClickCount(1).setMouseButton(1));
    }

    private void verifyCheckboxInRow(boolean checked, int row, int column) {
        final CheckBox box = (CheckBox)this.getCheckBox(row, column);
        Boolean checkIndex = EventThreadQueuerJavaFXImpl.invokeAndWait("verifyCheckboxInRow", new Callable<Boolean>(){

            @Override
            public Boolean call() throws StepExecutionException {
                if (box == null) {
                    throw new StepExecutionException("No checkbox found", EventFactory.createActionError((String)"TestErrorEvent.CheckboxNotFound"));
                }
                return box.isSelected();
            }
        });
        Verifier.equals((boolean)checked, (boolean)checkIndex);
    }

    private Node getCheckBox(final int row, final int column) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("clickCheckBoxFirstColumn", new Callable<Node>(){

            @Override
            public Node call() throws Exception {
                TableView table = (TableView)TableTester.this.getRealComponent();
                table.layout();
                TableColumn col = table.getVisibleLeafColumn(column);
                List<CheckBoxTableCell> checkboxCells = NodeTraverseHelper.getInstancesOf((Parent)table, CheckBoxTableCell.class);
                for (CheckBoxTableCell cell : checkboxCells) {
                    if (!cell.getTableColumn().equals(col) || cell.getIndex() != row || !NodeTraverseHelper.isVisible((Node)cell)) continue;
                    return cell.lookup(CheckBox.class.getSimpleName());
                }
                List<TableCell> cells = NodeTraverseHelper.getInstancesOf((Parent)table, TableCell.class);
                for (TableCell cell : cells) {
                    if (!cell.getTableColumn().equals(col) || cell.getIndex() != row || !NodeTraverseHelper.isVisible((Node)cell)) continue;
                    return cell.lookup(CheckBox.class.getSimpleName());
                }
                return null;
            }
        });
    }

    public void rcVerifyValueInRow(final String row, final String rowOperator, final String value, final String operator, final String searchType, final boolean exists, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyValueInRow", (long)timeout, (Runnable)new Runnable(){

            @Override
            public void run() {
                final ITableComponent adapter = (ITableComponent)TableTester.this.getComponent();
                final int implRow = adapter.getRowFromString(row, rowOperator);
                boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("rcVerifyValueInRow", new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        boolean valueIsExisting = false;
                        valueIsExisting = implRow == -1 ? TableTester.this.getColumnByName(value, operator, searchType, adapter, implRow) != null : TableTester.this.getColumnByValue(value, operator, searchType, adapter, implRow) != null;
                        return valueIsExisting;
                    }
                });
                Verifier.equals((boolean)exists, (boolean)result);
            }
        });
    }

    private String getColumnByName(final String name, final String operator, final String searchType, final ITableComponent adapter, int implRow) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnByName", new Callable<String>(){

            @Override
            public String call() throws Exception {
                int columnCount = adapter.getColumnCount();
                if (columnCount > 0) {
                    List columns = TableTester.this.getColumnsFromTable(searchType, adapter);
                    for (TableColumn column : columns) {
                        if (!MatchUtil.getInstance().match(column.getText(), name, operator)) continue;
                        return TableTester.this.getColumnPath((TableColumnBase)column, (TableView)TableTester.this.getRealComponent());
                    }
                }
                return null;
            }
        });
    }

    private List<TableColumn> getColumnsFromTable(String searchType, ITableComponent adapter) {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        if (searchType.equalsIgnoreCase(ValueSets.SearchType.relative.rcValue())) {
            TableView table = (TableView)adapter.getRealComponent();
            TableColumn selColumn = ((TablePosition)table.getSelectionModel().getSelectedCells().get(0)).getTableColumn();
            TableColumnBase parCol = selColumn.getParentColumn();
            while (parCol != null) {
                selColumn = (TableColumn)parCol;
                parCol = parCol.getParentColumn();
            }
            columns.addAll(new GenericTraverseHelper<TableColumn, TableColumn>().getInstancesOf(new AbstractTraverser<TableColumn, TableColumn>(selColumn){

                @Override
                public Iterable<TableColumn> getTraversableData() {
                    return ((TableColumn)this.getObject()).getColumns();
                }
            }, TableColumn.class));
        } else {
            for (TableColumn column : ((TableView)this.getRealComponent()).getColumns()) {
                columns.addAll(new GenericTraverseHelper<TableColumn, TableColumn>().getInstancesOf(new AbstractTraverser<TableColumn, TableColumn>(column){

                    @Override
                    public Iterable<TableColumn> getTraversableData() {
                        return ((TableColumn)this.getObject()).getColumns();
                    }
                }, TableColumn.class));
            }
            columns.addAll((Collection<TableColumn>)((TableView)adapter.getRealComponent()).getColumns());
        }
        return columns;
    }

    private String getColumnByValue(final String value, final String operator, final String searchType, final ITableComponent adapter, final int implRow) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnByValue", new Callable<String>(){

            @Override
            public String call() {
                int columnCount = adapter.getColumnCount();
                if (columnCount > 0) {
                    int startIndex = TableTester.this.getStartingColIndex(searchType) - 1;
                    ObservableList columns = ((TableView)TableTester.this.getRealComponent()).getVisibleLeafColumns();
                    int i = startIndex;
                    while (i < columns.size()) {
                        TableColumn column = (TableColumn)columns.get(i);
                        int index = adapter.getColumnFromString(TableTester.this.getColumnPath((TableColumnBase)column, (TableView)TableTester.this.getRealComponent()), "equals");
                        String cellValue = adapter.getCellText(implRow, index);
                        if (MatchUtil.getInstance().match(cellValue, value, operator)) {
                            return TableTester.this.getColumnPath((TableColumnBase)column, (TableView)TableTester.this.getRealComponent());
                        }
                        ++i;
                    }
                }
                return null;
            }
        });
    }

    public void rcSelectCellByColValue(String row, String rowOperator, final String value, final String operator, int clickCount, String extendSelection, final String searchType, int button) {
        final ITableComponent adapter = (ITableComponent)this.getComponent();
        final int implRow = adapter.getRowFromString(row, rowOperator);
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("rcSelectCellByColValue", new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (implRow == -1) {
                    return TableTester.this.getColumnByName(value, operator, searchType, adapter, implRow);
                }
                return TableTester.this.getColumnByValue(value, operator, searchType, adapter, implRow);
            }
        });
        if (result == null) {
            throw new StepExecutionException("no such cell found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.rcSelectCell(row, rowOperator, result, operator, clickCount, 50, ValueSets.Unit.percent.rcValue(), 50, ValueSets.Unit.percent.rcValue(), extendSelection, button);
    }

    private int getStartingColIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase(ValueSets.SearchType.relative.rcValue())) {
            Cell c = ((ITableComponent)this.getComponent()).getSelectedCell();
            if (c == null) {
                throw new StepExecutionException("No selection found", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
            }
            startingIndex = c.getCol();
        }
        return startingIndex + 1;
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        Point awtPoint = this.getRobot().getCurrentMousePosition();
        final Point2D point = new Point2D((double)awtPoint.x, (double)awtPoint.y);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getNodeAtMousePosition", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ((TableView)TableTester.this.getRealComponent()).layout();
                List<TableCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)TableTester.this.getRealComponent(), TableCell.class);
                for (TableCell cell : tCells) {
                    if (!NodeBounds.checkIfContains(point, (Node)cell)) continue;
                    return cell;
                }
                throw new StepExecutionException("No table node found at mouse position: X: " + point.getX() + "Y: " + point.getY(), EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
        return result;
    }
}

