/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the ReflectionComponentActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2017-03-14T07:48:30.784Z")
@Beta
public interface ReflectionComponentActionHandler {
    
    
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public void invokeMethodStoreReturnValue(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @since 4.1
         */
        public void invokeMethodStoreReturnValue(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator
        ) ;
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public void invokeMethod(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @since 4.1
         */
        public void invokeMethod(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator
        ) ;
        
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public void invokeExternalMethodStoreReturnValue(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @since 4.1
         */
        public void invokeExternalMethodStoreReturnValue(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator
        ) ;
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public void invokeExternalMethod(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @since 4.1
         */
        public void invokeExternalMethod(
            @Nullable String fullyQualifiedClassName,
            @Nullable String methodName,
            @Nullable String methodSignature,
            @Nullable String methodArguments,
            @Nullable String methodArgumentSeparator
        ) ;
        
} 