/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the SliderComponent component from the concrete toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2017-03-14T07:48:30.789Z")
public class SliderComponent extends org.eclipse.jubula.toolkit.base.internal.impl.GraphicsComponent implements org.eclipse.jubula.toolkit.concrete.components.SliderComponent {
            public SliderComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param position 
         *        the position to use
         * @param operator 
         *        the operator used for comparison
         * @param measure 
         *        the way to measure a unit
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkPosition(@NonNull String position,@NonNull Operator operator,@NonNull Measure measure,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(position, "Argument 'position' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(measure, "Argument 'measure' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyPosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(position)
                        .addParameter(operator.rcValue())
                        .addParameter(measure.rcValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param position 
         *        the position to use
         * @param operator 
         *        the operator used for comparison
         * @param measure 
         *        the way to measure a unit
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkPosition(@NonNull String position,@NonNull Operator operator,@NonNull Measure measure
        ) throws IllegalArgumentException {
            Validate.notNull(position, "Argument 'position' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(measure, "Argument 'measure' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyPosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(position)
                        .addParameter(operator.rcValue())
                        .addParameter(measure.rcValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param position 
         *        the position to use
         * @param operator 
         *        the operator used for comparison
         * @param measure 
         *        the way to measure a unit
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectPosition(@NonNull String position,@NonNull Operator operator,@NonNull Measure measure
        ) throws IllegalArgumentException {
            Validate.notNull(position, "Argument 'position' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(measure, "Argument 'measure' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectPosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(position)
                        .addParameter(operator.rcValue())
                        .addParameter(measure.rcValue())
                        .build();
        }
        
} 