/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.converter.json;

import java.util.List;
import org.eclipse.jubula.client.archive.converter.utils.AbstractConverter;
import org.eclipse.jubula.client.archive.dto.CapDTO;
import org.eclipse.jubula.client.archive.dto.CategoryDTO;
import org.eclipse.jubula.client.archive.dto.DataRowDTO;
import org.eclipse.jubula.client.archive.dto.ExportInfoDTO;
import org.eclipse.jubula.client.archive.dto.NodeDTO;
import org.eclipse.jubula.client.archive.dto.ParamDescriptionDTO;
import org.eclipse.jubula.client.archive.dto.ProjectDTO;
import org.eclipse.jubula.client.archive.dto.TestCaseDTO;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;

public class AddTimeoutToCAPConverter
extends AbstractConverter<ProjectDTO> {
    private ExportInfoDTO m_exportInfo = null;

    public AddTimeoutToCAPConverter(ExportInfoDTO exportInfo) {
        this.m_exportInfo = exportInfo;
    }

    @Override
    protected boolean conversionIsNecessary(ProjectDTO project) {
        return this.m_exportInfo != null && this.m_exportInfo.getMajorVersion() == 1 && this.m_exportInfo.getMinorVersion() == 0 && this.m_exportInfo.getMicroVersion() == 0;
    }

    @Override
    protected void convertImpl(ProjectDTO project) {
        List<NodeDTO> categories = project.getCategories();
        for (NodeDTO nodeDTO : categories) {
            this.convertNodes(nodeDTO);
        }
    }

    private void convertNodes(NodeDTO node) {
        block3: {
            block2: {
                if (!(node instanceof TestCaseDTO)) break block2;
                List<NodeDTO> testSteps = ((TestCaseDTO)node).getTestSteps();
                for (NodeDTO nodeDTO : testSteps) {
                    Param capParam;
                    if (!(nodeDTO instanceof CapDTO)) continue;
                    CapDTO cap = (CapDTO)nodeDTO;
                    cap.getComponentName();
                    CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
                    Component component = compSystem.findComponent(cap.getComponentType());
                    Action action = component.findAction(cap.getActionName());
                    if (action.getParamsSize() <= cap.getParameterDescription().size() || !(capParam = (Param)action.getParams().get(action.getParams().size() - 1)).getName().equals("CompSystem.Timeout")) continue;
                    this.addMissingParamToCap(cap, capParam);
                }
                break block3;
            }
            if (!(node instanceof CategoryDTO)) break block3;
            CategoryDTO cat = (CategoryDTO)node;
            List<NodeDTO> nodeList = cat.getNodes();
            for (NodeDTO nodeDTO : nodeList) {
                this.convertNodes(nodeDTO);
            }
        }
    }

    private void addMissingParamToCap(CapDTO cap, Param capParam) {
        ParamDescriptionDTO paramdesc = new ParamDescriptionDTO();
        paramdesc.setType(capParam.getType());
        paramdesc.setName(capParam.getName());
        paramdesc.setUuid(capParam.getName());
        cap.getParameterDescription().add(paramdesc);
        new DataRowDTO();
        cap.getTDManager().getDataSets().get(0).getColumns().add(capParam.getDefaultValue());
        cap.getTDManager().getUniqueIds().add(capParam.getName());
    }
}

