/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.converter.json;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.archive.converter.utils.AbstractConverter;
import org.eclipse.jubula.client.archive.dto.CapDTO;
import org.eclipse.jubula.client.archive.dto.CategoryDTO;
import org.eclipse.jubula.client.archive.dto.ExportInfoDTO;
import org.eclipse.jubula.client.archive.dto.NodeDTO;
import org.eclipse.jubula.client.archive.dto.ProjectDTO;
import org.eclipse.jubula.client.archive.dto.TestCaseDTO;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.InvalidAction;

public class RemoveDoubledUniqueIds
extends AbstractConverter<ProjectDTO> {
    private ExportInfoDTO m_exportInfo = null;

    public RemoveDoubledUniqueIds(ExportInfoDTO exportInfo) {
        this.m_exportInfo = exportInfo;
    }

    @Override
    protected boolean conversionIsNecessary(ProjectDTO project) {
        return this.m_exportInfo != null && this.m_exportInfo.getMajorVersion() == 1 && this.m_exportInfo.getMinorVersion() == 0 && this.m_exportInfo.getMicroVersion() == 0;
    }

    @Override
    protected void convertImpl(ProjectDTO project) {
        List<NodeDTO> categories = project.getCategories();
        for (NodeDTO nodeDTO : categories) {
            this.convertNodes(nodeDTO);
        }
    }

    private void convertNodes(NodeDTO node) {
        block5: {
            block4: {
                if (!(node instanceof TestCaseDTO)) break block4;
                List<NodeDTO> testSteps = ((TestCaseDTO)node).getTestSteps();
                for (NodeDTO nodeDTO : testSteps) {
                    if (!(nodeDTO instanceof CapDTO)) continue;
                    CapDTO cap = (CapDTO)nodeDTO;
                    cap.getComponentName();
                    CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
                    Component component = compSystem.findComponent(cap.getComponentType());
                    Action action = component.findAction(cap.getActionName());
                    List<String> uniqueIds = cap.getTDManager().getUniqueIds();
                    int uniqueIdSize = uniqueIds.size();
                    if (action instanceof InvalidAction || uniqueIdSize <= action.getParamsSize()) continue;
                    List<String> end = uniqueIds.subList(uniqueIdSize / 2, uniqueIdSize);
                    end = new ArrayList<String>(end);
                    boolean allTheSame = true;
                    int i = 0;
                    while (i < uniqueIdSize / 2) {
                        if (!uniqueIds.get(i).equals(end.get(i))) {
                            allTheSame = false;
                        }
                        ++i;
                    }
                    if (!allTheSame) continue;
                    cap.getTDManager().getUniqueIds().clear();
                    cap.getTDManager().getUniqueIds().addAll(end);
                }
                break block5;
            }
            if (!(node instanceof CategoryDTO)) break block5;
            CategoryDTO cat = (CategoryDTO)node;
            List<NodeDTO> nodeList = cat.getNodes();
            for (NodeDTO nodeDTO : nodeList) {
                this.convertNodes(nodeDTO);
            }
        }
    }
}

