/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IModifiableParameterInterfacePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.utils.ComboParamValidator;
import org.eclipse.jubula.client.core.utils.GuiParamValueConverter;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.IntegerParamValueValidator;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.NullValidator;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.client.core.utils.VariableParamValueValidator;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;

public abstract class AbstractParamInterfaceBP<T> {
    public void addDataSet(IParameterInterfacePO obj, int row) {
        ISpecTestCasePO spec = null;
        ITDManager dataManager = null;
        ArrayList<String> list = new ArrayList<String>();
        if (obj instanceof IExecTestCasePO) {
            IExecTestCasePO exec = (IExecTestCasePO)obj;
            spec = exec.getSpecTestCase();
            dataManager = exec.getDataManager();
        } else if (obj instanceof ISpecTestCasePO) {
            spec = (ISpecTestCasePO)obj;
            dataManager = spec.getDataManager();
        }
        if (dataManager != null && spec != null) {
            List<String> uniqueIds = dataManager.getUniqueIds();
            int i = 0;
            while (i < uniqueIds.size()) {
                String uuid = uniqueIds.get(i);
                IParamDescriptionPO uniqueID = obj.getParameterForUniqueId(uuid);
                String value = AbstractParamInterfaceBP.getValueForSpecNodeWithParamDesc(uniqueID, spec);
                list.add(value);
                ++i;
            }
        }
        if (list.size() > 0) {
            IDataSetPO dataSet = PoMaker.createListWrapperPO(list);
            obj.getDataManager().insertDataSet(dataSet, row);
        } else {
            obj.getDataManager().insertDataSet(row);
        }
    }

    public void removeDataSet(IParameterInterfacePO paramNode, int row, IParamNameMapper mapper) {
        int colCount = paramNode.getDataManager().getColumnCount();
        int i = 0;
        while (i < colCount) {
            String uniqueId = paramNode.getDataManager().getUniqueIds().get(i);
            IParamDescriptionPO desc = paramNode.getParameterForUniqueId(uniqueId);
            if (desc != null) {
                GuiParamValueConverter conv = new GuiParamValueConverter(null, paramNode, desc, AbstractParamInterfaceBP.createParamValueValidator(desc.getType(), false, new String[0]));
                this.startParameterUpdate(conv, row, mapper);
            }
            ++i;
        }
        paramNode.getDataManager().removeDataSet(row);
    }

    public void startParameterUpdate(GuiParamValueConverter conv, int row, IParamNameMapper mapper) {
        IParameterInterfacePO paramNode = conv.getCurrentNode();
        IParamDescriptionPO paramDescription = conv.getDesc();
        String paramGuid = paramDescription.getUniqueId();
        if (paramNode.getParameterList().contains(conv.getDesc()) && !paramNode.getDataManager().getUniqueIds().contains(paramGuid)) {
            paramNode.getDataManager().addUniqueId(paramGuid);
        }
        try {
            String value = paramNode.getDataManager().getCell(row, paramDescription);
            String modelString = conv.getModelString();
            if (modelString != null && modelString.equals(value)) {
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        this.updateParam(conv, mapper, row);
    }

    public static String getGuiStringForParamValue(IParameterInterfacePO node, IParamDescriptionPO desc, int rowCount) {
        String result = "";
        IParameterInterfacePO srcNode = node;
        IParamDescriptionPO srcDesc = desc;
        while (srcNode.getReferencedDataCube() != null) {
            srcDesc = (srcNode = srcNode.getReferencedDataCube()).getParameterForName(srcDesc.getName());
            if (srcDesc != null && desc.getType().equals(srcDesc.getType())) continue;
            return result;
        }
        if (srcDesc == null) {
            return result;
        }
        int col = srcNode.getDataManager().findColumnForParam(srcDesc.getUniqueId());
        boolean colNotExistend = false;
        boolean foundCol = false;
        int dataSetCount = srcNode.getDataManager().getDataSetCount();
        if (col > -1 && dataSetCount > rowCount) {
            IDataSetPO row = srcNode.getDataManager().getDataSet(rowCount);
            try {
                String td = row.getValueAt(col);
                ModelParamValueConverter conv = new ModelParamValueConverter(td, srcNode, srcDesc);
                result = ((ParamValueConverter)conv).getGuiString();
                foundCol = true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                colNotExistend = true;
            }
        }
        if ((col == -1 || colNotExistend || dataSetCount <= srcNode.getParameterListSize() && StringUtils.isBlank((String)result) && !foundCol) && srcNode instanceof IExecTestCasePO) {
            INodePO specNode = srcNode.getSpecificationUser();
            specNode = ((IExecTestCasePO)srcNode).getSpecTestCase();
            if (specNode instanceof ISpecTestCasePO) {
                result = AbstractParamInterfaceBP.getValueForSpecNodeWithParamDesc(srcDesc, (ISpecTestCasePO)specNode);
            }
        }
        return result;
    }

    public static String getValueForSpecNodeWithParamDesc(IParamDescriptionPO srcDesc, ISpecTestCasePO specNode) {
        ICapPO cap;
        List<IDataSetPO> datasets;
        INodePO possibleCap;
        List<INodePO> list = specNode.getUnmodifiableNodeList();
        if (list.size() == 1 && (possibleCap = list.get(0)) instanceof ICapPO && (datasets = (cap = (ICapPO)possibleCap).getDataManager().getDataSets()).size() == 1) {
            IDataSetPO set = datasets.get(0);
            int i = 0;
            for (String string : set.getColumnStringValues()) {
                if (StringUtils.contains((String)string, (String)srcDesc.getUniqueId())) {
                    return AbstractParamInterfaceBP.getDefaultValue(cap, i);
                }
                ++i;
            }
        }
        return null;
    }

    private static String getDefaultValue(ICapPO cap, int index) {
        String defaultValue;
        List paramList = cap.getMetaAction().getParams();
        if (paramList.size() > index && StringUtils.isNotBlank((String)(defaultValue = ((Param)paramList.get(index)).getDefaultValue()))) {
            return defaultValue;
        }
        return null;
    }

    protected abstract void updateParam(GuiParamValueConverter var1, IParamNameMapper var2, int var3);

    protected void writeTestDataEntry(GuiParamValueConverter conv, int dataSetRow) {
        String oldTd = null;
        IParamDescriptionPO desc = conv.getDesc();
        IParameterInterfacePO currentNode = conv.getCurrentNode();
        ITDManager dataManager = currentNode.getDataManager();
        try {
            oldTd = dataManager.getCell(dataSetRow, desc);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        String td = this.createOrUpdateTestData(oldTd, conv);
        if (dataManager.getDataSetCount() <= dataSetRow) {
            this.addDataSet(currentNode, dataSetRow);
        }
        dataManager.updateCell(td, dataSetRow, desc.getUniqueId());
    }

    private String createOrUpdateTestData(String testData, GuiParamValueConverter conv) {
        GuiParamValueConverter newConv = new GuiParamValueConverter(conv.getGuiString(), conv.getCurrentNode(), conv.getDesc(), AbstractParamInterfaceBP.createParamValueValidator("java.lang.String", false, new String[0]));
        return newConv.getModelString();
    }

    public void addParameter(String name, String type, IModifiableParameterInterfacePO obj, IParamNameMapper mapper) {
        obj.addParameter(type, name, mapper);
    }

    public abstract void removeParameter(IParamDescriptionPO var1, T var2);

    public abstract void changeUsageParameter(T var1, IParamDescriptionPO var2, String var3, ParamNameBPDecorator var4);

    public void renameParameters(IParamDescriptionPO desc, String newName, ParamNameBPDecorator mapper) {
        mapper.addNameToUpdate(desc.getUniqueId(), newName);
    }

    public static IParamValueValidator createParamValueValidator(String type, boolean valuesAreCombinable, String ... values) {
        if ("java.lang.Integer".equals(type)) {
            return new IntegerParamValueValidator(Integer.MIN_VALUE, Integer.MAX_VALUE, values);
        }
        if ("guidancer.datatype.Variable".equals(type)) {
            return new VariableParamValueValidator();
        }
        if ("java.lang.String".equals(type)) {
            return new NullValidator();
        }
        if ("Combo".equals(type) || "java.lang.Boolean".equals(type)) {
            return new ComboParamValidator(values, valuesAreCombinable);
        }
        return new NullValidator();
    }
}

