/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jubula.client.core.model.IControllerPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverserContext;
import org.eclipse.jubula.tools.internal.exception.JBException;

public class TreeTraverser {
    public static final int NO_DEPTH_LIMIT = -1;
    private List<ITreeNodeOperation<INodePO>> m_operations = new ArrayList<ITreeNodeOperation<INodePO>>();
    private INodePO m_rootNode;
    private boolean m_traverseEventHandlers = false;
    private boolean m_traverseSpecPart = false;
    private boolean m_traverseExecPart = true;
    private boolean m_traverseReused = true;
    private int m_maxDepth = -1;
    private Set<String> m_visited = new HashSet<String>(1001);
    private IProgressMonitor m_monitor;

    public TreeTraverser(INodePO rootNode) {
        this.m_rootNode = rootNode;
        this.setMonitor((IProgressMonitor)new NullProgressMonitor());
    }

    public TreeTraverser(INodePO rootNode, ITreeNodeOperation<INodePO> operation) {
        this(rootNode);
        this.m_operations.add(operation);
    }

    public TreeTraverser(INodePO rootNode, ITreeNodeOperation<INodePO> operation, boolean traverseSpecPart) {
        this(rootNode, operation, traverseSpecPart, !traverseSpecPart);
    }

    public TreeTraverser(INodePO rootNode, ITreeNodeOperation<INodePO> operation, boolean traverseSpecPart, boolean traverseExecPart) {
        this(rootNode);
        this.m_operations.add(operation);
        this.m_traverseSpecPart = traverseSpecPart;
        this.m_traverseExecPart = traverseExecPart;
    }

    public TreeTraverser(INodePO rootNode, ITreeNodeOperation<INodePO> operation, boolean traverseSpecPart, int maxTraversalDepth) {
        this(rootNode, operation, traverseSpecPart, !traverseSpecPart);
        this.m_maxDepth = maxTraversalDepth;
    }

    /*
     * WARNING - void declaration
     */
    protected void traverseImpl(ITreeTraverserContext<INodePO> context, INodePO parent, INodePO node) {
        if (this.m_maxDepth == -1 && !this.getMonitor().isCanceled() || this.m_maxDepth > context.getCurrentTreePath().size()) {
            context.append(node);
            boolean alreadyVisited = this.alreadyVisited(node);
            HashSet<ITreeNodeOperation<INodePO>> suspendedOps = null;
            for (ITreeNodeOperation<INodePO> iTreeNodeOperation : this.m_operations) {
                boolean continueWork = iTreeNodeOperation.operate(context, parent, node, alreadyVisited);
                if (continueWork) continue;
                if (suspendedOps == null) {
                    suspendedOps = new HashSet<ITreeNodeOperation<INodePO>>(this.m_operations.size());
                }
                suspendedOps.add(iTreeNodeOperation);
            }
            if (suspendedOps != null) {
                this.m_operations.removeAll(suspendedOps);
            }
            this.addToVisited(node);
            if (context.isContinue() && !this.m_operations.isEmpty()) {
                if (node instanceof IProjectPO) {
                    IProjectPO iProjectPO = (IProjectPO)node;
                    this.traverseProject(context, iProjectPO);
                } else {
                    Iterator<INodePO> iterator = node.getNodeListIterator();
                    while (iterator.hasNext()) {
                        this.traverseImpl(context, node, iterator.next());
                    }
                    if (node instanceof IControllerPO) {
                        for (INodePO iNodePO : node.getUnmodifiableNodeList()) {
                            this.traverseImpl(context, node, iNodePO);
                        }
                    }
                    if (this.m_traverseEventHandlers && node instanceof ITestCasePO) {
                        void var6_14;
                        if (node instanceof IExecTestCasePO) {
                            ISpecTestCasePO iSpecTestCasePO = ((IExecTestCasePO)node).getSpecTestCase();
                        } else {
                            ISpecTestCasePO iSpecTestCasePO = (ISpecTestCasePO)node;
                        }
                        if (var6_14 != null) {
                            Iterator<IEventExecTestCasePO> it2 = var6_14.getAllEventEventExecTC().iterator();
                            while (it2.hasNext()) {
                                this.traverseImpl(context, node, it2.next());
                            }
                        }
                    }
                    for (ITreeNodeOperation iTreeNodeOperation : this.m_operations) {
                        iTreeNodeOperation.postOperate(context, parent, node, alreadyVisited);
                    }
                }
            }
            context.removeLast();
            if (suspendedOps != null) {
                this.m_operations.addAll(suspendedOps);
            }
        }
    }

    private void traverseProject(ITreeTraverserContext<INodePO> context, IProjectPO project) {
        if (this.m_traverseSpecPart) {
            this.traverseLocalSpecPart(context, project);
            if (this.m_traverseReused) {
                this.traverseReusedProjectSpecPart(context, project);
            }
        }
        if (this.m_traverseExecPart) {
            this.traverseExecPart(context, project);
        }
    }

    protected void traverseExecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
        for (IExecPersistable exec : project.getExecObjCont().getExecObjList()) {
            this.traverseImpl(context, project, exec);
        }
    }

    protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
        for (IReusedProjectPO reused : project.getUsedProjects()) {
            try {
                IProjectPO reusedProject = ProjectPM.loadReusedProjectInMasterSession(reused);
                if (reusedProject == null) continue;
                this.traverseLocalSpecPart(context, reusedProject);
            }
            catch (JBException jBException) {}
        }
    }

    protected void traverseLocalSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
        for (ISpecPersistable specNode : project.getSpecObjCont().getSpecObjList()) {
            this.traverseImpl(context, project, specNode);
        }
    }

    public void traverse() {
        this.traverse(false);
    }

    public void traverse(boolean traverseEventHandlers) {
        this.clearVisited();
        this.m_traverseEventHandlers = traverseEventHandlers;
        this.traverseImpl(new TreeTraverserContext<INodePO>(this.m_rootNode), null, this.m_rootNode);
    }

    protected List<ITreeNodeOperation<INodePO>> getOperations() {
        return this.m_operations;
    }

    public void addOperation(ITreeNodeOperation<INodePO> op) {
        this.m_operations.add(op);
    }

    private void addToVisited(INodePO node) {
        this.m_visited.add(node.getGuid());
    }

    private boolean alreadyVisited(INodePO node) {
        return this.m_visited.contains(node.getGuid());
    }

    private void clearVisited() {
        this.m_visited.clear();
    }

    public IProgressMonitor getMonitor() {
        return this.m_monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.m_monitor = monitor;
    }

    public void setTraverseReused(boolean reused) {
        this.m_traverseReused = reused;
    }
}

