/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.model.IAbstractContainerPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IControllerPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.AbstractEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TCEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.NodeTargetCalculator;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;

public class TSEditorDndSupport
extends AbstractEditorDndSupport {
    private INodePO m_last = null;

    public static boolean performDrop(AbstractTestCaseEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget, int dropPosition) {
        return TCEditorDndSupport.performDrop(targetEditor, toDrop, dropTarget, dropPosition);
    }

    public boolean copyPaste(AbstractTestCaseEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget) {
        if (targetEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return false;
        }
        Iterator it = toDrop.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof INodePO) continue;
            return false;
        }
        if (toDrop.isEmpty()) {
            return false;
        }
        NodeTargetCalculator.NodeTarget tar = NodeTargetCalculator.calcNodeTarget((INodePO)toDrop.getFirstElement(), dropTarget, 3, false);
        int warning = this.copyPasteNodes(tar.getNode(), toDrop.toList(), tar.getPos());
        if ((warning & 1) != 0) {
            MessageDialog.openInformation(null, (String)Messages.NotUseReferenceParameterTitle, (String)Messages.NotUseReferenceParameter);
        }
        if ((warning & 2) != 0) {
            MessageDialog.openInformation(null, (String)Messages.NotUsePropagatedComponentNameTitle, (String)Messages.NotUsePropagatedComponentName);
        }
        TSEditorDndSupport.postDropAction(this.m_last, targetEditor);
        return true;
    }

    private int copyPasteNodes(INodePO target, List<INodePO> nodes, int pos) {
        int position = pos;
        int msg = 0;
        for (INodePO node : nodes) {
            if (node instanceof IParamNodePO && ((IParamNodePO)node).getParamReferencesIterator().hasNext()) {
                msg |= 1;
            }
            if (node instanceof IExecTestCasePO) {
                msg |= this.copyPasteExecTestCase((IExecTestCasePO)node, target, position);
            } else if (node instanceof IControllerPO) {
                IControllerPO controller = NodeMaker.createControllerPO((IControllerPO)((IControllerPO)node));
                List nodeList = node.getUnmodifiableNodeList();
                List contList = controller.getUnmodifiableNodeList();
                if (node instanceof IParamNodePO) {
                    TSEditorDndSupport.fillParamNode((IParamNodePO)node, (IParamNodePO)controller, true);
                } else {
                    TSEditorDndSupport.fillNode(node, (INodePO)controller);
                }
                target.addNode(position, (INodePO)controller);
                int i = 0;
                while (i < nodeList.size()) {
                    this.copyPasteNodes((INodePO)contList.get(i), ((INodePO)nodeList.get(i)).getUnmodifiableNodeList(), 0);
                    ++i;
                }
            } else if (node instanceof ICommentPO) {
                ICommentPO comm = NodeMaker.createCommentPO((String)((ICommentPO)node).getName());
                TSEditorDndSupport.fillNode(node, (INodePO)comm);
                target.addNode(pos, (INodePO)comm);
                this.m_last = comm;
            }
            ++position;
        }
        return msg;
    }

    private static boolean checkCompName(IExecTestCasePO exec) {
        boolean was = false;
        for (ICompNamesPairPO origPair : exec.getCompNamesPairs()) {
            if (!origPair.isPropagated()) continue;
            origPair.setPropagated(false);
            was = true;
        }
        return was;
    }

    private int copyPasteExecTestCase(IExecTestCasePO execTestCase, INodePO targetNode, int dropPosition) {
        int msg = 0;
        IExecTestCasePO newExecTestCase = NodeMaker.createExecTestCasePO((ISpecTestCasePO)execTestCase.getSpecTestCase());
        this.m_last = newExecTestCase;
        TSEditorDndSupport.fillExec(execTestCase, newExecTestCase, true);
        if (TSEditorDndSupport.checkCompName(newExecTestCase)) {
            msg = 2;
        }
        TestCaseBP.addReferencedTestCase((INodePO)targetNode, (IExecTestCasePO)newExecTestCase, (Integer)dropPosition);
        return msg;
    }

    public static boolean validateCopy(IStructuredSelection toDrop, INodePO target) {
        if (toDrop == null || toDrop.isEmpty() || target == null) {
            return false;
        }
        for (Object next : toDrop) {
            if (next instanceof IExecTestCasePO || next instanceof ICommentPO || next instanceof IControllerPO) continue;
            return false;
        }
        return true;
    }

    public static boolean validateDrop(Viewer sourceViewer, Viewer targetViewer, IStructuredSelection selection, Object target, boolean allowFromBrowser) {
        if (selection == null || !(target instanceof INodePO)) {
            return false;
        }
        INodePO targNode = (INodePO)target;
        if (sourceViewer != null && !sourceViewer.equals(targetViewer)) {
            boolean foundOne = false;
            for (TestCaseBrowser tcb : MultipleTCBTracker.getInstance().getOpenTCBs()) {
                if (!sourceViewer.equals(tcb.getTreeViewer())) continue;
                foundOne = true;
            }
            if (!allowFromBrowser || !foundOne) {
                return false;
            }
        }
        for (Object next : selection) {
            if (!(next instanceof INodePO) || next instanceof IAbstractContainerPO) {
                return false;
            }
            if (next instanceof IControllerPO && !(targNode instanceof ITestSuitePO) && !(targNode.getParentNode() instanceof ITestSuitePO)) {
                return false;
            }
            INodePO node = (INodePO)next;
            if (node instanceof IExecTestCasePO && sourceViewer == targetViewer || node instanceof ICommentPO && sourceViewer == targetViewer || node instanceof ISpecTestCasePO || node instanceof IControllerPO) continue;
            return false;
        }
        return true;
    }
}

