/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TCBrowserDndSupport;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

public class TestSpecDropTargetListener
extends ViewerDropAdapter {
    public TestSpecDropTargetListener(TestCaseBrowser view) {
        super((Viewer)view.getTreeViewer());
        boolean scrollExpand = Plugin.getDefault().getPreferenceStore().getBoolean("TREEAUTOSCROLL_PREF_KEY");
        this.setScrollExpandEnabled(scrollExpand);
    }

    public boolean performDrop(Object data) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        IPersistentObject target = (IPersistentObject)this.getCurrentTarget();
        List nodesToBeMoved = transfer.getSelection().toList();
        if (!TCBrowserDndSupport.moveNodes(nodesToBeMoved, target)) {
            return false;
        }
        LocalSelectionTransfer.getInstance().setSelection(null);
        return true;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (LocalSelectionTransfer.getInstance().getSelection() == null) {
            return false;
        }
        if (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2) {
            return false;
        }
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        if (transfer.getSource() != null && !transfer.getSource().equals(this.getViewer())) {
            return false;
        }
        return TCBrowserDndSupport.canMove(transfer.getSelection(), target);
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        if (event.item != null && event.item.getData() instanceof ISpecTestCasePO) {
            event.feedback &= 0xFFFFFFEF;
        }
        if (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2) {
            event.feedback &= 0xFFFFFFEF;
        }
    }
}

