/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IControllerPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.TDCell;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.TransactionSupport;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.NativeSQLUtils;
import org.eclipse.jubula.client.core.utils.RefToken;
import org.eclipse.jubula.client.ui.rcp.actions.TransactionWrapper;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractRefactorHandler;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;

public class SaveAsNewTestCaseHandler
extends AbstractRefactorHandler {
    public Object executeImpl(ExecutionEvent event) {
        String newTestCaseName = this.getNewTestCaseName(event);
        if (newTestCaseName != null) {
            ISpecTestCasePO newSpecTC = null;
            IStructuredSelection ss = this.getSelection();
            ArrayList<INodePO> nodesToClone = new ArrayList<INodePO>(ss.size());
            Iterator it = ss.iterator();
            while (it.hasNext()) {
                nodesToClone.add((INodePO)it.next());
            }
            newSpecTC = this.createAndPerformNodeDuplication(newTestCaseName, nodesToClone);
            if (newSpecTC == null) {
                return null;
            }
            newSpecTC = (ISpecTestCasePO)GeneralStorage.getInstance().getMasterSession().find(newSpecTC.getClass(), (Object)newSpecTC.getId());
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newSpecTC, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
            TestCaseBrowser tcb = MultipleTCBTracker.getInstance().getMainTCB();
            if (tcb != null) {
                tcb.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)newSpecTC), true);
            }
        }
        return null;
    }

    private ISpecTestCasePO createAndPerformNodeDuplication(String newTestCaseName, List<INodePO> nodesToClone) {
        CloneTransaction op = new CloneTransaction(newTestCaseName, nodesToClone);
        if (TransactionWrapper.executeOperation(op)) {
            return op.getNewSpecTC();
        }
        return null;
    }

    private static class CloneTransaction
    implements TransactionSupport.ITransaction {
        private final String m_newTestCaseName;
        private final List<INodePO> m_nodesToClone;
        private ISpecTestCasePO m_newSpecTC = null;
        private IPersistentObject m_oldRoot = null;

        public CloneTransaction(String newTestCaseName, List<INodePO> nodesToClone) {
            this.m_newTestCaseName = newTestCaseName;
            this.m_nodesToClone = nodesToClone;
            this.m_oldRoot = this.m_nodesToClone.get(0).getSpecAncestor();
        }

        public void run(EntityManager s) throws PMException {
            ISpecTestCasePO newTc = NodeMaker.createSpecTestCasePO((String)this.m_newTestCaseName);
            ParamNameBPDecorator pMapper = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
            s.persist((Object)newTc);
            HashMap<String, String> oldToNewGuids = new HashMap<String, String>();
            for (INodePO node : this.m_nodesToClone) {
                this.addCloneToNode((INodePO)newTc, node, pMapper, oldToNewGuids, newTc);
            }
            SaveAsNewTestCaseHandler.registerParamNamesToSave(newTc, pMapper);
            s.merge((Object)newTc);
            pMapper.persist(s, GeneralStorage.getInstance().getProject().getId());
            NativeSQLUtils.addNodeAFFECTS((EntityManager)s, (INodePO)newTc, (IPersistentObject)GeneralStorage.getInstance().getProject().getSpecObjCont());
            this.setNewSpecTC(newTc);
        }

        private void addCloneToNode(INodePO addTo, INodePO nodeToCopy, ParamNameBPDecorator pMapper, Map<String, String> oldToNewGuids, ISpecTestCasePO specTC) throws PMException {
            IExecTestCasePO newNode = null;
            if (nodeToCopy instanceof IExecTestCasePO) {
                IExecTestCasePO origExec = (IExecTestCasePO)nodeToCopy;
                IExecTestCasePO newExec = NodeMaker.createExecTestCasePO((ISpecTestCasePO)origExec.getSpecTestCase());
                this.fillExec(origExec, newExec);
                newNode = newExec;
            } else if (nodeToCopy instanceof ICapPO) {
                ICapPO origCap = (ICapPO)nodeToCopy;
                ICapPO newCap = NodeMaker.createCapPO((String)origCap.getName(), (String)origCap.getComponentName(), (String)origCap.getComponentType(), (String)origCap.getActionName());
                this.fillCap(origCap, newCap);
                newNode = newCap;
            } else if (nodeToCopy instanceof ICommentPO) {
                ICommentPO origComment = (ICommentPO)nodeToCopy;
                ICommentPO newComment = NodeMaker.createCommentPO((String)origComment.getName());
                newNode = newComment;
            } else if (nodeToCopy instanceof IControllerPO) {
                newNode = NodeMaker.createControllerPO((IControllerPO)((IControllerPO)nodeToCopy));
                int i = 0;
                for (INodePO node : nodeToCopy.getUnmodifiableNodeList()) {
                    for (INodePO node2 : node.getUnmodifiableNodeList()) {
                        this.addCloneToNode((INodePO)newNode.getUnmodifiableNodeList().get(i), node2, pMapper, oldToNewGuids, specTC);
                    }
                }
            }
            if (newNode != null) {
                if (newNode instanceof IParamNodePO) {
                    this.addParamsToSpec(specTC, (IParamNodePO)newNode, pMapper, oldToNewGuids);
                }
                addTo.addNode((INodePO)newNode);
            }
        }

        private void addParamsToSpec(ISpecTestCasePO newSpecTC, IParamNodePO newParamChildNode, ParamNameBPDecorator pMapper, Map<String, String> oldToNewUuids) {
            TDCell cell = null;
            Iterator it = newParamChildNode.getParamReferencesIterator();
            while (it.hasNext()) {
                cell = (TDCell)it.next();
                String guid = (String)newParamChildNode.getDataManager().getUniqueIds().get(cell.getCol());
                IParamDescriptionPO childDesc = newParamChildNode.getParameterForUniqueId(guid);
                if (childDesc == null) continue;
                ModelParamValueConverter conv = new ModelParamValueConverter(cell.getTestData(), (IParameterInterfacePO)newParamChildNode, childDesc);
                List refTokens = conv.getRefTokens();
                for (RefToken refToken : refTokens) {
                    String oldUuid = RefToken.extractCore((String)refToken.getModelString());
                    String paramName = ParamNameBP.getInstance().getName(oldUuid, childDesc.getParentProjectId());
                    IParamDescriptionPO parentParamDescr = newSpecTC.addParameter(childDesc.getType(), paramName, false, (IParamNameMapper)pMapper);
                    if (parentParamDescr != null) {
                        String newUuid = parentParamDescr.getUniqueId();
                        oldToNewUuids.put(oldUuid, newUuid);
                    }
                    conv.replaceUuidsInReferences(oldToNewUuids);
                    cell.setTestData(conv.getModelString());
                }
            }
        }

        private void fillCap(ICapPO origCap, ICapPO newCap) {
            newCap.setActive(origCap.isActive());
            newCap.setComment(origCap.getComment());
            newCap.setGenerated(origCap.isGenerated());
            newCap.setToolkitLevel(origCap.getToolkitLevel());
            origCap.getDataManager().deepCopy(newCap.getDataManager());
        }

        private void fillExec(IExecTestCasePO origExec, IExecTestCasePO newExec) {
            newExec.setActive(origExec.isActive());
            newExec.setComment(origExec.getComment());
            newExec.setDataFile(origExec.getDataFile());
            newExec.setGenerated(origExec.isGenerated());
            ISpecTestCasePO origSpecTC = origExec.getSpecTestCase();
            if (!origExec.getName().equals(origSpecTC.getName())) {
                newExec.setName(origExec.getName());
            }
            newExec.setToolkitLevel(origExec.getToolkitLevel());
            if (!origExec.getDataManager().equals(origSpecTC.getDataManager())) {
                newExec.setHasReferencedTD(false);
                origExec.getDataManager().deepCopy(newExec.getDataManager());
            } else {
                newExec.setHasReferencedTD(true);
            }
            newExec.setReferencedDataCube(origExec.getReferencedDataCube());
            for (ICompNamesPairPO origPair : origExec.getCompNamesPairs()) {
                ICompNamesPairPO newPair = PoMaker.createCompNamesPairPO((String)origPair.getFirstName(), (String)origPair.getSecondName(), (String)origPair.getType());
                newPair.setPropagated(origPair.isPropagated());
                newExec.addCompNamesPair(newPair);
            }
        }

        public ISpecTestCasePO getNewSpecTC() {
            return this.m_newSpecTC;
        }

        public void setNewSpecTC(ISpecTestCasePO newSpecTC) {
            this.m_newSpecTC = newSpecTC;
        }

        public Collection<? extends IPersistentObject> getToLock() {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(GeneralStorage.getInstance().getProject().getSpecObjCont());
            list.add(this.m_oldRoot);
            return list;
        }

        public Collection<? extends IPersistentObject> getToRefresh() {
            ArrayList<ISpecObjContPO> list = new ArrayList<ISpecObjContPO>();
            list.add(GeneralStorage.getInstance().getProject().getSpecObjCont());
            return list;
        }

        public Collection<? extends IPersistentObject> getToMerge() {
            ArrayList<ISpecTestCasePO> toMerge = new ArrayList<ISpecTestCasePO>();
            toMerge.add(this.m_newSpecTC);
            return toMerge;
        }
    }
}

