/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.ui.filter.JBPatternFilter;
import org.eclipse.jubula.client.ui.provider.DecoratingCellLabelProvider;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.editors.PersistentObjectComparer;
import org.eclipse.jubula.client.ui.rcp.filter.JBFilteredTree;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.ComponentNameBrowserContentProvider;
import org.eclipse.jubula.client.ui.rcp.sorter.ComponentNameNameViewerSorter;
import org.eclipse.jubula.client.ui.rcp.utils.UIIdentitiyElementComparer;
import org.eclipse.jubula.client.ui.rcp.views.JBPropertiesPage;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class ComponentNameBrowser
extends ViewPart
implements DataEventDispatcher.IProjectLoadedListener,
ITreeViewerContainer,
IJBPart,
DataEventDispatcher.IDataChangedListener,
DataEventDispatcher.IProblemPropagationListener {
    public static final int DEFAULT_EXPANSION = 2;
    public static final String CONTEXT_MENU_ID = "ComponentNameBrowserContextMenuID";
    private TreeViewer m_treeViewer;

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        JBFilteredTree ft = new JBFilteredTree(composite, 2818, (PatternFilter)new JBPatternFilter(), true);
        ComponentNameBrowserContentProvider cp = new ComponentNameBrowserContentProvider();
        this.setTreeViewer(ft.getViewer());
        this.getTreeViewer().setContentProvider((IContentProvider)cp);
        this.getTreeViewer().setComparer((IElementComparer)new UIIdentitiyElementComparer());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer());
        DecoratingCellLabelProvider lp = new DecoratingCellLabelProvider((ILabelProvider)cp, Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)lp);
        this.getTreeViewer().setUseHashlookup(true);
        this.getTreeViewer().setAutoExpandLevel(2);
        this.getTreeViewer().setComparator((ViewerComparator)new ComponentNameNameViewerSorter());
        this.getTreeViewer().setComparer((IElementComparer)new PersistentObjectComparer());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.getTreeViewer());
        this.createTreeContextMenu(this.getViewSite());
        Plugin.getHelpSystem().setHelp(this.getTreeViewer().getControl(), "org.eclipse.jubula.client.ua.help.guidancerComponentNameBrowserContextId");
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
        ded.addProblemPropagationListener((DataEventDispatcher.IProblemPropagationListener)this);
        if (GeneralStorage.getInstance().getProject() != null) {
            this.handleProjectLoaded();
        }
    }

    public void setFocus() {
        this.getTreeViewer().getControl().setFocus();
    }

    public void handleProjectLoaded() {
        this.initTree();
    }

    public void dispose() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this);
        ded.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
        ded.removeProblemPropagationListener((DataEventDispatcher.IProblemPropagationListener)this);
        super.dispose();
    }

    protected void initTree() {
        final IProjectPO cProject = GeneralStorage.getInstance().getProject();
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean isCachingOn = NodePM.getInstance().isUseCache();
                if (!isCachingOn) {
                    NodePM.getInstance().setUseCache(true);
                }
                try {
                    ComponentNameBrowser.this.getTreeViewer().setInput((Object)cProject);
                }
                finally {
                    if (!isCachingOn) {
                        NodePM.getInstance().setUseCache(false);
                    }
                }
            }
        });
    }

    private void createTreeContextMenu(IViewSite viewSite) {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        viewSite.registerContextMenu(CONTEXT_MENU_ID, menuMgr, (ISelectionProvider)this.getTreeViewer());
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPropertySheetPage.class)) {
            return new JBPropertiesPage(false, null);
        }
        return super.getAdapter(adapter);
    }

    private void setTreeViewer(TreeViewer treeViewer) {
        this.m_treeViewer = treeViewer;
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        boolean refreshView = false;
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            if (e.getUpdateState() != DataEventDispatcher.UpdateState.onlyInEditor && (e.getPo() instanceof IComponentNamePO || e.getDataState() == DataEventDispatcher.DataState.Saved && e.getPo() instanceof IObjectMappingPO || e.getPo() instanceof ITestCasePO || e.getPo() instanceof ITestSuitePO)) {
                refreshView = true;
                break;
            }
            ++n2;
        }
        if (refreshView) {
            this.refreshInDisplayThread();
        }
    }

    public void problemPropagationFinished() {
        this.refreshInDisplayThread();
    }

    private void refreshInDisplayThread() {
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ComponentNameBrowser.this.refreshTree();
            }
        });
    }

    private void refreshTree() {
        Object[] expandedElements = this.getTreeViewer().getExpandedElements();
        ISelection selection = this.getTreeViewer().getSelection();
        this.getTreeViewer().refresh();
        this.getTreeViewer().setExpandedElements(expandedElements);
        this.getTreeViewer().setSelection(selection);
    }
}

