/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.wiki.ui.views;

import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.wiki.ui.i18n.Messages;
import org.eclipse.jubula.client.wiki.ui.utils.DescriptionUtil;
import org.eclipse.jubula.client.wiki.ui.utils.ProjectMarkupUtil;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DescriptionView
extends ViewPart
implements DataEventDispatcher.IDataChangedListener {
    public static final String VIEW_ID = "org.eclipse.jubula.client.wiki.ui.views.DescriptionView";
    private Browser m_browser;
    private MarkupParser m_markupParser;
    private INodePO m_selectedNode;
    private ISelectionListener m_listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
            if (sourcepart != DescriptionView.this) {
                this.showSelection(selection);
            }
        }

        private void showSelection(ISelection selection) {
            if (selection instanceof StructuredSelection) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                Object firstElement = structuredSelection.getFirstElement();
                if (firstElement instanceof INodePO) {
                    DescriptionView.this.m_selectedNode = (INodePO)firstElement;
                    DescriptionView.this.setDescriptionForBrowser(DescriptionView.this.m_selectedNode);
                    return;
                }
                DescriptionView.this.setBrowserNoDescriptionAvailable();
                return;
            }
            DescriptionView.this.setBrowserNoDescriptionAvailable();
        }
    };

    public void createPartControl(Composite parent) {
        this.m_browser = new Browser(parent, 0);
        DataEventDispatcher.getInstance().addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
        this.m_browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                event.doit = false;
            }

            public void changing(LocationEvent event) {
                if (event.location.matches("([a-zA-Z]{3,8})://?.*")) {
                    int idxOfSlashHash = event.location.indexOf("/#");
                    if (idxOfSlashHash != -1) {
                        if (!event.location.startsWith("file:///#")) {
                            event.doit = false;
                        }
                        return;
                    }
                    event.doit = false;
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().createBrowser("org.eclipse.ui.browser").openURL(new URL(event.location));
                    }
                    catch (Exception exception) {
                        new URLHyperlink((IRegion)new Region(0, 1), event.location).open();
                    }
                }
            }
        });
        this.m_markupParser = new MarkupParser();
        this.m_markupParser.setMarkupLanguage(ProjectMarkupUtil.getProjectMarkupLanguage());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.m_listener);
    }

    public void setFocus() {
        this.m_browser.setFocus();
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.m_listener);
        super.dispose();
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        boolean isRefreshNecessary = false;
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent dataChangedEvent = dataChangedEventArray[n2];
            if (dataChangedEvent.getPo() instanceof IProjectPropertiesPO) {
                this.m_markupParser.setMarkupLanguage(ProjectMarkupUtil.getProjectMarkupLanguage());
                isRefreshNecessary = true;
            }
            if (this.m_selectedNode != null && this.m_selectedNode.equals((Object)dataChangedEvent.getPo())) {
                isRefreshNecessary = true;
            }
            ++n2;
        }
        if (this.m_selectedNode != null && isRefreshNecessary) {
            this.setDescriptionForBrowser(this.m_selectedNode);
        }
    }

    private void setDescriptionForBrowser(INodePO element) {
        String description = this.m_selectedNode.getDescription();
        if (StringUtils.isBlank((String)description)) {
            description = DescriptionUtil.getReferenceDescription(this.m_selectedNode);
        }
        if (StringUtils.isNotBlank((String)description)) {
            this.m_browser.setText(this.m_markupParser.parseToHtml(description));
            return;
        }
        this.setBrowserNoDescriptionAvailable();
    }

    private void setBrowserNoDescriptionAvailable() {
        this.m_browser.setText(Messages.NoDescriptionAvailable);
    }
}

