/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IListComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITextComponent;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.adapter.JavaFXComponentAdapter;
import org.eclipse.jubula.rc.javafx.tester.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.tester.util.NodeTraverseHelper;
import org.eclipse.jubula.rc.javafx.tester.util.Rounding;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class ListViewAdapter<T extends ListView<?>>
extends JavaFXComponentAdapter<T>
implements IListComponent<ListCell<?>> {
    public ListViewAdapter(T objectToAdapt) {
        super(objectToAdapt);
    }

    public String getText() {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                ObservableList sItems = ((ListView)ListViewAdapter.this.getRealComponent()).getSelectionModel().getSelectedItems();
                if (!sItems.isEmpty()) {
                    return String.valueOf(sItems.get(0));
                }
                throw new StepExecutionException("No selection found", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
            }
        });
        return result;
    }

    public void clickOnIndex(final Integer index, ClickOptions co) {
        int actualItemCount = EventThreadQueuerJavaFXImpl.invokeAndWait("scrollIndexVisible", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ObservableList items = ((ListView)ListViewAdapter.this.getRealComponent()).getItems();
                int itemCount = items != null ? items.size() : -1;
                return new Integer(itemCount);
            }
        });
        if (index >= actualItemCount || index < 0) {
            throw new StepExecutionException("List index '" + index + "' is out of range", EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
        Rectangle r = EventThreadQueuerJavaFXImpl.invokeAndWait("scrollIndexVisible", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                ListView listView = (ListView)ListViewAdapter.this.getRealComponent();
                listView.scrollTo(index.intValue());
                listView.layout();
                List<ListCell> lCells = NodeTraverseHelper.getInstancesOf((Parent)listView, ListCell.class);
                for (ListCell cell : lCells) {
                    if (cell.getIndex() != index.intValue() || cell.getListView() != listView) continue;
                    Rectangle b = NodeBounds.getAbsoluteBounds((Node)cell);
                    Rectangle tableB = NodeBounds.getAbsoluteBounds((Node)listView);
                    double widthOfClickableRectangle = b.getWidth();
                    cell.prefWidth(cell.getHeight());
                    if (widthOfClickableRectangle > listView.getWidth()) {
                        widthOfClickableRectangle = listView.getWidth();
                    }
                    if (StringUtils.isBlank((String)cell.getText())) {
                        widthOfClickableRectangle = b.getWidth();
                    }
                    return new Rectangle(Math.abs(tableB.x - b.x), Math.abs(tableB.y - b.y), Rounding.round(widthOfClickableRectangle), Rounding.round(b.getHeight()));
                }
                return null;
            }
        });
        this.getRobot().click(this.getRealComponent(), r, co.setClickType(ClickOptions.ClickType.RELEASED));
    }

    public int[] getSelectedIndices() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedIndices", new Callable<int[]>(){

            @Override
            public int[] call() throws Exception {
                ObservableList sIndices = ((ListView)ListViewAdapter.this.getRealComponent()).getSelectionModel().getSelectedIndices();
                return ArrayUtils.toPrimitive((Integer[])((Integer[])sIndices.toArray((Object[])new Integer[0])));
            }
        });
    }

    public String[] getSelectedValues() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedValues", new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                ListView listView = (ListView)ListViewAdapter.this.getRealComponent();
                ObservableList sIndices = listView.getSelectionModel().getSelectedIndices();
                LinkedList<String> selectedValues = new LinkedList<String>();
                block0: for (Integer i : sIndices) {
                    int index = i;
                    listView.scrollTo(index);
                    listView.layout();
                    List<ListCell> lCells = NodeTraverseHelper.getInstancesOf((Parent)listView, ListCell.class);
                    for (ListCell cell : lCells) {
                        if (cell.getIndex() != index || cell.getListView() != listView) continue;
                        selectedValues.add(ListViewAdapter.this.getCellText(cell));
                        continue block0;
                    }
                }
                return selectedValues.toArray(new String[0]);
            }
        });
    }

    public String[] getValues() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getValues", new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                LinkedList<String> values = new LinkedList<String>();
                ListView listView = (ListView)ListViewAdapter.this.getRealComponent();
                ObservableList items = listView.getItems();
                int itemCount = items != null ? items.size() : -1;
                int i = 0;
                while (i < itemCount) {
                    listView.scrollTo(i);
                    listView.layout();
                    List<ListCell> lCells = NodeTraverseHelper.getInstancesOf((Parent)listView, ListCell.class);
                    for (ListCell cell : lCells) {
                        if (cell.getIndex() != i || cell.getListView() != listView) continue;
                        values.add(ListViewAdapter.this.getCellText(cell));
                        break;
                    }
                    ++i;
                }
                return values.toArray(new String[0]);
            }
        });
    }

    public String getPropertyValueOfCell(final String name, final ListCell<?> cell) {
        String prop = EventThreadQueuerJavaFXImpl.invokeAndWait("getProperty", new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    IComponent adapter = (IComponent)AdapterFactoryRegistry.getInstance().getAdapter(IComponent.class, (Object)cell);
                    if (adapter != null) {
                        return ((ITextComponent)adapter).getPropteryValue(name);
                    }
                    return null;
                }
                catch (RobotException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
            }
        });
        return String.valueOf(prop);
    }

    private String getCellText(ListCell<?> cell) {
        IComponent adapter = (IComponent)AdapterFactoryRegistry.getInstance().getAdapter(IComponent.class, cell);
        if (adapter != null && adapter instanceof ITextComponent) {
            return ((ITextComponent)adapter).getText();
        }
        return null;
    }

    public ListCell<?> getCell(final int index) {
        return (ListCell)EventThreadQueuerJavaFXImpl.invokeAndWait("getCell", new Callable<ListCell<?>>(){

            @Override
            public ListCell<?> call() throws Exception {
                ListView listView = (ListView)ListViewAdapter.this.getRealComponent();
                listView.scrollTo(index);
                listView.layout();
                List<ListCell> lCells = NodeTraverseHelper.getInstancesOf((Parent)listView, ListCell.class);
                for (ListCell cell : lCells) {
                    if (cell.getIndex() != index || cell.getListView() != listView) continue;
                    return cell;
                }
                return null;
            }
        });
    }

    public ListCell<?> getCell(final String value) {
        return (ListCell)EventThreadQueuerJavaFXImpl.invokeAndWait("getCell", new Callable<ListCell<?>>(){

            @Override
            public ListCell<?> call() throws Exception {
                ListView listView = (ListView)ListViewAdapter.this.getRealComponent();
                ObservableList items = listView.getItems();
                int itemCount = items != null ? items.size() : -1;
                int i = 0;
                while (i < itemCount) {
                    listView.scrollTo(i);
                    listView.layout();
                    List<ListCell> lCells = NodeTraverseHelper.getInstancesOf((Parent)listView, ListCell.class);
                    for (ListCell cell : lCells) {
                        if (cell.getIndex() != i || cell.getListView() != listView || !ListViewAdapter.this.getCellText(cell).equals(value)) continue;
                        return cell;
                    }
                    ++i;
                }
                return null;
            }
        });
    }
}

