/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester;

import java.awt.Point;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.eclipse.jubula.rc.common.driver.CheckWithTimeoutQueuer;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.AbstractTreeTester;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class JTreeTester
extends AbstractTreeTester {
    public void rcDragByTextPath(int mouseButton, String modifier, String pathType, int preAscend, String treeTextPath, String operator) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.rcSelect(pathType, preAscend, treeTextPath, operator, 0, 1, ValueSets.BinaryChoice.no.rcValue());
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropByTextPath(String pathType, int preAscend, String treeTextPath, String operator, int delayBeforeDrop) {
        try {
            this.rcSelect(pathType, preAscend, treeTextPath, operator, 0, 1, ValueSets.BinaryChoice.no.rcValue());
            JTreeTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcDragByIndexPath(int mouseButton, String modifier, String pathType, int preAscend, String treeIndexPath) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.rcSelectByIndices(pathType, preAscend, treeIndexPath, 0, 1, ValueSets.BinaryChoice.no.rcValue());
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    public void rcDropByIndexPath(String pathType, int preAscend, String treeIndexPath, int delayBeforeDrop) {
        try {
            this.rcSelectByIndices(pathType, preAscend, treeIndexPath, 0, 1, ValueSets.BinaryChoice.no.rcValue());
            JTreeTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        finally {
            DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
        }
    }

    public void rcVerifyTextAtMousePosition(final String text, final String operator, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait((String)"rcVerifyTextAtMousePosition", (long)timeout, (Runnable)new Runnable(){

            public void run() {
                JTreeTester.this.checkNodeText(new Object[]{JTreeTester.this.getNodeAtMousePosition()}, text, operator);
            }
        });
    }

    protected Object getNodeAtMousePosition() throws StepExecutionException {
        return this.getEventThreadQueuer().invokeAndWait("getNodeAtMousePosition", (IRunnable)new IRunnable<Object>(){

            public Object run() throws StepExecutionException {
                TreePath treePath;
                Point mousePosition = JTreeTester.this.getRobot().getCurrentMousePosition();
                Point treeLocation = ((JTree)JTreeTester.this.getRealComponent()).getLocationOnScreen();
                Point relativePos = new Point(mousePosition.x - treeLocation.x, mousePosition.y - treeLocation.y);
                int rowAtMousePosition = ((JTree)JTreeTester.this.getRealComponent()).getRowForLocation(relativePos.x, relativePos.y);
                if (rowAtMousePosition != -1 && (treePath = ((JTree)JTreeTester.this.getRealComponent()).getPathForLocation(relativePos.x, relativePos.y)) != null && treePath.getLastPathComponent() != null) {
                    return treePath.getLastPathComponent();
                }
                throw new StepExecutionException("No tree node found at mouse position.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
        });
    }
}

