/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the GraphicsComponent component from the base toolkit.
 * 
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2017-02-20T11:36:04.418Z")
public class GraphicsComponent implements org.eclipse.jubula.toolkit.base.components.GraphicsComponent {
            @NonNull protected IComponentIdentifier m_componentIdentifier;
            public GraphicsComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super();
                Validate.isTrue(componentIdentifier instanceof IComponentIdentifier);
                m_componentIdentifier = (IComponentIdentifier) componentIdentifier;
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param textSizeInPoints 
         *        the text size (in points)
         * @param timePerWordInMilliseconds 
         *        the time to wait per word (in milliseconds)
         * @param windowWidthInPixels 
         *        the window width in pixels
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP showText(@NonNull String text,@NonNull Integer textSizeInPoints,@NonNull Integer timePerWordInMilliseconds,@NonNull Integer windowWidthInPixels
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(textSizeInPoints, "Argument 'textSizeInPoints' must not be null"); //$NON-NLS-1$
            Validate.notNull(timePerWordInMilliseconds, "Argument 'timePerWordInMilliseconds' must not be null"); //$NON-NLS-1$
            Validate.notNull(windowWidthInPixels, "Argument 'windowWidthInPixels' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcShowText")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(textSizeInPoints)
                        .addParameter(timePerWordInMilliseconds)
                        .addParameter(windowWidthInPixels)
                        .build();
        }
        
        /**
         * 
         * @param exists 
         *        whether the component is expected to exist or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistence(@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyExists")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(exists)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param exists 
         *        whether the component is expected to exist or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistence(@NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyExists")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(exists)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablement(@NonNull Boolean enabled,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEnabled")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(enabled)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablement(@NonNull Boolean enabled
        ) throws IllegalArgumentException {
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEnabled")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(enabled)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkProperty(@NonNull String propertyName,@NonNull String propertyValue,@NonNull Operator operator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(propertyName, "Argument 'propertyName' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyValue, "Argument 'propertyValue' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyProperty")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(propertyName)
                        .addParameter(propertyValue)
                        .addParameter(operator.rcValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkProperty(@NonNull String propertyName,@NonNull String propertyValue,@NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(propertyName, "Argument 'propertyName' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyValue, "Argument 'propertyValue' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyProperty")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(propertyName)
                        .addParameter(propertyValue)
                        .addParameter(operator.rcValue())
                        .addParameter(0)
                        .build();
        }
        
        
        /**
         * 
         * @param hasFocus 
         *        whether focus is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkFocus(@NonNull Boolean hasFocus,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(hasFocus, "Argument 'hasFocus' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyFocus")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(hasFocus)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param hasFocus 
         *        whether focus is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkFocus(@NonNull Boolean hasFocus
        ) throws IllegalArgumentException {
            Validate.notNull(hasFocus, "Argument 'hasFocus' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyFocus")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(hasFocus)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP waitForComponent(@NonNull Integer timeoutInMs,@NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException {
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcWaitForComponent")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(timeoutInMs)
                        .addParameter(delayAfterVisibility)
                        .build();
        }
        /**
         * 
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP waitForComponent(@NonNull Integer delayAfterVisibility
        ) throws IllegalArgumentException {
            Validate.notNull(delayAfterVisibility, "Argument 'delayAfterVisibility' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcWaitForComponent")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(1000)
                        .addParameter(delayAfterVisibility)
                        .build();
        }
        
        /**
         * 
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP click(@NonNull Integer numberOfClicks,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcClick")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(numberOfClicks)
                        .addParameter(mouseButton.rcIntValue())
                        .build();
        }
        
        /**
         * 
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP clickInComponent(@NonNull Integer numberOfClicks,@NonNull InteractionMode mouseButton,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits
        ) throws IllegalArgumentException {
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcClickDirect")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(numberOfClicks)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectContextMenuEntryByTextpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String menupath,@NonNull Operator operator,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(menupath, "Argument 'menupath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupSelectByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(menupath)
                        .addParameter(operator.rcValue())
                        .addParameter(mouseButton.rcIntValue())
                        .build();
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectContextMenuEntryByIndexpath(@NonNull String indexpath,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupSelectByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(indexpath)
                        .addParameter(mouseButton.rcIntValue())
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectContextMenuEntryByTextpath(@NonNull String textpath,@NonNull Operator operator,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupSelectByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(mouseButton.rcIntValue())
                        .build();
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectContextMenuEntryByIndexpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String indexpath,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupSelectByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(indexpath)
                        .addParameter(mouseButton.rcIntValue())
                        .build();
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfContextMenuEntryByIndexpath(@NonNull String indexpath,@NonNull Boolean enabled,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyEnabledByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(indexpath)
                        .addParameter(enabled)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfContextMenuEntryByIndexpath(@NonNull String indexpath,@NonNull Boolean enabled,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyEnabledByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(indexpath)
                        .addParameter(enabled)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfContextMenuEntryByIndexpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String indexpath,@NonNull Boolean enabled,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyEnabledByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(indexpath)
                        .addParameter(enabled)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfContextMenuEntryByIndexpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String indexpath,@NonNull Boolean enabled,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyEnabledByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(indexpath)
                        .addParameter(enabled)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfContextMenuEntryByTextpath(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean enabled,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyEnabledByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(enabled)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfContextMenuEntryByTextpath(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean enabled,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyEnabledByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(enabled)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfContextMenuEntryByTextpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean enabled,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyEnabledByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(enabled)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfContextMenuEntryByTextpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean enabled,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyEnabledByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(enabled)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfContextMenuEntryByIndexpath(@NonNull String indexpath,@NonNull Boolean exists,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyExistsByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(indexpath)
                        .addParameter(exists)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfContextMenuEntryByIndexpath(@NonNull String indexpath,@NonNull Boolean exists,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyExistsByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(indexpath)
                        .addParameter(exists)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfContextMenuEntryByIndexpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String indexpath,@NonNull Boolean exists,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyExistsByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(indexpath)
                        .addParameter(exists)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfContextMenuEntryByIndexpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String indexpath,@NonNull Boolean exists,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyExistsByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(indexpath)
                        .addParameter(exists)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfContextMenuEntryByTextpath(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean exists,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyExistsByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfContextMenuEntryByTextpath(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean exists,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyExistsByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfContextMenuEntryByTextpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean exists,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyExistsByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfContextMenuEntryByTextpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean exists,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifyExistsByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfContextMenuEntryByIndexpath(@NonNull String indexpath,@NonNull Boolean selected,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifySelectedByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(indexpath)
                        .addParameter(selected)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfContextMenuEntryByIndexpath(@NonNull String indexpath,@NonNull Boolean selected,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifySelectedByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(indexpath)
                        .addParameter(selected)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfContextMenuEntryByIndexpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String indexpath,@NonNull Boolean selected,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifySelectedByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(indexpath)
                        .addParameter(selected)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfContextMenuEntryByIndexpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String indexpath,@NonNull Boolean selected,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(indexpath, "Argument 'indexpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifySelectedByIndexPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(indexpath)
                        .addParameter(selected)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfContextMenuEntryByTextpath(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean selected,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifySelectedByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(selected)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfContextMenuEntryByTextpath(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean selected,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifySelectedByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(selected)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfContextMenuEntryByTextpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean selected,@NonNull InteractionMode mouseButton,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifySelectedByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(selected)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfContextMenuEntryByTextpathSpecifyPosition(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean selected,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcPopupVerifySelectedByTextPath")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(selected)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP drag(@NonNull InteractionMode mouseButton,@NonNull Modifier[] modifierKeys,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits
        ) throws IllegalArgumentException {
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDrag")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP drop(@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDrop")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(delayBeforeDropMilliseconds)
                        .build();
        }
        
        
        /**
         * Use this to invoke the specified method
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeMethod(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(fullyQualifiedClassName, "Argument 'fullyQualifiedClassName' must not be null"); //$NON-NLS-1$
            Validate.notNull(methodName, "Argument 'methodName' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInvokeMethod")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(fullyQualifiedClassName)
                        .addParameter(methodName)
                        .addOptionalParameter(methodSignature)
                        .addOptionalParameter(methodArguments)
                        .addOptionalParameter(methodArgumentSeparator)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * Use this to invoke the specified method
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeMethod(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator
        ) throws IllegalArgumentException {
            Validate.notNull(fullyQualifiedClassName, "Argument 'fullyQualifiedClassName' must not be null"); //$NON-NLS-1$
            Validate.notNull(methodName, "Argument 'methodName' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInvokeMethod")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(fullyQualifiedClassName)
                        .addParameter(methodName)
                        .addOptionalParameter(methodSignature)
                        .addOptionalParameter(methodArguments)
                        .addOptionalParameter(methodArgumentSeparator)
                        .addParameter(3000)
                        .build();
        }
        
} 