/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the ApplicationActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2017-02-20T11:36:04.262Z")
@Beta
public interface ApplicationActionHandler {
    
    
        /**
         * Performs arbitrary clicks into the currently active AUT window
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public void clickInActiveWindow(
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        ) ;
        
        /**
         * 
         * @param activationMethod 
         *        the AUT activation method to use
         * 
         */
        public void activate(
            @Nullable AUTActivationMethod activationMethod
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * 
         */
        public void inputText(
            @Nullable String text
        ) ;
        
        /**
         * 
         * @param modifierKeys 
         *        the modifier keys
         * @param baseKey 
         *        the base key to use
         * 
         */
        public void keyCombination(
            @Nullable Modifier[] modifierKeys,
            @Nullable String baseKey
        ) ;
        
        /**
         * 
         * @param key 
         *        the toggle key
         * @param activateKey 
         *        the activate key
         * 
         */
        public void setToggleKey(
            @Nullable Integer key,
            @Nullable Boolean activateKey
        ) ;
        
        /**
         * 
         * @param millisecs 
         *        the amount of milliseconds
         * 
         */
        public void delay(
            @Nullable Integer millisecs
        ) ;
        
        public void pauseTestExecution(
        ) ;
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @since 4.1
         */
        public void waitForWindow(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs,
            @Nullable Integer delayAfterVisibility
        ) ;
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @since 4.1
         */
        public void waitForWindow(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Integer delayAfterVisibility
        ) ;
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @since 4.1
         */
        public void waitForWindowActivation(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs,
            @Nullable Integer delayAfterVisibility
        ) ;
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @since 4.1
         */
        public void waitForWindowActivation(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Integer delayAfterVisibility
        ) ;
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterClosure 
         *        the static delay after closure
         * @since 4.1
         */
        public void waitForWindowToClose(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs,
            @Nullable Integer delayAfterClosure
        ) ;
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param delayAfterClosure 
         *        the static delay after closure
         * @since 4.1
         */
        public void waitForWindowToClose(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Integer delayAfterClosure
        ) ;
        
        
        
        
        /**
         * 
         * @param destination 
         *        the destination to use
         * @param delay 
         *        the static delay
         * @param fileAccess 
         *        the file access type
         * @param scalingFactor 
         *        the scaling factor
         * @param createDirectories 
         *        whether to implicitly create directories
         * 
         */
        public void takeScreenshot(
            @Nullable String destination,
            @Nullable Integer delay,
            @Nullable String fileAccess,
            @Nullable Integer scalingFactor,
            @Nullable Boolean createDirectories
        ) ;
        
        
        /**
         * 
         * @param modifierKeys 
         *        the modifier keys
         * @param baseKey 
         *        the base key to use
         * 
         */
        public void externalKeyCombination(
            @Nullable Modifier[] modifierKeys,
            @Nullable String baseKey
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * 
         */
        public void externalInputText(
            @Nullable String text
        ) ;
        
        
        /**
         * 
         * @param text 
         *        the text to use
         * 
         */
        public void copyTextToClipboard(
            @Nullable String text
        ) ;
        
        
        
        /**
         * 
         * @param value1 
         *        the first value
         * @param comparisonMethod 
         *        the comparison method
         * @param value2 
         *        the second value
         * @since 4.0
         */
        public void checkNumericValues(
            @Nullable String value1,
            @Nullable NumberComparisonOperator comparisonMethod,
            @Nullable String value2
        ) ;
        
        /**
         * 
         * @param destination 
         *        the destination to use
         * @param delay 
         *        the static delay
         * @param fileAccess 
         *        the file access type
         * @param scalingFactor 
         *        the scaling factor
         * @param createDirectories 
         *        whether to implicitly create directories
         * @param marginTop 
         *        the top margin
         * @param marginRight 
         *        the right margin
         * @param marginBottom 
         *        the bottom margin
         * @param marginLeft 
         *        the left margin
         * 
         */
        public void takeScreenshotOfActiveWindow(
            @Nullable String destination,
            @Nullable Integer delay,
            @Nullable String fileAccess,
            @Nullable Integer scalingFactor,
            @Nullable Boolean createDirectories,
            @Nullable Integer marginTop,
            @Nullable Integer marginRight,
            @Nullable Integer marginBottom,
            @Nullable Integer marginLeft
        ) ;
        
        /**
         * 
         * @param value1 
         *        the first value
         * @param value2Operator 
         *        the operator used for comparison with value 2
         * @param value2 
         *        the second value
         * 
         */
        public void checkStringValues(
            @Nullable String value1,
            @Nullable String value2Operator,
            @Nullable String value2
        ) ;
        
        /**
         * 
         * @param operator 
         *        the operator used for comparison
         * @param text 
         *        the text to use
         * @since 4.1
         */
        public void checkTextInClipboard(
            @Nullable Operator operator,
            @Nullable String text
        ) ;
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public void checkExistenceOfWindow(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @since 4.1
         */
        public void checkExistenceOfWindow(
            @Nullable String title,
            @Nullable Operator operator,
            @Nullable Boolean exists
        ) ;
        
        
} 