/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TableComponent component from the concrete toolkit.
 * 
 */
@RealizedType(realizedType="guidancer.abstract.TextInputSupport")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2017-02-20T11:36:04.301Z")
public class TableComponent extends org.eclipse.jubula.toolkit.base.internal.impl.TextInputComponent implements org.eclipse.jubula.toolkit.concrete.components.TableComponent {
            public TableComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP inputTextSpecifyCell(@NonNull String text,@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInputText")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .build();
        }
        
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP replaceTextSpecifyCell(@NonNull String text,@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcReplaceText")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectCell(@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator,@NonNull Integer numberOfClicks,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull BinaryChoice extendSelection,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectCell")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(numberOfClicks)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(extendSelection.rcValue())
                        .addParameter(mouseButton.rcIntValue())
                        .build();
        }
        
        /**
         * 
         * @param direction 
         *        the direction
         * @param numberOfCells 
         *        the number of cells
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP move(@NonNull Direction direction,@NonNull Integer numberOfCells,@NonNull Integer numberOfClicks,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull BinaryChoice extendSelection
        ) throws IllegalArgumentException {
            Validate.notNull(direction, "Argument 'direction' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfCells, "Argument 'numberOfCells' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcMove")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(direction.rcValue())
                        .addParameter(numberOfCells)
                        .addParameter(numberOfClicks)
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(extendSelection.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilitySpecifyCell(@NonNull Boolean editable,@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEditable")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(editable)
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilitySpecifyCell(@NonNull Boolean editable,@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator
        ) throws IllegalArgumentException {
            Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEditable")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(editable)
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilityOfSelectedCell(@NonNull Boolean editable,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEditableSelected")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(editable)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilityOfSelectedCell(@NonNull Boolean editable
        ) throws IllegalArgumentException {
            Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEditableSelected")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(editable)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilityOfCellMousePosition(@NonNull Boolean editable,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEditableMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(editable)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilityOfCellMousePosition(@NonNull Boolean editable
        ) throws IllegalArgumentException {
            Validate.notNull(editable, "Argument 'editable' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEditableMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(editable)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTextSpecifyCell(@NonNull String text,@NonNull Operator textOperator,@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(textOperator, "Argument 'textOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyText")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(textOperator.rcValue())
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTextSpecifyCell(@NonNull String text,@NonNull Operator textOperator,@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(textOperator, "Argument 'textOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyText")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(textOperator.rcValue())
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTextMousePosition(@NonNull String text,@NonNull Operator operator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyTextAtMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTextMousePosition(@NonNull String text,@NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyTextAtMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfValueInRow(@NonNull String row,@NonNull Operator rowOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyValueInRow")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(value)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(searchType.rcValue())
                        .addParameter(exists)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfValueInRow(@NonNull String row,@NonNull Operator rowOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType,@NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyValueInRow")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(value)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(searchType.rcValue())
                        .addParameter(exists)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfValueInColumn(@NonNull String column,@NonNull Operator columnOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyValueInColumn")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(value)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(searchType.rcValue())
                        .addParameter(exists)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfValueInColumn(@NonNull String column,@NonNull Operator columnOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType,@NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyValueInColumn")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(value)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(searchType.rcValue())
                        .addParameter(exists)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectValueFromColumn(@NonNull String column,@NonNull Operator columnOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull Integer numberOfClicks,@NonNull BinaryChoice extendSelection,@NonNull SearchType searchType,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectRowByValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(value)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(numberOfClicks)
                        .addParameter(extendSelection.rcValue())
                        .addParameter(searchType.rcValue())
                        .addParameter(mouseButton.rcIntValue())
                        .build();
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectValueFromRow(@NonNull String row,@NonNull Operator rowOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull Integer numberOfClicks,@NonNull BinaryChoice extendSelection,@NonNull SearchType searchType,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(extendSelection, "Argument 'extendSelection' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectCellByColValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(value)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(numberOfClicks)
                        .addParameter(extendSelection.rcValue())
                        .addParameter(searchType.rcValue())
                        .addParameter(mouseButton.rcIntValue())
                        .build();
        }
        
        
        /**
         * CompSystem.ReadTableCellValueAPI.descr
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.0
         */
        @NonNull public CAP getValueSpecifyCell(@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator
        ) throws IllegalArgumentException {
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcReadValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .build();
        }
        
        
        /**
         * Use this action to read the value in the cell where the mouse is currently placed so that you can use the value in the cell as data for other Test Steps
         * @since 4.0
         */
        @NonNull public CAP getValueAtMousePosition(
        )  {
            
            return new CapBuilder("rcReadValueAtMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .build();
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dragCell(@NonNull InteractionMode mouseButton,@NonNull Modifier[] modifierKeys,@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits
        ) throws IllegalArgumentException {
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDragCell")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dropOnCell(@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDropCell")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(delayBeforeDropMilliseconds)
                        .build();
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dragCellFromColumn(@NonNull InteractionMode mouseButton,@NonNull Modifier[] modifierKeys,@NonNull String column,@NonNull Operator columnOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType
        ) throws IllegalArgumentException {
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDragRowByValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(value)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(searchType.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dropOnCellFromColumn(@NonNull String column,@NonNull Operator columnOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType,@NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDropRowByValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(value)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(searchType.rcValue())
                        .addParameter(delayBeforeDropMilliseconds)
                        .build();
        }
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dragCellFromRow(@NonNull InteractionMode mouseButton,@NonNull Modifier[] modifierKeys,@NonNull String row,@NonNull Operator rowOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType
        ) throws IllegalArgumentException {
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDragCellByColValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(value)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(searchType.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dropOnCellFromRow(@NonNull String row,@NonNull Operator rowOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType,@NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            Validate.notNull(row, "Argument 'row' must not be null"); //$NON-NLS-1$
            Validate.notNull(rowOperator, "Argument 'rowOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(value, "Argument 'value' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDropCellByColValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(row)
                        .addParameter(rowOperator.rcValue())
                        .addParameter(value)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(searchType.rcValue())
                        .addParameter(delayBeforeDropMilliseconds)
                        .build();
        }
        
        /**
         * 
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfCheckboxInSelectedRow(@NonNull Boolean checked,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(checked, "Argument 'checked' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyCheckboxInSelectedRow")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(checked)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param checked 
         *        Checked
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfCheckboxInSelectedRow(@NonNull Boolean checked
        ) throws IllegalArgumentException {
            Validate.notNull(checked, "Argument 'checked' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyCheckboxInSelectedRow")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(checked)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfCheckboxAtMousePosition(@NonNull Boolean checked,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(checked, "Argument 'checked' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyCheckboxInRowAtMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(checked)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param checked 
         *        Checked
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfCheckboxAtMousePosition(@NonNull Boolean checked
        ) throws IllegalArgumentException {
            Validate.notNull(checked, "Argument 'checked' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyCheckboxInRowAtMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(checked)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * 
         */
        @NonNull public CAP toggleCheckboxInSelectedRow(
        )  {
            
            return new CapBuilder("rcToggleCheckboxInSelectedRow")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .build();
        }
        
        /**
         * 
         * 
         */
        @NonNull public CAP toggleCheckboxAtMousePosition(
        )  {
            
            return new CapBuilder("rcToggleCheckboxInRowAtMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .build();
        }
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkPropertyAtMousePosition(@NonNull String propertyName,@NonNull String propertyValue,@NonNull Operator operator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(propertyName, "Argument 'propertyName' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyValue, "Argument 'propertyValue' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckPropertyAtMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(propertyName)
                        .addParameter(propertyValue)
                        .addParameter(operator.rcValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkPropertyAtMousePosition(@NonNull String propertyName,@NonNull String propertyValue,@NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(propertyName, "Argument 'propertyName' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyValue, "Argument 'propertyValue' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckPropertyAtMousePosition")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(propertyName)
                        .addParameter(propertyValue)
                        .addParameter(operator.rcValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfColumn(@NonNull String column,@NonNull Operator columnOperator,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckExistenceOfColumn")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(exists)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfColumn(@NonNull String column,@NonNull Operator columnOperator,@NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(column, "Argument 'column' must not be null"); //$NON-NLS-1$
            Validate.notNull(columnOperator, "Argument 'columnOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckExistenceOfColumn")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(column)
                        .addParameter(columnOperator.rcValue())
                        .addParameter(exists)
                        .addParameter(0)
                        .build();
        }
        
} 